/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.jwt.authz;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.biz.authc.AuthcResponse;
import org.apache.shiro.biz.authc.AuthcResponseCode;
import org.apache.shiro.biz.authz.AuthorizationFailureHandler;
import org.apache.shiro.biz.utils.SubjectUtils;
import org.apache.shiro.biz.utils.WebUtils;
import org.apache.shiro.spring.boot.jwt.ShiroJwtMessageSource;
import org.apache.shiro.spring.boot.jwt.authc.JwtAuthenticationFailureHandler;
import org.apache.shiro.spring.boot.jwt.exception.ExpiredJwtException;
import org.apache.shiro.spring.boot.jwt.exception.IncorrectJwtException;
import org.apache.shiro.spring.boot.jwt.exception.InvalidJwtToken;
import org.apache.shiro.spring.boot.jwt.exception.NotObtainedJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;

public class JwtAuthorizationFailureHandler
implements AuthorizationFailureHandler {
    protected MessageSourceAccessor messages = ShiroJwtMessageSource.getAccessor();
    private static final Logger LOG = LoggerFactory.getLogger(JwtAuthenticationFailureHandler.class);

    public boolean supports(AuthenticationException ex) {
        return SubjectUtils.isAssignableFrom(((Object)((Object)ex)).getClass(), (Class[])new Class[]{ExpiredJwtException.class, IncorrectJwtException.class, InvalidJwtToken.class, NotObtainedJwtException.class});
    }

    public boolean onAuthorizationFailure(Object mappedValue, AuthenticationException ex, ServletRequest request, ServletResponse response) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        try {
            WebUtils.toHttp((ServletResponse)response).setStatus(401);
            response.setContentType("application/json;charset=UTF-8");
            if (ex instanceof ExpiredJwtException) {
                JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthcResponse.error((String)AuthcResponseCode.SC_AUTHZ_TOKEN_EXPIRED.getCode(), (String)this.messages.getMessage(AuthcResponseCode.SC_AUTHZ_TOKEN_EXPIRED.getMsgKey(), ex.getMessage())), (SerializerFeature[])new SerializerFeature[0]);
            } else if (ex instanceof IncorrectJwtException) {
                JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthcResponse.error((String)AuthcResponseCode.SC_AUTHZ_TOKEN_INCORRECT.getCode(), (String)this.messages.getMessage(AuthcResponseCode.SC_AUTHZ_TOKEN_INCORRECT.getMsgKey(), ex.getMessage())), (SerializerFeature[])new SerializerFeature[0]);
            } else if (ex instanceof InvalidJwtToken) {
                JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthcResponse.error((String)AuthcResponseCode.SC_AUTHZ_TOKEN_INVALID.getCode(), (String)this.messages.getMessage(AuthcResponseCode.SC_AUTHZ_TOKEN_INVALID.getMsgKey(), ex.getMessage())), (SerializerFeature[])new SerializerFeature[0]);
            } else if (ex instanceof NotObtainedJwtException) {
                JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthcResponse.error((String)AuthcResponseCode.SC_AUTHZ_TOKEN_REQUIRED.getCode(), (String)this.messages.getMessage(AuthcResponseCode.SC_AUTHZ_TOKEN_REQUIRED.getMsgKey(), ex.getMessage())), (SerializerFeature[])new SerializerFeature[0]);
            } else {
                JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthcResponse.error((String)AuthcResponseCode.SC_AUTHC_FAIL.getCode(), (String)this.messages.getMessage(AuthcResponseCode.SC_AUTHC_FAIL.getMsgKey())), (SerializerFeature[])new SerializerFeature[0]);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthcResponse.error((String)"Unauthentication."), (SerializerFeature[])new SerializerFeature[0]);
        }
        return false;
    }
}

