/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.jwt.authz;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.biz.authc.AuthcResponse;
import org.apache.shiro.biz.utils.StringUtils;
import org.apache.shiro.biz.utils.WebUtils;
import org.apache.shiro.biz.web.filter.authz.AbstracAuthorizationFilter;
import org.apache.shiro.spring.boot.jwt.JwtPayloadRepository;
import org.apache.shiro.spring.boot.jwt.ShiroJwtMessageSource;
import org.apache.shiro.spring.boot.jwt.exception.InvalidJwtToken;
import org.apache.shiro.spring.boot.jwt.token.JwtAccessToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;

public class JwtAuthorizationFilter
extends AbstracAuthorizationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JwtAuthorizationFilter.class);
    protected MessageSourceAccessor messages = ShiroJwtMessageSource.getAccessor();
    protected static final String AUTHORIZATION_HEADER = "X-Authorization";
    protected static final String AUTHORIZATION_PARAM = "token";
    private String authorizationHeaderName = "X-Authorization";
    private String authorizationParamName = "token";
    private String authorizationCookieName = "token";
    private JwtPayloadRepository jwtPayloadRepository;
    private boolean checkExpiry = false;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        if (this.isJwtSubmission(request, response)) {
            AuthenticationToken token = this.createJwtToken(request, response);
            try {
                Subject subject = this.getSubject(request, response);
                subject.login(token);
                boolean accessAllowed = this.getJwtPayloadRepository().verify(token, subject, request, response, this.isCheckExpiry());
                if (!accessAllowed) {
                    throw new InvalidJwtToken("Invalid JWT value.");
                }
                return this.onAccessSuccess(mappedValue, subject, request, response);
            }
            catch (AuthenticationException e) {
                return this.onAccessFailure(mappedValue, e, request, response);
            }
        }
        String mString = String.format("Attempting to access a path which requires authentication.  %s = Authorization Header or %s = Authorization Param or %s = Authorization Cookie  is not present in the request", this.getAuthorizationHeaderName(), this.getAuthorizationParamName(), this.getAuthorizationCookieName());
        if (LOG.isTraceEnabled()) {
            LOG.trace(mString);
        }
        WebUtils.toHttp((ServletResponse)response).setStatus(401);
        response.setContentType("application/json;charset=UTF-8");
        JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthcResponse.fail((String)mString), (SerializerFeature[])new SerializerFeature[0]);
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        return false;
    }

    protected AuthenticationToken createJwtToken(ServletRequest request, ServletResponse response) {
        String host = WebUtils.getRemoteAddr((ServletRequest)request);
        String jwtToken = this.getAccessToken(request);
        return new JwtAccessToken(host, jwtToken, false);
    }

    protected boolean isJwtSubmission(ServletRequest request, ServletResponse response) {
        String authzHeader = this.getAccessToken(request);
        return request instanceof HttpServletRequest && authzHeader != null;
    }

    protected String getAccessToken(ServletRequest request) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        String token = httpRequest.getHeader(this.getAuthorizationHeaderName());
        if (StringUtils.isEmpty((Object)token)) {
            return httpRequest.getParameter(this.getAuthorizationParamName());
        }
        if (StringUtils.isEmpty((Object)token)) {
            Cookie[] cookies = httpRequest.getCookies();
            if (null == cookies || cookies.length == 0) {
                return null;
            }
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.getAuthorizationCookieName())) continue;
                token = cookie.getValue();
                break;
            }
        }
        return token;
    }

    public String getAuthorizationHeaderName() {
        return this.authorizationHeaderName;
    }

    public void setAuthorizationHeaderName(String authorizationHeaderName) {
        this.authorizationHeaderName = authorizationHeaderName;
    }

    public String getAuthorizationParamName() {
        return this.authorizationParamName;
    }

    public void setAuthorizationParamName(String authorizationParamName) {
        this.authorizationParamName = authorizationParamName;
    }

    public String getAuthorizationCookieName() {
        return this.authorizationCookieName;
    }

    public void setAuthorizationCookieName(String authorizationCookieName) {
        this.authorizationCookieName = authorizationCookieName;
    }

    public JwtPayloadRepository getJwtPayloadRepository() {
        return this.jwtPayloadRepository;
    }

    public void setJwtPayloadRepository(JwtPayloadRepository jwtPayloadRepository) {
        this.jwtPayloadRepository = jwtPayloadRepository;
    }

    public boolean isCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }
}

