/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.ecommerceprofitsharing;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.AddReceiverRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.AddReceiverResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.CreateAfterSalesOrderRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.CreateAfterSalesOrderResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.CreateOrderRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.CreateOrderResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.CreateReturnOrderRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.CreateReturnOrderResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.DeleteReceiverRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.DeleteReceiverResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.FinishOrderRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.FinishOrderResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryAfterSalesOrderRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryAfterSalesOrderResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryOrderAmountRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryOrderAmountResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryOrderRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryOrderResponse;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryReturnOrderRequest;
import com.wechat.pay.java.service.ecommerceprofitsharing.model.QueryReturnOrderResponse;
import java.util.Objects;

public class EcommerceProfitSharingService {
    private final HttpClient httpClient;
    private final HostName hostName;
    private final PrivacyEncryptor encryptor;

    private EcommerceProfitSharingService(HttpClient httpClient, HostName hostName, PrivacyEncryptor encryptor) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
        this.encryptor = Objects.requireNonNull(encryptor);
    }

    public CreateAfterSalesOrderResponse createAfterSalesOrder(CreateAfterSalesOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/after-sales-orders";
        CreateAfterSalesOrderRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CreateAfterSalesOrderResponse.class);
        return (CreateAfterSalesOrderResponse)httpResponse.getServiceResponse();
    }

    public CreateOrderResponse createOrder(CreateOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/orders";
        CreateOrderRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CreateOrderResponse.class);
        return (CreateOrderResponse)httpResponse.getServiceResponse();
    }

    public FinishOrderResponse finishOrder(FinishOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/finish-order";
        FinishOrderRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, FinishOrderResponse.class);
        return (FinishOrderResponse)httpResponse.getServiceResponse();
    }

    public QueryAfterSalesOrderResponse queryAfterSalesOrder(QueryAfterSalesOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/after-sales-orders";
        QueryAfterSalesOrderRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getTransactionId() != null) {
            queryParameter.add("transaction_id", (Object)UrlEncoder.urlEncode((String)realRequest.getTransactionId()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryAfterSalesOrderResponse.class);
        return (QueryAfterSalesOrderResponse)httpResponse.getServiceResponse();
    }

    public QueryOrderResponse queryOrder(QueryOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/orders";
        QueryOrderRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getTransactionId() != null) {
            queryParameter.add("transaction_id", (Object)UrlEncoder.urlEncode((String)realRequest.getTransactionId()));
        }
        if (realRequest.getOutOrderNo() != null) {
            queryParameter.add("out_order_no", (Object)UrlEncoder.urlEncode((String)realRequest.getOutOrderNo()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryOrderResponse.class);
        return (QueryOrderResponse)httpResponse.getServiceResponse();
    }

    public QueryOrderAmountResponse queryOrderAmount(QueryOrderAmountRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/orders/{transaction_id}/amounts";
        QueryOrderAmountRequest realRequest = request;
        requestPath = requestPath.replace("{transaction_id}", UrlEncoder.urlEncode((String)realRequest.getTransactionId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryOrderAmountResponse.class);
        return (QueryOrderAmountResponse)httpResponse.getServiceResponse();
    }

    public AddReceiverResponse addReceiver(AddReceiverRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/receivers/add";
        AddReceiverRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AddReceiverResponse.class);
        return (AddReceiverResponse)httpResponse.getServiceResponse();
    }

    public DeleteReceiverResponse deleteReceiver(DeleteReceiverRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/receivers/delete";
        DeleteReceiverRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DeleteReceiverResponse.class);
        return (DeleteReceiverResponse)httpResponse.getServiceResponse();
    }

    public CreateReturnOrderResponse createReturnOrder(CreateReturnOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/returnorders";
        CreateReturnOrderRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CreateReturnOrderResponse.class);
        return (CreateReturnOrderResponse)httpResponse.getServiceResponse();
    }

    public QueryReturnOrderResponse queryReturnOrder(QueryReturnOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/profitsharing/returnorders";
        QueryReturnOrderRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getOutReturnNo() != null) {
            queryParameter.add("out_return_no", (Object)UrlEncoder.urlEncode((String)realRequest.getOutReturnNo()));
        }
        if (realRequest.getOrderId() != null) {
            queryParameter.add("order_id", (Object)UrlEncoder.urlEncode((String)realRequest.getOrderId()));
        }
        if (realRequest.getOutOrderNo() != null) {
            queryParameter.add("out_order_no", (Object)UrlEncoder.urlEncode((String)realRequest.getOutOrderNo()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, QueryReturnOrderResponse.class);
        return (QueryReturnOrderResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;
        private PrivacyEncryptor encryptor;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            this.encryptor = config.createEncryptor();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder encryptor(PrivacyEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public EcommerceProfitSharingService build() {
            return new EcommerceProfitSharingService(this.httpClient, this.hostName, this.encryptor);
        }
    }
}

