/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.giftactivity;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.giftactivity.model.AddActivityMerchantRequest;
import com.wechat.pay.java.service.giftactivity.model.AddActivityMerchantResponse;
import com.wechat.pay.java.service.giftactivity.model.CreateFullSendActRequest;
import com.wechat.pay.java.service.giftactivity.model.CreateFullSendActResponse;
import com.wechat.pay.java.service.giftactivity.model.DeleteActivityMerchantRequest;
import com.wechat.pay.java.service.giftactivity.model.DeleteActivityMerchantResponse;
import com.wechat.pay.java.service.giftactivity.model.GetActDetailRequest;
import com.wechat.pay.java.service.giftactivity.model.GetActDetailResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActMchResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActSkuResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActivitiesRequest;
import com.wechat.pay.java.service.giftactivity.model.ListActivitiesResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActivityMerchantRequest;
import com.wechat.pay.java.service.giftactivity.model.ListActivitySkuRequest;
import com.wechat.pay.java.service.giftactivity.model.TerminateActResponse;
import com.wechat.pay.java.service.giftactivity.model.TerminateActivityRequest;
import java.util.Objects;

public class GiftActivityService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private GiftActivityService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public AddActivityMerchantResponse addActivityMerchant(AddActivityMerchantRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/merchants/add";
        AddActivityMerchantRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, AddActivityMerchantResponse.class);
        return (AddActivityMerchantResponse)httpResponse.getServiceResponse();
    }

    public CreateFullSendActResponse createFullSendAct(CreateFullSendActRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/unique-threshold-activity";
        CreateFullSendActRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CreateFullSendActResponse.class);
        return (CreateFullSendActResponse)httpResponse.getServiceResponse();
    }

    public DeleteActivityMerchantResponse deleteActivityMerchant(DeleteActivityMerchantRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/merchants/delete";
        DeleteActivityMerchantRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, DeleteActivityMerchantResponse.class);
        return (DeleteActivityMerchantResponse)httpResponse.getServiceResponse();
    }

    public GetActDetailResponse getActDetail(GetActDetailRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}";
        GetActDetailRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, GetActDetailResponse.class);
        return (GetActDetailResponse)httpResponse.getServiceResponse();
    }

    public ListActivitiesResponse listActivities(ListActivitiesRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities";
        ListActivitiesRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getActivityName() != null) {
            queryParameter.add("activity_name", (Object)UrlEncoder.urlEncode((String)realRequest.getActivityName()));
        }
        if (realRequest.getActivityStatus() != null) {
            queryParameter.add("activity_status", (Object)UrlEncoder.urlEncode((String)realRequest.getActivityStatus().toString()));
        }
        if (realRequest.getAwardType() != null) {
            queryParameter.add("award_type", (Object)UrlEncoder.urlEncode((String)realRequest.getAwardType().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ListActivitiesResponse.class);
        return (ListActivitiesResponse)httpResponse.getServiceResponse();
    }

    public ListActMchResponse listActivityMerchant(ListActivityMerchantRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/merchants";
        ListActivityMerchantRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ListActMchResponse.class);
        return (ListActMchResponse)httpResponse.getServiceResponse();
    }

    public ListActSkuResponse listActivitySku(ListActivitySkuRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/goods";
        ListActivitySkuRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, ListActSkuResponse.class);
        return (ListActSkuResponse)httpResponse.getServiceResponse();
    }

    public TerminateActResponse terminateActivity(TerminateActivityRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/terminate";
        TerminateActivityRequest realRequest = request;
        requestPath = requestPath.replace("{activity_id}", UrlEncoder.urlEncode((String)realRequest.getActivityId()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TerminateActResponse.class);
        return (TerminateActResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public GiftActivityService build() {
            return new GiftActivityService(this.httpClient, this.hostName);
        }
    }
}

