/*
 * Decompiled with CFR 0.152.
 */
package org.wf.jwtp.configuration;

import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.wf.jwtp.TokenInterceptor;
import org.wf.jwtp.configuration.JwtPermissionProperties;
import org.wf.jwtp.perm.RestUrlPerm;
import org.wf.jwtp.perm.SimpleUrlPerm;
import org.wf.jwtp.perm.UrlPerm;
import org.wf.jwtp.provider.JdbcTokenStore;
import org.wf.jwtp.provider.RedisTokenStore;
import org.wf.jwtp.provider.TokenStore;

@EnableConfigurationProperties(value={JwtPermissionProperties.class})
public class JwtPermissionConfiguration
implements WebMvcConfigurer,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    @Autowired
    private JwtPermissionProperties properties;

    @ConditionalOnProperty(name={"jwtp.store-type"}, havingValue="0")
    @Bean
    public TokenStore redisTokenStore() {
        DataSource dataSource = this.getBean(DataSource.class);
        StringRedisTemplate stringRedisTemplate = this.getBean(StringRedisTemplate.class);
        if (stringRedisTemplate == null) {
            this.logger.error((Object)"JWTP: StringRedisTemplate is null");
        }
        return new RedisTokenStore(stringRedisTemplate, dataSource);
    }

    @ConditionalOnProperty(name={"jwtp.store-type"}, havingValue="1")
    @Bean
    public TokenStore jdbcTokenStore() {
        DataSource dataSource = this.getBean(DataSource.class);
        if (dataSource == null) {
            this.logger.error((Object)"JWTP: DataSource is null");
        }
        return new JdbcTokenStore(dataSource);
    }

    @ConditionalOnProperty(name={"jwtp.url-perm-type"}, havingValue="0")
    @Bean
    public UrlPerm simpleUrlPerm() {
        return new SimpleUrlPerm();
    }

    @ConditionalOnProperty(name={"jwtp.url-perm-type"}, havingValue="1")
    @Bean
    public UrlPerm restUrlPerm() {
        return new RestUrlPerm();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        TokenStore tokenStore = this.getBean(TokenStore.class);
        if (tokenStore != null) {
            tokenStore.setMaxToken(this.properties.getMaxToken());
            tokenStore.setFindRolesSql(this.properties.getFindRolesSql());
            tokenStore.setFindPermissionsSql(this.properties.getFindPermissionsSql());
        } else {
            this.logger.error((Object)"JWTP: Unknown TokenStore");
        }
        UrlPerm urlPerm = this.getBean(UrlPerm.class);
        String[] path = this.properties.getPath();
        String[] excludePath = this.properties.getExcludePath();
        TokenInterceptor interceptor = new TokenInterceptor(tokenStore, urlPerm);
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(path).excludePathPatterns(excludePath);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private <T> T getBean(Class<T> clazz) {
        T bean = null;
        Collection beans = this.applicationContext.getBeansOfType(clazz).values();
        while (beans.iterator().hasNext() && (bean = (T)beans.iterator().next()) == null) {
        }
        return bean;
    }
}

