/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.repository;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.common.RouteUtils;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaApplication;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaInstance;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaRoute;
import com.github.xiaoymin.knife4j.aggre.repository.AbsctractRepository;
import com.github.xiaoymin.knife4j.aggre.spring.support.EurekaSetting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaRepository
extends AbsctractRepository {
    Logger logger = LoggerFactory.getLogger(EurekaRepository.class);
    private EurekaSetting eurekaSetting;
    private List<EurekaApplication> eurekaApplications = new ArrayList<EurekaApplication>();

    public EurekaRepository(EurekaSetting eurekaSetting) {
        this.eurekaSetting = eurekaSetting;
        if (eurekaSetting != null && CollectionUtil.isNotEmpty(eurekaSetting.getRoutes())) {
            if (StrUtil.isBlank((CharSequence)eurekaSetting.getServiceUrl())) {
                throw new RuntimeException("Eureka ServiceUrl can't empty!!!");
            }
            this.initEurekaApps(eurekaSetting);
            this.applyRoutes(eurekaSetting);
        }
    }

    private void initEurekaApps(EurekaSetting eurekaSetting) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(eurekaSetting.getServiceUrl());
        if (!StrUtil.endWith((CharSequence)eurekaSetting.getServiceUrl(), (CharSequence)"/")) {
            requestUrl.append("/");
        }
        requestUrl.append("apps");
        String eurekaMetaApi = requestUrl.toString();
        this.logger.info("Eureka meta api:{}", (Object)eurekaMetaApi);
        HttpGet get = new HttpGet(eurekaMetaApi);
        get.addHeader("Accept", "application/json");
        try {
            CloseableHttpResponse response;
            if (eurekaSetting.getServiceAuth() != null && eurekaSetting.getServiceAuth().isEnable()) {
                get.addHeader("Authorization", RouteUtils.authorize(eurekaSetting.getServiceAuth().getUsername(), eurekaSetting.getServiceAuth().getPassword()));
            }
            if ((response = this.getClient().execute((HttpUriRequest)get)) != null) {
                Type type;
                List eurekaApps;
                JsonElement application;
                JsonElement applications;
                JsonElement jsonElement;
                String content;
                int statusCode = response.getStatusLine().getStatusCode();
                this.logger.info("Eureka Response code:{}", (Object)statusCode);
                if (statusCode == 200 && StrUtil.isNotBlank((CharSequence)(content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"))) && (jsonElement = JsonParser.parseString((String)content)) != null && jsonElement.isJsonObject() && (applications = jsonElement.getAsJsonObject().get("applications")) != null && applications.isJsonObject() && (application = applications.getAsJsonObject().get("application")) != null && CollectionUtil.isNotEmpty((Collection)(eurekaApps = (List)new Gson().fromJson(application, type = new TypeToken<List<EurekaApplication>>(){}.getType())))) {
                    this.eurekaApplications.addAll(eurekaApps);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("load Register Metadata from Eureka Error,message:" + e.getMessage(), (Throwable)e);
        }
    }

    private void applyRoutes(EurekaSetting eurekaSetting) {
        if (CollectionUtil.isNotEmpty(this.eurekaApplications)) {
            List serviceNames = eurekaSetting.getRoutes().stream().map(EurekaRoute::getServiceName).map(String::toLowerCase).collect(Collectors.toList());
            for (EurekaApplication eurekaApplication : this.eurekaApplications) {
                Optional<EurekaRoute> eurekaRouteOptional;
                Optional<EurekaInstance> instanceOptional;
                if (!serviceNames.contains(eurekaApplication.getName().toLowerCase()) || !CollectionUtil.isNotEmpty(eurekaApplication.getInstance()) || !(instanceOptional = eurekaApplication.getInstance().stream().filter(eurekaInstance -> StrUtil.equalsIgnoreCase((CharSequence)eurekaInstance.getStatus(), (CharSequence)"up")).findFirst()).isPresent() || !(eurekaRouteOptional = eurekaSetting.getRoutes().stream().filter(eurekaRoute -> StrUtil.equalsIgnoreCase((CharSequence)eurekaRoute.getServiceName(), (CharSequence)eurekaApplication.getName())).findFirst()).isPresent()) continue;
                EurekaRoute eurekaRoute2 = eurekaRouteOptional.get();
                EurekaInstance eurekaInstance2 = instanceOptional.get();
                if (eurekaRoute2.getRouteAuth() == null || !eurekaRoute2.getRouteAuth().isEnable()) {
                    eurekaRoute2.setRouteAuth(eurekaSetting.getRouteAuth());
                }
                this.routeMap.put(eurekaRoute2.pkId(), new SwaggerRoute(eurekaRoute2, eurekaInstance2));
            }
        }
    }

    @Override
    public BasicAuth getAuth(String header) {
        BasicAuth basicAuth = null;
        if (this.eurekaSetting != null && CollectionUtil.isNotEmpty(this.eurekaSetting.getRoutes())) {
            if (this.eurekaSetting.getRouteAuth() != null && this.eurekaSetting.getRouteAuth().isEnable()) {
                basicAuth = this.eurekaSetting.getRouteAuth();
                BasicAuth routeBasicAuth = this.getAuthByRoute(header, this.eurekaSetting.getRoutes());
                if (routeBasicAuth != null) {
                    basicAuth = routeBasicAuth;
                }
            } else {
                basicAuth = this.getAuthByRoute(header, this.eurekaSetting.getRoutes());
            }
        }
        return basicAuth;
    }

    public EurekaSetting getEurekaSetting() {
        return this.eurekaSetting;
    }
}

