/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.kt;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.WrapperKeyword;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.config.enums.LogicDelTypeEnum;
import com.github.yulichang.kt.KtAbstractWrapper;
import com.github.yulichang.kt.interfaces.QueryJoin;
import com.github.yulichang.toolkit.KtUtils;
import com.github.yulichang.toolkit.LogicInfoUtils;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.TableList;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.enums.PrefixEnum;
import com.github.yulichang.wrapper.segments.SelectCache;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.reflect.KProperty;

public abstract class KtAbstractLambdaWrapper<T, Children extends KtAbstractLambdaWrapper<T, Children>>
extends KtAbstractWrapper<T, Children>
implements QueryJoin<Children, T> {
    protected String alias = ConfigProperties.tableAlias;
    protected String subTableAlias = ConfigProperties.tableAlias;
    protected boolean resultMap = false;
    protected int tableIndex = 1;
    protected boolean dynamicTableName = false;
    protected Function<String, String> tableFunc;
    protected LogicDelTypeEnum logicDelType = ConfigProperties.logicDelType;
    protected final SharedString from = new SharedString();
    protected boolean hasAlias;
    protected String keyWord;
    protected boolean subLogicSql = ConfigProperties.subTableLogic;
    protected boolean logicSql = true;

    public KtAbstractLambdaWrapper() {
        this.initNeed();
    }

    public KtAbstractLambdaWrapper(Class<T> clazz) {
        this.initNeed();
        this.setEntityClass(clazz);
        this.tableList.setRootClass(clazz);
    }

    public KtAbstractLambdaWrapper(T entity) {
        this.initNeed();
        this.setEntity(entity);
        if (entity != null) {
            this.tableList.setRootClass(entity.getClass());
        }
    }

    public KtAbstractLambdaWrapper(String alias) {
        this.alias = alias;
        this.initNeed();
        this.tableList.setAlias(alias);
    }

    public KtAbstractLambdaWrapper(Class<T> clazz, String alias) {
        this.alias = alias;
        this.setEntityClass(clazz);
        this.initNeed();
        this.tableList.setAlias(alias);
        this.tableList.setRootClass(clazz);
    }

    public KtAbstractLambdaWrapper(T entity, String alias) {
        this.alias = alias;
        this.setEntity(entity);
        this.initNeed();
        this.tableList.setAlias(alias);
        if (entity != null) {
            this.tableList.setRootClass(entity.getClass());
        }
    }

    public Children setTableName(Function<String, String> tableFunc) {
        if (this.isMain) {
            if (tableFunc != null) {
                this.dynamicTableName = true;
                this.tableFunc = tableFunc;
            }
        } else {
            this.tableName = tableFunc.apply(this.tableName);
        }
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public String getTableName(String tableName) {
        if (this.isMain) {
            if (this.dynamicTableName) {
                return this.tableFunc.apply(tableName);
            }
            return tableName;
        }
        return super.getTableName();
    }

    public String getTableNameEnc(String tableName) {
        String decode;
        TableInfo tableInfo;
        Class entityClass = this.getEntityClass();
        if (entityClass != null && (tableInfo = TableHelper.get(entityClass)) != null) {
            if (this.dynamicTableName) {
                return this.tableFunc.apply(tableInfo.getTableName());
            }
            return tableInfo.getTableName();
        }
        try {
            decode = URLDecoder.decode(tableName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (this.dynamicTableName) {
            return this.tableFunc.apply(decode);
        }
        return decode;
    }

    @Override
    protected final String columnsToString(Integer index, PrefixEnum prefixEnum, String alias, KProperty<?> ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString(index, alias, (KProperty<?>)i, false, prefixEnum)).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(Integer index, String alias, KProperty<?> column, boolean isJoin, PrefixEnum prefixEnum) {
        Class<?> entityClass = KtUtils.ref(column);
        return (alias == null ? this.getDefault(index, entityClass, isJoin, prefixEnum) : alias) + "." + this.getCache(column).getColumn();
    }

    protected SelectCache getCache(KProperty<?> fn) {
        Class<?> aClass = KtUtils.ref(fn);
        Map<String, SelectCache> cacheMap = ColumnCache.getMapField(aClass);
        return cacheMap.get(fn.getName());
    }

    protected String getDefault(Integer index, Class<?> clazz, boolean isJoin, PrefixEnum prefixEnum) {
        if (prefixEnum == PrefixEnum.ON_FIRST) {
            return this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.ON_SECOND) {
            return isJoin ? this.tableList.getPrefixOther(index, clazz) : this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_FIRST) {
            return this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_SECOND) {
            return isJoin ? this.tableList.getPrefixOther(index, clazz) : this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_ON_FIRST) {
            return this.tableList.getPrefix(index, clazz, false);
        }
        if (prefixEnum == PrefixEnum.CD_ON_SECOND) {
            return isJoin ? this.tableList.getPrefixOther(index, clazz) : this.tableList.getPrefix(index, clazz, false);
        }
        return this.tableList.getAlias();
    }

    public Children disableSubLogicDel() {
        this.subLogicSql = false;
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public Children enableSubLogicDel() {
        this.subLogicSql = true;
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public Children disableLogicDel() {
        this.logicSql = false;
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public Children enableLogicDel() {
        this.logicSql = true;
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public String getSubLogicSql() {
        if (this.subLogicSql && this.logicDelType == LogicDelTypeEnum.WHERE) {
            if (this.tableList.getAll().isEmpty()) {
                return "";
            }
            return this.tableList.getAll().stream().map(t -> LogicInfoUtils.getLogicInfo(t.getIndex(), t.getClazz(), t.isHasAlias(), t.getAlias())).collect(Collectors.joining(" "));
        }
        return "";
    }

    public boolean getLogicSql() {
        return this.logicSql;
    }

    public Children logicDelToOn() {
        this.logicDelType = LogicDelTypeEnum.ON;
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public Children logicDelToWhere() {
        this.logicDelType = LogicDelTypeEnum.WHERE;
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public String getFrom() {
        if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
            StringBuilder value = new StringBuilder();
            for (KtAbstractLambdaWrapper wrapper : this.onWrappers) {
                if (StringUtils.isBlank((CharSequence)wrapper.from.getStringValue())) {
                    TableInfo tableInfo;
                    if (this.subLogicSql && this.logicDelType == LogicDelTypeEnum.ON && ConfigProperties.tableInfoAdapter.mpjHasLogic(tableInfo = TableHelper.getAssert(wrapper.getJoinClass()))) {
                        wrapper.appendSqlSegments(new ISqlSegment[]{WrapperKeyword.APPLY, (ISqlSegment & Serializable)() -> LogicInfoUtils.getLogicInfoNoAnd(wrapper.getIndex(), wrapper.getJoinClass(), wrapper.isHasAlias(), wrapper.getAlias())});
                    }
                    value.append(" ").append(wrapper.getKeyWord()).append(" ").append(wrapper.getTableName()).append(" ").append(wrapper.hasAlias ? wrapper.alias : wrapper.alias + wrapper.getIndex()).append(" ON ").append(wrapper.getExpression().getNormal().getSqlSegment());
                    continue;
                }
                value.append(" ").append(wrapper.getKeyWord()).append(" ").append(wrapper.from.getStringValue()).append(" ");
            }
            this.from.setStringValue(value.toString());
        }
        return this.from.getStringValue();
    }

    @Override
    public Children join(String keyWord, Class<?> clazz, String tableAlias, BiConsumer<KtAbstractLambdaWrapper<?, ?>, Children> consumer) {
        Integer oldIndex = this.getIndex();
        int newIndex = this.tableIndex;
        TableInfo info = TableHelper.getAssert(clazz);
        KtAbstractLambdaWrapper instance = (KtAbstractLambdaWrapper)this.instance(newIndex, keyWord, clazz, info.getTableName());
        instance.isNo = true;
        instance.isMain = false;
        this.onWrappers.add(instance);
        if (StringUtils.isBlank((CharSequence)tableAlias)) {
            this.tableList.put(oldIndex, clazz, false, this.subTableAlias, newIndex);
            instance.alias = this.subTableAlias;
            instance.hasAlias = false;
        } else {
            this.tableList.put(oldIndex, clazz, true, tableAlias, newIndex);
            instance.alias = tableAlias;
            instance.hasAlias = true;
        }
        ++this.tableIndex;
        this.index = newIndex;
        boolean isM = this.isMain;
        this.isMain = false;
        consumer.accept(instance, this.typedThis);
        this.isMain = isM;
        this.index = oldIndex;
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    @Override
    public Children join(String keyWord, boolean condition, String joinSql) {
        if (condition) {
            KtAbstractLambdaWrapper wrapper = (KtAbstractLambdaWrapper)this.instanceEmpty();
            wrapper.from.setStringValue(joinSql);
            wrapper.keyWord = keyWord;
            this.onWrappers.add(wrapper);
        }
        return (Children)((KtAbstractLambdaWrapper)this.typedThis);
    }

    public boolean isUseAnnotationOrderBy() {
        String _sqlSegment = this.getSqlSegment();
        if (StringUtils.isBlank((CharSequence)_sqlSegment)) {
            return true;
        }
        String _sqlSegmentToUpperCase = _sqlSegment.toUpperCase();
        return !_sqlSegmentToUpperCase.contains("ORDER BY") && !_sqlSegmentToUpperCase.contains("LIMIT");
    }

    protected void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
        this.sqlFirst = SharedString.emptyString();
        this.tableList = new TableList();
        this.tableList.setAlias(this.alias);
    }

    @Override
    public void clear() {
        super.clear();
        this.alias = ConfigProperties.tableAlias;
        this.resultMap = false;
        this.tableIndex = 1;
        this.dynamicTableName = false;
        this.tableFunc = null;
        this.logicDelType = ConfigProperties.logicDelType;
        this.from.toNull();
        this.hasAlias = false;
        this.keyWord = null;
        this.logicSql = true;
        this.onWrappers.clear();
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isResultMap() {
        return this.resultMap;
    }

    public boolean isHasAlias() {
        return this.hasAlias;
    }

    public String getKeyWord() {
        return this.keyWord;
    }
}

