/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.github.yulichang.annotation.EntityMapping;
import com.github.yulichang.annotation.FieldMapping;
import com.github.yulichang.exception.MPJException;
import com.github.yulichang.mapper.MPJTableFieldInfo;
import com.github.yulichang.mapper.MPJTableInfo;
import com.github.yulichang.toolkit.TableHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.Configuration;

public class MPJTableInfoHelper {
    private static final Map<Class<?>, MPJTableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();

    public static MPJTableInfo getTableInfo(Class<?> clazz) {
        if (clazz == null || ReflectionKit.isPrimitiveOrWrapper(clazz) || clazz == String.class || clazz.isInterface()) {
            return null;
        }
        return TABLE_INFO_CACHE.get(clazz);
    }

    public static List<MPJTableInfo> getTableInfos() {
        return Collections.unmodifiableList(new ArrayList<MPJTableInfo>(TABLE_INFO_CACHE.values()));
    }

    public static synchronized void initTableInfo(Class<?> clazz, Class<?> mapperClass) {
        MPJTableInfo info = TABLE_INFO_CACHE.get(clazz);
        if (info != null) {
            return;
        }
        MPJTableInfo mpjTableInfo = new MPJTableInfo();
        mpjTableInfo.setMapperClass(mapperClass);
        TableInfo tableInfo = TableHelper.get(clazz);
        if (tableInfo == null) {
            return;
        }
        mpjTableInfo.setTableInfo(tableInfo);
        MPJTableInfoHelper.initMapping(mpjTableInfo);
        TABLE_INFO_CACHE.put(clazz, mpjTableInfo);
    }

    private static boolean isExistMapping(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz)).stream().anyMatch(field -> field.isAnnotationPresent(EntityMapping.class));
    }

    private static boolean isExistMappingField(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz)).stream().anyMatch(field -> field.isAnnotationPresent(FieldMapping.class));
    }

    public static void initMapping(MPJTableInfo mpjTableInfo) {
        boolean existMapping = MPJTableInfoHelper.isExistMapping(mpjTableInfo.getTableInfo().getEntityType());
        mpjTableInfo.setHasMapping(existMapping);
        boolean existMappingField = MPJTableInfoHelper.isExistMappingField(mpjTableInfo.getTableInfo().getEntityType());
        mpjTableInfo.setHasMappingField(existMappingField);
        mpjTableInfo.setHasMappingOrField(existMapping || existMappingField);
        ArrayList<MPJTableFieldInfo> mpjFieldList = new ArrayList<MPJTableFieldInfo>();
        List fields = ReflectionKit.getFieldList((Class)ClassUtils.getUserClass((Class)mpjTableInfo.getTableInfo().getEntityType()));
        for (Field field : fields) {
            EntityMapping mapping;
            if (existMapping && (mapping = field.getAnnotation(EntityMapping.class)) != null) {
                mpjFieldList.add(new MPJTableFieldInfo(mpjTableInfo.getTableInfo().getEntityType(), mapping, field));
            }
            if (!existMappingField || (mapping = field.getAnnotation(FieldMapping.class)) == null) continue;
            mpjFieldList.add(new MPJTableFieldInfo(mpjTableInfo.getTableInfo().getEntityType(), (FieldMapping)mapping, field));
        }
        mpjTableInfo.setFieldList(mpjFieldList);
    }

    public static TableInfo copyAndSetTableName(TableInfo tableInfo, String tableName) {
        try {
            Field[] fields;
            TableInfo table;
            try {
                table = (TableInfo)TableInfo.class.getDeclaredConstructor(Class.class).newInstance(tableInfo.getEntityType());
            }
            catch (Exception e) {
                table = (TableInfo)TableInfo.class.getDeclaredConstructor(Configuration.class, Class.class).newInstance(tableInfo.getConfiguration(), tableInfo.getEntityType());
            }
            for (Field f : fields = TableInfo.class.getDeclaredFields()) {
                f.setAccessible(true);
                f.set(table, f.get(tableInfo));
            }
            table.setTableName(tableName);
            return table;
        }
        catch (Exception e) {
            throw new MPJException("TableInfo \u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25 -> " + tableInfo.getEntityType().getName());
        }
    }
}

