/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.apt.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.github.yulichang.adapter.AdapterHelper;
import com.github.yulichang.extension.apt.AptQueryWrapper;
import com.github.yulichang.toolkit.LogicInfoUtils;
import com.github.yulichang.toolkit.StrUtils;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.sql.SqlScriptUtils;
import java.util.Objects;
import java.util.Optional;

public class AptWrapperUtils {
    public static <T> String buildSubSqlByWrapper(Class<T> clazz, AptQueryWrapper<T> wrapper, String alias) {
        String subLogic;
        String mainLogic;
        TableInfo tableInfo = TableHelper.getAssert(clazz);
        String first = Optional.ofNullable(wrapper.getSqlFirst()).orElse("");
        boolean hasWhere = false;
        String entityWhere = AptWrapperUtils.getEntitySql(tableInfo, wrapper);
        if (StrUtils.isNotBlank(entityWhere)) {
            hasWhere = true;
        }
        if (StrUtils.isNotBlank(mainLogic = AptWrapperUtils.mainLogic(hasWhere, clazz, wrapper))) {
            hasWhere = true;
        }
        if (StrUtils.isNotBlank(subLogic = AptWrapperUtils.subLogic(hasWhere, wrapper))) {
            hasWhere = true;
        }
        String sqlSegment = wrapper.getSqlSegment() != null && StrUtils.isNotBlank(wrapper.getSqlSegment()) ? (wrapper.isEmptyOfNormal() ? "" : (hasWhere ? " AND " : " WHERE ")) + wrapper.getSqlSegment() : "";
        String sqlComment = Optional.ofNullable(wrapper.getSqlComment()).orElse("");
        return String.format(" (%s SELECT %s FROM %s %s %s %s %s %s %s) AS %s ", first, wrapper.getSqlSelect(), wrapper.getTableName(tableInfo.getTableName()), wrapper.getAlias(), wrapper.getFrom(), mainLogic, subLogic, sqlSegment, sqlComment, alias);
    }

    public static String buildUnionSqlByWrapper(Class<?> clazz, AptQueryWrapper<?> wrapper) {
        String subLogic;
        String mainLogic;
        TableInfo tableInfo = TableHelper.getAssert(clazz);
        String first = Optional.ofNullable(wrapper.getSqlFirst()).orElse("");
        boolean hasWhere = false;
        String entityWhere = AptWrapperUtils.getEntitySql(tableInfo, wrapper);
        if (StrUtils.isNotBlank(entityWhere)) {
            hasWhere = true;
        }
        if (StrUtils.isNotBlank(mainLogic = AptWrapperUtils.mainLogic(hasWhere, clazz, wrapper))) {
            hasWhere = true;
        }
        if (StrUtils.isNotBlank(subLogic = AptWrapperUtils.subLogic(hasWhere, wrapper))) {
            hasWhere = true;
        }
        String sqlSegment = wrapper.getSqlSegment() != null && StrUtils.isNotBlank(wrapper.getSqlSegment()) ? (wrapper.isEmptyOfNormal() ? "" : (hasWhere ? " AND " : " WHERE ")) + wrapper.getSqlSegment() : "";
        String sqlComment = Optional.ofNullable(wrapper.getSqlComment()).orElse("");
        return String.format(" %s SELECT %s FROM %s %s %s %s %s %s %s ", first, wrapper.getSqlSelect(), wrapper.getTableName(tableInfo.getTableName()), wrapper.getAlias(), wrapper.getFrom(), mainLogic, subLogic, sqlSegment, sqlComment);
    }

    private static <T> String formatParam(AptQueryWrapper<T> wrapper, Object param) {
        String genParamName = "MPGENVAL" + wrapper.getParamNameSeq().incrementAndGet();
        String paramStr = wrapper.getParamAlias() + ".paramNameValuePairs." + genParamName;
        wrapper.getParamNameValuePairs().put(genParamName, param);
        return SqlScriptUtils.safeParam(paramStr, null);
    }

    private static String getEntitySql(TableInfo tableInfo, AptQueryWrapper<?> wrapper) {
        Object obj = wrapper.getEntity();
        if (Objects.isNull(obj)) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        for (TableFieldInfo fieldInfo : tableInfo.getFieldList()) {
            Object val;
            if (AdapterHelper.getAdapter().mpjHasLogic(tableInfo) && fieldInfo.isLogicDelete()) continue;
            try {
                val = fieldInfo.getField().get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (Objects.isNull(val)) continue;
            String s = wrapper.getAptIndex().get(wrapper.getBaseColumn());
            sb.append(" AND ").append(s == null ? wrapper.getAlias() : s).append(".").append(fieldInfo.getColumn()).append("=").append(AptWrapperUtils.formatParam(wrapper, val));
        }
        if (sb.length() > 0) {
            sb.delete(0, 4);
            sb.insert(0, " WHERE ");
        }
        return sb.toString();
    }

    private static String mainLogic(boolean hasWhere, Class<?> clazz, AptQueryWrapper<?> wrapper) {
        if (!wrapper.getLogicSql()) {
            return "";
        }
        String info = LogicInfoUtils.getLogicInfo(null, clazz, true, wrapper.getAlias());
        if (StrUtils.isNotBlank(info)) {
            if (hasWhere) {
                return " AND " + info;
            }
            return " WHERE " + info.substring(4);
        }
        return "";
    }

    private static String subLogic(boolean hasWhere, AptQueryWrapper<?> wrapper) {
        String sql = wrapper.getSubLogicSql();
        if (StrUtils.isNotBlank(sql)) {
            if (hasWhere) {
                return sql;
            }
            return " WHERE " + sql.substring(4);
        }
        return "";
    }
}

