/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.linux.LinuxModule;
import com.github.unidbg.linux.struct.dl_phdr_info64;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.pointer.UnidbgStructure;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.spi.InitFunction;
import com.github.unidbg.unix.struct.DlInfo64;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import net.fornwall.jelf.ElfDynamicStructure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArmLD64
extends Dlfcn {
    private static final Log log = LogFactory.getLog(ArmLD64.class);
    private final Backend backend;

    ArmLD64(Backend backend, SvcMemory svcMemory) {
        super(svcMemory);
        this.backend = backend;
    }

    public long hook(final SvcMemory svcMemory, String libraryName, String symbolName, long old) {
        if ("libdl.so".equals(libraryName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("link " + symbolName + ", old=0x" + Long.toHexString(old)));
            }
            switch (symbolName) {
                case "dl_iterate_phdr": {
                    return svcMemory.registerSvc((Svc)new Arm64Svc(){
                        private MemoryBlock block;

                        public UnidbgPointer onRegister(SvcMemory svcMemory2, int svcNumber) {
                            try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);){
                                KeystoneEncoded encoded = keystone.assemble(Arrays.asList("sub sp, sp, #0x10", "stp x29, x30, [sp]", "svc #0x" + Integer.toHexString(svcNumber), "ldr x13, [sp]", "add sp, sp, #0x8", "cmp x13, #0", "b.eq #0x58", "ldr x0, [sp]", "add sp, sp, #0x8", "ldr x1, [sp]", "add sp, sp, #0x8", "ldr x2, [sp]", "add sp, sp, #0x8", "blr x13", "cmp w0, #0", "b.eq #0xc", "ldr x13, [sp]", "add sp, sp, #0x8", "cmp x13, #0", "b.eq #0x58", "add sp, sp, #0x18", "b 0x40", "mov x8, #0", "mov x12, #0x" + Integer.toHexString(svcNumber), "mov x16, #0x" + Integer.toHexString(34952), "svc #0", "ldp x29, x30, [sp]", "add sp, sp, #0x10", "ret"));
                                byte[] code = encoded.getMachineCode();
                                UnidbgPointer pointer = svcMemory2.allocate(code.length, "dl_iterate_phdr");
                                pointer.write(0L, code, 0, code.length);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("dl_iterate_phdr: pointer=" + pointer));
                                }
                                UnidbgPointer unidbgPointer = pointer;
                                return unidbgPointer;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public long handle(Emulator<?> emulator) {
                            if (this.block != null) {
                                throw new IllegalStateException();
                            }
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer cb = context.getPointerArg(0);
                            UnidbgPointer data = context.getPointerArg(1);
                            Collection modules = emulator.getMemory().getLoadedModules();
                            ArrayList<LinuxModule> list = new ArrayList<LinuxModule>();
                            for (Module module : modules) {
                                LinuxModule lm = (LinuxModule)module;
                                if (lm.elfFile == null) continue;
                                list.add(lm);
                            }
                            Collections.reverse(list);
                            int size = UnidbgStructure.calculateSize(dl_phdr_info64.class);
                            this.block = emulator.getMemory().malloc(size * list.size(), true);
                            UnidbgPointer ptr = this.block.getPointer();
                            Backend backend = emulator.getBackend();
                            UnidbgPointer sp = UnidbgPointer.register(emulator, (int)4);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dl_iterate_phdr cb=" + cb + ", data=" + data + ", size=" + list.size() + ", sp=" + sp));
                            }
                            try {
                                sp = sp.share(-8L, 0L);
                                sp.setLong(0L, 0L);
                                for (LinuxModule module : list) {
                                    dl_phdr_info64 info = new dl_phdr_info64((Pointer)ptr);
                                    UnidbgPointer dlpi_addr = UnidbgPointer.pointer(emulator, (long)module.base);
                                    assert (dlpi_addr != null);
                                    info.dlpi_addr = dlpi_addr.peer;
                                    ElfDynamicStructure dynamicStructure = module.dynamicStructure;
                                    info.dlpi_name = dynamicStructure != null && dynamicStructure.soName > 0 && dynamicStructure.dt_strtab_offset > 0L ? UnidbgPointer.nativeValue((Pointer)dlpi_addr.share(dynamicStructure.dt_strtab_offset + (long)dynamicStructure.soName)) : UnidbgPointer.nativeValue((Pointer)module.createPathMemory(svcMemory));
                                    info.dlpi_phdr = UnidbgPointer.nativeValue((Pointer)dlpi_addr.share(module.elfFile.ph_offset));
                                    info.dlpi_phnum = module.elfFile.num_ph;
                                    info.pack();
                                    sp = sp.share(-8L, 0L);
                                    sp.setPointer(0L, (Pointer)data);
                                    sp = sp.share(-8L, 0L);
                                    sp.setLong(0L, (long)size);
                                    sp = sp.share(-8L, 0L);
                                    sp.setPointer(0L, (Pointer)ptr);
                                    sp = sp.share(-8L, 0L);
                                    sp.setPointer(0L, (Pointer)cb);
                                    ptr = ptr.share((long)size, 0L);
                                }
                                long l = context.getLongArg(0);
                                return l;
                            }
                            finally {
                                backend.reg_write(4, (Number)sp.peer);
                            }
                        }

                        public void handlePostCallback(Emulator<?> emulator) {
                            super.handlePostCallback(emulator);
                            if (this.block == null) {
                                throw new IllegalStateException();
                            }
                            this.block.free();
                            this.block = null;
                        }
                    }).peer;
                }
                case "dlerror": {
                    return svcMemory.registerSvc((Svc)new Arm64Svc(){

                        public long handle(Emulator<?> emulator) {
                            return ((ArmLD64)ArmLD64.this).error.peer;
                        }
                    }).peer;
                }
                case "dlclose": {
                    return svcMemory.registerSvc((Svc)new Arm64Svc(){

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            long handle = context.getLongArg(0);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dlclose handle=0x" + Long.toHexString(handle)));
                            }
                            return ArmLD64.this.dlclose(emulator.getMemory(), handle);
                        }
                    }).peer;
                }
                case "dlopen": {
                    return svcMemory.registerSvc((Svc)new Arm64Svc(){

                        public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
                            ByteBuffer buffer = ByteBuffer.allocate(56);
                            buffer.order(ByteOrder.LITTLE_ENDIAN);
                            buffer.putInt(-788511745);
                            buffer.putInt(-1459586051);
                            buffer.putInt(Arm64Svc.assembleSvc((int)svcNumber));
                            buffer.putInt(-113245203);
                            buffer.putInt(-1862261761);
                            buffer.putInt(-251657793);
                            buffer.putInt(1409286240);
                            buffer.putInt(285212574);
                            buffer.putInt(-702611040);
                            buffer.putInt(-113245216);
                            buffer.putInt(-1862261761);
                            buffer.putInt(-1455391747);
                            buffer.putInt(-1862253569);
                            buffer.putInt(-698416192);
                            byte[] code = buffer.array();
                            UnidbgPointer pointer = svcMemory.allocate(code.length, "dlopen");
                            pointer.write(0L, code, 0, code.length);
                            return pointer;
                        }

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer filename = context.getPointerArg(0);
                            int flags = context.getIntArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dlopen filename=" + filename.getString(0L) + ", flags=" + flags + ", LR=" + context.getLRPointer()));
                            }
                            return ArmLD64.this.dlopen(emulator.getMemory(), filename.getString(0L), emulator);
                        }
                    }).peer;
                }
                case "dladdr": {
                    return svcMemory.registerSvc((Svc)new Arm64Svc(){

                        public long handle(Emulator<?> emulator) {
                            Module module;
                            RegisterContext context = emulator.getContext();
                            long addr = context.getLongArg(0);
                            UnidbgPointer info = context.getPointerArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dladdr addr=0x" + Long.toHexString(addr) + ", info=" + info + ", LR=" + context.getLRPointer()));
                            }
                            if ((module = emulator.getMemory().findModuleByAddress(addr)) == null) {
                                return 0L;
                            }
                            Symbol symbol = module.findClosestSymbolByAddress(addr, true);
                            DlInfo64 dlInfo = new DlInfo64((Pointer)info);
                            dlInfo.dli_fname = UnidbgPointer.nativeValue((Pointer)module.createPathMemory(svcMemory));
                            dlInfo.dli_fbase = module.base;
                            if (symbol != null) {
                                dlInfo.dli_sname = UnidbgPointer.nativeValue((Pointer)symbol.createNameMemory(svcMemory));
                                dlInfo.dli_saddr = symbol.getAddress();
                            }
                            dlInfo.pack();
                            return 1L;
                        }
                    }).peer;
                }
                case "dlsym": {
                    return svcMemory.registerSvc((Svc)new Arm64Svc(){

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            long handle = context.getLongArg(0);
                            UnidbgPointer symbol = context.getPointerArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dlsym handle=0x" + Long.toHexString(handle) + ", symbol=" + symbol.getString(0L) + ", LR=" + context.getLRPointer()));
                            }
                            return ArmLD64.this.dlsym(emulator, handle, symbol.getString(0L));
                        }
                    }).peer;
                }
                case "dl_unwind_find_exidx": {
                    return svcMemory.registerSvc((Svc)new Arm64Svc(){

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer pc = context.getPointerArg(0);
                            UnidbgPointer pcount = context.getPointerArg(1);
                            log.info((Object)("dl_unwind_find_exidx pc" + pc + ", pcount=" + pcount));
                            return 0L;
                        }
                    }).peer;
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long dlopen(Memory memory, String filename, Emulator<?> emulator) {
        UnidbgPointer pointer = UnidbgPointer.register(emulator, (int)4);
        try {
            Module module = memory.dlopen(filename, false);
            pointer = pointer.share(-8L, 0L);
            if (module == null) {
                pointer.setLong(0L, 0L);
                pointer = pointer.share(-8L, 0L);
                pointer.setLong(0L, 0L);
                if (!"libnetd_client.so".equals(filename)) {
                    log.info((Object)("dlopen failed: " + filename));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("dlopen failed: " + filename));
                }
                this.error.setString(0L, "Resolve library " + filename + " failed");
                long l = 0L;
                return l;
            }
            pointer.setLong(0L, module.base);
            pointer = pointer.share(-8L, 0L);
            pointer.setLong(0L, 0L);
            LinuxModule m = (LinuxModule)module;
            if (m.getUnresolvedSymbol().isEmpty()) {
                for (InitFunction initFunction : m.initFunctionList) {
                    long address = initFunction.getAddress();
                    if (address == 0L) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[" + m.name + "]PushInitFunction: 0x" + Long.toHexString(address)));
                    }
                    pointer = pointer.share(-8L, 0L);
                    pointer.setLong(0L, address);
                }
                m.initFunctionList.clear();
            }
            long l = module.base;
            return l;
        }
        finally {
            this.backend.reg_write(4, (Number)pointer.peer);
        }
    }

    private int dlclose(Memory memory, long handle) {
        if (memory.dlclose(handle)) {
            return 0;
        }
        this.error.setString(0L, "dlclose 0x" + Long.toHexString(handle) + " failed");
        return -1;
    }
}

