/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Utils;
import com.github.unidbg.linux.android.AndroidResolver;
import com.github.unidbg.spi.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;

public class URLibraryFile
implements LibraryFile {
    private final URL url;
    private final String name;
    private final int sdk;
    private final boolean is64Bit;

    public URLibraryFile(URL url, String name, int sdk, boolean is64Bit) {
        this.url = url;
        this.name = name;
        this.sdk = sdk;
        this.is64Bit = is64Bit;
    }

    public String getName() {
        return this.name;
    }

    public String getMapRegionName() {
        return this.getPath();
    }

    public LibraryFile resolveLibrary(Emulator<?> emulator, String soName) {
        if (this.sdk <= 0) {
            return null;
        }
        return AndroidResolver.resolveLibrary(emulator, soName, this.sdk);
    }

    public ByteBuffer mapBuffer() throws IOException {
        if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            return Utils.mapBuffer((File)new File(this.url.getPath()));
        }
        return ByteBuffer.wrap(IOUtils.toByteArray((URL)this.url));
    }

    public long getFileSize() {
        if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            return new File(this.url.getPath()).length();
        }
        try {
            return IOUtils.toByteArray((URL)this.url).length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getPath() {
        return "/system/" + (this.is64Bit ? "lib64/" : "lib/") + this.name;
    }
}

