/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.StringObject;
import com.github.unidbg.linux.android.dvm.VM;
import java.util.ArrayList;
import java.util.List;

public class ArrayListObject
extends DvmObject<List<? extends DvmObject<?>>> {
    public static ArrayListObject newStringList(VM vm, String ... strings) {
        ArrayList<StringObject> list = new ArrayList<StringObject>();
        for (String str : strings) {
            if (str == null) continue;
            list.add(new StringObject(vm, str));
        }
        return new ArrayListObject(vm, list);
    }

    public ArrayListObject(VM vm, List<? extends DvmObject<?>> value) {
        super(vm.resolveClass("java/util/ArrayList", vm.resolveClass("java/util/List", new DvmClass[0])), value);
    }

    public int size() {
        return ((List)this.value).size();
    }

    public boolean isEmpty() {
        return ((List)this.value).isEmpty();
    }
}

