/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.AndroidEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.linux.android.ElfLibraryFile;
import com.github.unidbg.linux.android.ElfLibraryRawFile;
import com.github.unidbg.linux.android.dvm.ApkLibraryFile;
import com.github.unidbg.linux.android.dvm.DalvikModule;
import com.github.unidbg.linux.android.dvm.DvmAwareObject;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmClassFactory;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Jni;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.apk.Apk;
import com.github.unidbg.linux.android.dvm.apk.ApkFactory;
import com.github.unidbg.linux.android.dvm.apk.AssetResolver;
import com.github.unidbg.spi.LibraryFile;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.dongliu.apk.parser.bean.CertificateMeta;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseVM
implements VM,
DvmClassFactory {
    private static final Log log = LogFactory.getLog(BaseVM.class);
    final Map<Integer, DvmClass> classMap = new HashMap<Integer, DvmClass>();
    Jni jni;
    DvmObject<?> throwable;
    boolean verbose;
    private final AndroidEmulator emulator;
    private final Apk apk;
    final Set<String> notFoundClassSet = new HashSet<String>();
    final Map<Integer, ObjRef> globalObjectMap = new HashMap<Integer, ObjRef>();
    final Map<Integer, ObjRef> weakGlobalObjectMap = new HashMap<Integer, ObjRef>();
    final Map<Integer, ObjRef> localObjectMap = new HashMap<Integer, ObjRef>();
    private DvmClassFactory dvmClassFactory;
    private AssetResolver assetResolver;

    public static boolean valueOf(int value) {
        if (value == 1) {
            return true;
        }
        if (value == 0) {
            return false;
        }
        throw new IllegalStateException("Invalid boolean value=" + value);
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void throwException(DvmObject<?> throwable) {
        this.throwable = throwable;
    }

    @Override
    public final void setJni(Jni jni) {
        this.jni = jni;
    }

    @Override
    public void addNotFoundClass(String className) {
        this.notFoundClassSet.add(className);
    }

    BaseVM(AndroidEmulator emulator, File apkFile) {
        this.emulator = emulator;
        this.apk = apkFile == null ? null : ApkFactory.createApk(apkFile);
    }

    @Override
    public void setDvmClassFactory(DvmClassFactory factory) {
        this.dvmClassFactory = factory;
    }

    @Override
    public final DvmClass resolveClass(String className, DvmClass ... interfaceClasses) {
        className = className.replace('.', '/');
        int hash = Objects.hash(className);
        DvmClass dvmClass = this.classMap.get(hash);
        DvmClass superClass = null;
        if (interfaceClasses != null && interfaceClasses.length > 0) {
            superClass = interfaceClasses[0];
            interfaceClasses = Arrays.copyOfRange(interfaceClasses, 1, interfaceClasses.length);
        }
        if (dvmClass == null) {
            if (this.dvmClassFactory != null) {
                dvmClass = this.dvmClassFactory.createClass(this, className, superClass, interfaceClasses);
            }
            if (dvmClass == null) {
                dvmClass = this.createClass(this, className, superClass, interfaceClasses);
            }
            this.classMap.put(hash, dvmClass);
            this.addGlobalObject(dvmClass);
        }
        return dvmClass;
    }

    @Override
    public DvmClass createClass(BaseVM vm, String className, DvmClass superClass, DvmClass[] interfaceClasses) {
        return new DvmClass(vm, className, superClass, interfaceClasses);
    }

    final int addObject(DvmObject<?> object, boolean global, boolean weak) {
        Object value;
        int hash = object.hashCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("addObject hash=0x" + Long.toHexString(hash) + ", global=" + global));
        }
        if ((value = object.getValue()) instanceof DvmAwareObject) {
            ((DvmAwareObject)value).initializeDvm(this.emulator, this, object);
        }
        if (global) {
            if (weak) {
                this.weakGlobalObjectMap.put(hash, new ObjRef(object, true));
            } else {
                this.globalObjectMap.put(hash, new ObjRef(object, false));
            }
        } else {
            this.localObjectMap.put(hash, new ObjRef(object, weak));
        }
        return hash;
    }

    @Override
    public final int addLocalObject(DvmObject<?> object) {
        if (object == null) {
            return 0;
        }
        return this.addObject(object, false, false);
    }

    @Override
    public final int addGlobalObject(DvmObject<?> object) {
        if (object == null) {
            return 0;
        }
        return this.addObject(object, true, false);
    }

    @Override
    public final <T extends DvmObject<?>> T getObject(int hash) {
        ObjRef ref = this.localObjectMap.containsKey(hash) ? this.localObjectMap.get(hash) : (this.globalObjectMap.containsKey(hash) ? this.globalObjectMap.get(hash) : this.weakGlobalObjectMap.get(hash));
        return (T)(ref == null ? null : ref.obj);
    }

    @Override
    public final DvmClass findClass(String className) {
        return this.classMap.get(Objects.hash(className));
    }

    final void deleteLocalRefs() {
        for (ObjRef ref : this.localObjectMap.values()) {
            ref.obj.onDeleteRef();
        }
        this.localObjectMap.clear();
        if (this.throwable != null) {
            this.throwable.onDeleteRef();
            this.throwable = null;
        }
    }

    final void checkVersion(int version) {
        if (version != 65537 && version != 65538 && version != 65540 && version != 65542 && version != 65544) {
            throw new IllegalStateException("Illegal JNI version: 0x" + Integer.toHexString(version));
        }
    }

    abstract byte[] loadLibraryData(Apk var1, String var2);

    @Override
    public LibraryFile findLibrary(String soName) {
        File split;
        if (this.apk == null) {
            throw new UnsupportedOperationException();
        }
        ApkLibraryFile libraryFile = this.findLibrary(this.apk, soName);
        if (libraryFile == null && (split = new File(this.apk.getParentFile(), this.emulator.is64Bit() ? "config.arm64_v8a.apk" : "config.armeabi_v7a.apk")).canRead()) {
            libraryFile = this.findLibrary(ApkFactory.createApk(split), soName);
        }
        return libraryFile;
    }

    @Override
    public final DalvikModule loadLibrary(String libname, boolean forceCallInit) {
        String soName = "lib" + libname + ".so";
        LibraryFile libraryFile = this.findLibrary(soName);
        if (libraryFile == null) {
            throw new IllegalStateException("load library failed: " + libname);
        }
        Module module = this.emulator.getMemory().load(libraryFile, forceCallInit);
        return new DalvikModule(this, module);
    }

    @Override
    public final DalvikModule loadLibrary(String libname, byte[] raw, boolean forceCallInit) {
        if (raw == null || raw.length == 0) {
            throw new IllegalArgumentException();
        }
        Module module = this.emulator.getMemory().load((LibraryFile)new ElfLibraryRawFile(libname, raw, this.emulator.is64Bit()), forceCallInit);
        return new DalvikModule(this, module);
    }

    private ApkLibraryFile findLibrary(Apk apk, String soName) {
        byte[] libData = this.loadLibraryData(apk, soName);
        if (libData == null) {
            return null;
        }
        return new ApkLibraryFile(this, apk, soName, libData, apk.getPackageName(), this.emulator.is64Bit());
    }

    @Override
    public CertificateMeta[] getSignatures() {
        return this.apk == null ? null : this.apk.getSignatures();
    }

    @Override
    public String getPackageName() {
        return this.apk == null ? null : this.apk.getPackageName();
    }

    @Override
    public String getManifestXml() {
        return this.apk == null ? null : this.apk.getManifestXml();
    }

    @Override
    public byte[] openAsset(String fileName) {
        byte[] bytes;
        if (this.assetResolver != null && (bytes = this.assetResolver.resolveAsset(fileName)) != null) {
            return bytes;
        }
        return this.apk == null ? null : this.apk.openAsset(fileName);
    }

    @Override
    public byte[] unzip(String path) {
        if (path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return this.apk == null ? null : this.apk.getFileData(path);
    }

    @Override
    public void setAssetResolver(AssetResolver assetResolver) {
        this.assetResolver = assetResolver;
    }

    @Override
    public final String getVersionName() {
        return this.apk == null ? null : this.apk.getVersionName();
    }

    @Override
    public long getVersionCode() {
        return this.apk == null ? 0L : this.apk.getVersionCode();
    }

    @Override
    public final DalvikModule loadLibrary(File elfFile, boolean forceCallInit) {
        Module module = this.emulator.getMemory().load((LibraryFile)new ElfLibraryFile(elfFile, this.emulator.is64Bit()), forceCallInit);
        return new DalvikModule(this, module);
    }

    @Override
    public final void printMemoryInfo() {
        System.gc();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeap = memoryMXBean.getNonHeapMemoryUsage();
        HashMap<Integer, ObjRef> map = new HashMap<Integer, ObjRef>(this.globalObjectMap);
        for (Integer key : this.classMap.keySet()) {
            map.remove(key);
        }
        System.err.println("globalObjectSize=" + this.globalObjectMap.size() + ", localObjectSize=" + this.localObjectMap.size() + ", weakGlobalObjectSize=" + this.weakGlobalObjectMap.size() + ", classSize=" + this.classMap.size() + ", globalObjectSize=" + map.size());
        System.err.println("heap: " + this.memoryUsage(heap) + ", nonHeap: " + this.memoryUsage(nonHeap));
    }

    private String toMB(long memory) {
        return (float)(memory * 100L / 0x100000L) / 100.0f + "MB";
    }

    private String memoryUsage(MemoryUsage usage) {
        return "init=" + this.toMB(usage.getInit()) + ", used=" + this.toMB(usage.getUsed()) + ", committed=" + this.toMB(usage.getCommitted()) + ", max=" + this.toMB(usage.getMax());
    }

    @Override
    public void callJNI_OnLoad(Emulator<?> emulator, Module module) {
        new DalvikModule(this, module).callJNI_OnLoad(emulator);
    }

    @Override
    public Emulator<?> getEmulator() {
        return this.emulator;
    }

    static final class ObjRef {
        final DvmObject<?> obj;
        final boolean weak;

        ObjRef(DvmObject<?> obj, boolean weak) {
            this.obj = obj;
            this.weak = weak;
        }

        public String toString() {
            return String.valueOf(this.obj);
        }
    }
}

