/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.AndroidEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.Arm64RegisterContext;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.linux.android.dvm.ArmVarArg;
import com.github.unidbg.linux.android.dvm.Array;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmField;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.JValueList;
import com.github.unidbg.linux.android.dvm.StringObject;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.VaList64;
import com.github.unidbg.linux.android.dvm.VarArg;
import com.github.unidbg.linux.android.dvm.apk.Apk;
import com.github.unidbg.linux.android.dvm.array.ArrayObject;
import com.github.unidbg.linux.android.dvm.array.ByteArray;
import com.github.unidbg.linux.android.dvm.array.DoubleArray;
import com.github.unidbg.linux.android.dvm.array.FloatArray;
import com.github.unidbg.linux.android.dvm.array.IntArray;
import com.github.unidbg.linux.android.dvm.array.PrimitiveArray;
import com.github.unidbg.linux.android.dvm.array.ShortArray;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DalvikVM64
extends BaseVM
implements VM {
    private static final Log log = LogFactory.getLog(DalvikVM64.class);
    private final UnidbgPointer _JavaVM;
    private final UnidbgPointer _JNIEnv;

    public DalvikVM64(AndroidEmulator emulator, File apkFile) {
        super(emulator, apkFile);
        SvcMemory svcMemory = emulator.getSvcMemory();
        this._JavaVM = svcMemory.allocate(emulator.getPointerSize(), "_JavaVM");
        UnidbgPointer _GetVersion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return 65544L;
            }
        });
        UnidbgPointer _DefineClass = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _FindClass = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer env = context.getPointerArg(0);
                UnidbgPointer className = context.getPointerArg(1);
                String name = className.getString(0L);
                boolean notFound = DalvikVM64.this.notFoundClassSet.contains(name);
                if (DalvikVM64.this.verbose) {
                    if (notFound) {
                        System.out.printf("JNIEnv->FindNoClass(%s) was called from %s%n", name, context.getLRPointer());
                    } else {
                        System.out.printf("JNIEnv->FindClass(%s) was called from %s%n", name, context.getLRPointer());
                    }
                }
                if (notFound) {
                    DalvikVM64.this.throwable = DalvikVM64.this.resolveClass("java/lang/NoClassDefFoundError", new DvmClass[0]).newObject(name);
                    return 0L;
                }
                DvmClass dvmClass = DalvikVM64.this.resolveClass(name, new DvmClass[0]);
                long hash = (long)dvmClass.hashCode() & 0xFFFFFFFFL;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("FindClass env=" + env + ", className=" + name + ", hash=0x" + Long.toHexString(hash)));
                }
                return hash;
            }
        });
        UnidbgPointer _FromReflectedMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _FromReflectedField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ToReflectedMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                DvmMethod dvmMethod = null;
                if (dvmClass != null && (dvmMethod = dvmClass.getStaticMethod(jmethodID.toIntPeer())) == null) {
                    dvmMethod = dvmClass.getMethod(jmethodID.toIntPeer());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ToReflectedMethod clazz=" + dvmClass + ", jmethodID=" + jmethodID + ", lr=" + context.getLRPointer()));
                }
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->ToReflectedMethod(%s, \"%s\", %s) was called from %s%n", dvmClass.getClassName(), dvmMethod.methodName, dvmMethod.isStatic ? "is static" : "not static", context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(dvmMethod.toReflectedMethod());
            }
        });
        UnidbgPointer _GetSuperclass = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetSuperClass(%s) was called from %s%n", dvmClass, context.getLRPointer());
                }
                if (dvmClass.getClassName().equals("java/lang/Object")) {
                    log.debug((Object)("JNIEnv->GetSuperClass was called, class = " + dvmClass.getClassName() + " According to Java Native Interface Specification, If clazz specifies the class Object, returns NULL."));
                    throw new BackendException();
                }
                DvmClass superClass = dvmClass.getSuperclass();
                if (superClass == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("JNIEnv->GetSuperClass was called, class = " + dvmClass.getClassName() + ", superClass get failed."));
                    }
                    throw new BackendException();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JNIEnv->GetSuperClass was called, class = " + dvmClass.getClassName() + ", superClass = " + superClass.getClassName()));
                }
                return superClass.hashCode();
            }
        });
        UnidbgPointer _IsAssignableFrom = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ToReflectedField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _Throw = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                log.warn((Object)("Throw dvmObject=" + dvmObject + ", class=" + (dvmObject != null ? ((DvmObject)dvmObject).getObjectType() : null)));
                DalvikVM64.this.throwable = dvmObject;
                return 0L;
            }
        });
        UnidbgPointer _ThrowNew = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ExceptionOccurred = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                long exception;
                long l = exception = DalvikVM64.this.throwable == null ? 0L : (long)DalvikVM64.this.throwable.hashCode() & 0xFFFFFFFFL;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ExceptionOccurred: 0x" + Long.toHexString(exception)));
                }
                return exception;
            }
        });
        UnidbgPointer _ExceptionDescribe = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ExceptionClear = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ExceptionClear");
                }
                DalvikVM64.this.throwable = null;
                return 0L;
            }
        });
        UnidbgPointer _FatalError = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _PushLocalFrame = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                int capacity = context.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PushLocalFrame capacity=" + capacity));
                }
                return 0L;
            }
        });
        UnidbgPointer _PopLocalFrame = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer jresult = context.getPointerArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PopLocalFrame jresult=" + jresult));
                }
                return jresult == null ? 0L : (long)jresult.toIntPeer();
            }
        });
        UnidbgPointer _NewGlobalRef = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                if (object == null) {
                    return 0L;
                }
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewGlobalRef object=" + object + ", dvmObject=" + dvmObject));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewGlobalRef(%s) was called from %s%n", dvmObject, context.getLRPointer());
                }
                return DalvikVM64.this.addGlobalObject((DvmObject<?>)dvmObject);
            }
        });
        UnidbgPointer _DeleteGlobalRef = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                BaseVM.ObjRef ref;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DeleteGlobalRef object=" + object));
                }
                BaseVM.ObjRef objRef = ref = object == null ? null : (BaseVM.ObjRef)DalvikVM64.this.globalObjectMap.remove(object.toIntPeer());
                if (ref != null) {
                    ref.obj.onDeleteRef();
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->DeleteGlobalRef(%s) was called from %s%n", ref, context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _DeleteLocalRef = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DeleteLocalRef object=" + object));
                }
                return 0L;
            }
        });
        UnidbgPointer _IsSameObject = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer ref1 = context.getPointerArg(1);
                UnidbgPointer ref2 = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IsSameObject ref1=" + ref1 + ", ref2=" + ref2));
                }
                return ref1 == ref2 || ref1.equals((Object)ref2) ? 1L : 0L;
            }
        });
        UnidbgPointer _NewLocalRef = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                if (object == null) {
                    return 0L;
                }
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewLocalRef object=" + object + ", dvmObject=" + dvmObject + ", class=" + (dvmObject != null ? ((DvmObject)dvmObject).getObjectType() : null)));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewLocalRef(%s) was called from %s%n", dvmObject, context.getLRPointer());
                }
                return object.toIntPeer();
            }
        });
        UnidbgPointer _EnsureLocalCapacity = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                int capacity = context.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EnsureLocalCapacity capacity=" + capacity));
                }
                return 0L;
            }
        });
        UnidbgPointer _AllocObject = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AllocObject clazz=" + dvmClass + ", lr=" + context.getLRPointer()));
                }
                if (dvmClass == null) {
                    throw new BackendException();
                }
                DvmObject<?> obj = dvmClass.allocObject();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->AllocObject(%s => %s) was called from %s%n", dvmClass.getClassName(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _NewObject = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewObject clazz=" + dvmClass + ", jmethodID=" + jmethodID + ", lr=" + context.getLRPointer()));
                }
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                DvmObject<?> obj = dvmMethod.newObject(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewObject(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _NewObjectV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewObjectV clazz=" + dvmClass + ", jmethodID=" + jmethodID + ", va_list=" + va_list + ", lr=" + context.getLRPointer()));
                }
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                DvmObject<?> obj = dvmMethod.newObjectV(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewObjectV(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _NewObjectA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetObjectClass = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetObjectClass object=" + object + ", dvmObject=" + dvmObject));
                }
                if (dvmObject == null) {
                    throw new BackendException();
                }
                DvmClass dvmClass = ((DvmObject)dvmObject).getObjectType();
                return dvmClass.hashCode();
            }
        });
        UnidbgPointer _IsInstanceOf = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer clazz = context.getPointerArg(2);
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IsInstanceOf object=" + object + ", clazz=" + clazz + ", dvmObject=" + dvmObject + ", dvmClass=" + dvmClass));
                }
                if (dvmObject == null || dvmClass == null) {
                    throw new BackendException();
                }
                boolean flag = ((DvmObject)dvmObject).isInstanceOf(dvmClass);
                return flag ? 1L : 0L;
            }
        });
        UnidbgPointer _GetMethodID = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer methodName = context.getPointerArg(2);
                UnidbgPointer argsPointer = context.getPointerArg(3);
                String name = methodName.getString(0L);
                String args = argsPointer.getString(0L);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetMethodID class=" + clazz + ", methodName=" + name + ", args=" + args + ", LR=" + context.getLRPointer()));
                }
                if ((dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null) {
                    throw new BackendException();
                }
                int hash = dvmClass.getMethodID(name, args);
                if (DalvikVM64.this.verbose && hash != 0) {
                    System.out.printf("JNIEnv->GetMethodID(%s.%s%s) => 0x%x was called from %s%n", dvmClass.getClassName(), name, args, (long)hash & 0xFFFFFFFFL, context.getLRPointer());
                }
                return hash;
            }
        });
        UnidbgPointer _CallObjectMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallObjectMethod object=" + object + ", jmethodID=" + jmethodID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                DvmObject<?> ret = dvmMethod.callObjectMethod((DvmObject<?>)dvmObject, varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallObjectMethod(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(ret);
            }
        });
        UnidbgPointer _CallObjectMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallObjectMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list + ", lr=" + context.getLRPointer()));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException("dvmObject=" + dvmObject + ", dvmClass=" + dvmClass + ", jmethodID=" + jmethodID);
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                DvmObject<?> obj = dvmMethod.callObjectMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallObjectMethodV(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _CallObjectMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer jvalue = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallObjectMethodA object=" + object + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue + ", lr=" + context.getLRPointer()));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException("dvmObject=" + dvmObject + ", dvmClass=" + dvmClass + ", jmethodID=" + jmethodID);
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                DvmObject<?> obj = dvmMethod.callObjectMethodA((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallObjectMethodA(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _CallBooleanMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallBooleanMethod object=" + object + ", jmethodID=" + jmethodID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                boolean ret = dvmMethod.callBooleanMethod((DvmObject<?>)dvmObject, varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallBooleanMethod(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _CallBooleanMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallBooleanMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                boolean ret = dvmMethod.callBooleanMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallBooleanMethodV(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _CallBooleanMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer jvalue = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallBooleanMethodA object=" + object + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                boolean ret = dvmMethod.callBooleanMethodA((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallBooleanMethodA(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _CallByteMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallByteMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallByteMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                byte ret = dvmMethod.callByteMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallByteMethodV(%s, %s(%s) => 0x%x) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallByteMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallCharMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallCharMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallCharMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallShortMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallShortMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallShortMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                short ret = dvmMethod.callShortMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallShortMethodV(%s, %s(%s) => 0x%x) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallShortMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallIntMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallIntMethod object=" + object + ", jmethodID=" + jmethodID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                int ret = dvmMethod.callIntMethod((DvmObject<?>)dvmObject, varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallIntMethod(%s, %s(%s) => 0x%x) was called from %s%n", dvmObject, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallIntMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallIntMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                int ret = dvmMethod.callIntMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallIntMethodV(%s, %s(%s) => 0x%x) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallIntMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer jvalue = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallIntMethodA object=" + object + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                int ret = dvmMethod.callIntMethodA((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallIntMethodA(%s, %s(%s) => 0x%x) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallLongMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallLongMethod object=" + object + ", jmethodID=" + jmethodID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                long ret = dvmMethod.callLongMethod((DvmObject<?>)dvmObject, varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallLongMethod(%s, %s(%s) => 0x%xL) was called from %s%n", dvmObject, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallLongMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallLongMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                long ret = dvmMethod.callLongMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallLongMethodV(%s, %s(%s) => 0x%xL) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallLongMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallFloatMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallFloatMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallFloatMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                float ret = dvmMethod.callFloatMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallFloatMethodV(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), Float.valueOf(ret), context.getLRPointer());
                }
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putFloat(ret);
                emulator.getBackend().reg_write_vector(104, buffer.array());
                return context.getLongArg(0);
            }
        });
        UnidbgPointer _CallFloatMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallDoubleMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallDoubleMethod object=" + object + ", jmethodID=" + jmethodID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                double ret = dvmMethod.callDoubleMethod((DvmObject<?>)dvmObject, varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallDoubleMethod(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putDouble(ret);
                emulator.getBackend().reg_write_vector(104, buffer.array());
                return context.getLongArg(0);
            }
        });
        UnidbgPointer _CallDoubleMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallDoubleMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallVoidMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallVoidMethod object=" + object + ", jmethodID=" + jmethodID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                dvmMethod.callVoidMethod((DvmObject<?>)dvmObject, varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallVoidMethod(%s, %s(%s)) was called from %s%n", dvmObject, dvmMethod.methodName, varArg.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _CallVoidMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallVoidMethodV object=" + object + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                dvmMethod.callVoidMethodV((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallVoidMethodV(%s, %s(%s)) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _CallVoidMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer jvalue = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallVoidMethodA object=" + object + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                dvmMethod.callVoidMethodA((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallVoidMethodA(%s, %s(%s)) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _CallNonvirtualObjectMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualObjectMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualObjectMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualBooleanMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualBooleanMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualBooleanMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer clazz = context.getPointerArg(2);
                UnidbgPointer jmethodID = context.getPointerArg(3);
                UnidbgPointer jvalue = context.getPointerArg(4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallNonvirtualBooleanMethodA object=" + object + ", clazz=" + clazz + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                if (dvmMethod.isConstructor()) {
                    throw new IllegalStateException();
                }
                boolean ret = dvmMethod.callBooleanMethodA((DvmObject<?>)dvmObject, vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallNonvirtualBooleanMethodA(%s, %s(%s) => %s) was called from %s%n", dvmObject, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _CallNonvirtualByteMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualByteMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualByteMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualCharMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualCharMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualCharMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualShortMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualShortMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualShortMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualIntMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualIntMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualIntMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualLongMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualLongMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualLongMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualFloatMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualFloatMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualFloatMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualDoubleMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualDoubleMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualDoubleMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualVoidMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallNonvirtualVoidMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer clazz = context.getPointerArg(2);
                UnidbgPointer jmethodID = context.getPointerArg(3);
                UnidbgPointer va_list = context.getPointerArg(4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallNonvirtualVoidMethodV object=" + object + ", clazz=" + clazz + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                if (dvmMethod.isConstructor()) {
                    DvmObject<?> obj = dvmMethod.newObjectV(vaList);
                    ((DvmObject)Objects.requireNonNull(dvmObject)).setValue(obj.value);
                } else {
                    dvmMethod.callVoidMethodV((DvmObject<?>)dvmObject, vaList);
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallNonvirtualVoidMethodV(%s, %s, %s(%s)) was called from %s%n", dvmObject, dvmClass.getClassName(), dvmMethod.methodName, vaList.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _CallNonVirtualVoidMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer clazz = context.getPointerArg(2);
                UnidbgPointer jmethodID = context.getPointerArg(3);
                UnidbgPointer jvalue = context.getPointerArg(4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallNonVirtualVoidMethodA object=" + object + ", clazz=" + clazz + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                Object dvmObject = DalvikVM64.this.getObject(object.toIntPeer());
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                DvmMethod dvmMethod2 = dvmMethod = dvmClass == null ? null : dvmClass.getMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                if (dvmMethod.isConstructor()) {
                    DvmObject<?> obj = dvmMethod.newObjectV(vaList);
                    ((DvmObject)Objects.requireNonNull(dvmObject)).setValue(obj.value);
                } else {
                    dvmMethod.callVoidMethodA((DvmObject<?>)dvmObject, vaList);
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallNonVirtualVoidMethodA(%s, %s, %s(%s)) was called from %s%n", dvmObject, dvmClass.getClassName(), dvmMethod.methodName, vaList.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _GetFieldID = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer fieldName = context.getPointerArg(2);
                UnidbgPointer argsPointer = context.getPointerArg(3);
                String name = fieldName.getString(0L);
                String args = argsPointer.getString(0L);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetFieldID class=" + clazz + ", fieldName=" + name + ", args=" + args));
                }
                if ((dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null) {
                    throw new BackendException();
                }
                int hash = dvmClass.getFieldID(name, args);
                if (DalvikVM64.this.verbose && hash != 0) {
                    System.out.printf("JNIEnv->GetFieldID(%s.%s %s) => 0x%x was called from %s%n", dvmClass.getClassName(), name, args, (long)hash & 0xFFFFFFFFL, context.getLRPointer());
                }
                return hash;
            }
        });
        UnidbgPointer _GetObjectField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetObjectField object=" + object + ", jfieldID=" + jfieldID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                DvmObject<?> obj = dvmField.getObjectField((DvmObject<?>)dvmObject);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetObjectField(%s, %s %s => %s) was called from %s%n", dvmObject, dvmField.fieldName, dvmField.fieldType, obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _GetBooleanField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetBooleanField object=" + object + ", jfieldID=" + jfieldID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                int ret = dvmField.getBooleanField((DvmObject<?>)dvmObject);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetBooleanField(%s, %s => %s) was called from %s%n", dvmObject, dvmField.fieldName, ret == 1, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _GetByteField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetCharField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetShortField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetIntField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetIntField object=" + object + ", jfieldID=" + jfieldID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                int ret = dvmField.getIntField((DvmObject<?>)dvmObject);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetIntField(%s, %s => 0x%x) was called from %s%n", dvmObject, dvmField.fieldName, ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _GetLongField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetLongField object=" + object + ", jfieldID=" + jfieldID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                long ret = dvmField.getLongField((DvmObject<?>)dvmObject);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetLongField(%s, %s => 0x%x) was called from %s%n", dvmObject, dvmField.fieldName, ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _GetFloatField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetFloatField object=" + object + ", jfieldID=" + jfieldID));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                float ret = dvmField.getFloatField((DvmObject<?>)dvmObject);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetFloatField(%s, %s => %s) was called from %s%n", dvmObject, dvmField.fieldName, Float.valueOf(ret), context.getLRPointer());
                }
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putFloat(ret);
                emulator.getBackend().reg_write_vector(104, buffer.array());
                return context.getLongArg(0);
            }
        });
        UnidbgPointer _GetDoubleField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetObjectField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                UnidbgPointer value = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetObjectField object=" + object + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                DvmObject<?> obj = value == null ? null : (DvmObject<?>)DalvikVM64.this.getObject(value.toIntPeer());
                dvmField.setObjectField((DvmObject<?>)dvmObject, obj);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetObjectField(%s, %s %s => %s) was called from %s%n", dvmObject, dvmField.fieldName, dvmField.fieldType, obj, context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _SetBooleanField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                int value = context.getIntArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetBooleanField object=" + object + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                boolean flag = BaseVM.valueOf(value);
                dvmField.setBooleanField((DvmObject<?>)dvmObject, flag);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetBooleanField(%s, %s => %s) was called from %s%n", dvmObject, dvmField.fieldName, flag, context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _SetByteField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetCharField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetShortField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetIntField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                int value = context.getIntArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetIntField object=" + object + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                dvmField.setIntField((DvmObject<?>)dvmObject, value);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetIntField(%s, %s => 0x%x) was called from %s%n", dvmObject, dvmField.fieldName, value, context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _SetLongField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                long value = context.getLongArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetLongField object=" + object + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                dvmField.setLongField((DvmObject<?>)dvmObject, value);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetLongField(%s, %s => 0x%x) was called from %s%n", dvmObject, dvmField.fieldName, value, context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _SetFloatField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.put(emulator.getBackend().reg_read_vector(104));
                buffer.flip();
                float value = buffer.getFloat();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetFloatField object=" + object + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                dvmField.setFloatField((DvmObject<?>)dvmObject, value);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetFloatField(%s, %s => %s) was called from %s%n", dvmObject, dvmField.fieldName, Float.valueOf(value), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _SetDoubleField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmField dvmField;
                Object dvmObject;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.put(emulator.getBackend().reg_read_vector(104));
                buffer.flip();
                double value = buffer.getDouble();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetDoubleField object=" + object + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmClass dvmClass = (dvmObject = DalvikVM64.this.getObject(object.toIntPeer())) == null ? null : ((DvmObject)dvmObject).getObjectType();
                DvmField dvmField2 = dvmField = dvmClass == null ? null : dvmClass.getField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                dvmField.setDoubleField((DvmObject<?>)dvmObject, value);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetDoubleField(%s, %s => %s) was called from %s%n", dvmObject, dvmField.fieldName, value, context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _GetStaticMethodID = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer methodName = context.getPointerArg(2);
                UnidbgPointer argsPointer = context.getPointerArg(3);
                String name = methodName.getString(0L);
                String args = argsPointer.getString(0L);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStaticMethodID class=" + clazz + ", methodName=" + name + ", args=" + args + ", LR=" + context.getLRPointer()));
                }
                if ((dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null) {
                    throw new BackendException();
                }
                int hash = dvmClass.getStaticMethodID(name, args);
                if (DalvikVM64.this.verbose && hash != 0) {
                    System.out.printf("JNIEnv->GetStaticMethodID(%s.%s%s) => 0x%x was called from %s%n", dvmClass.getClassName(), name, args, (long)hash & 0xFFFFFFFFL, context.getLRPointer());
                }
                return hash;
            }
        });
        UnidbgPointer _CallStaticObjectMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticObjectMethod clazz=" + clazz + ", jmethodID=" + jmethodID));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                DvmObject<?> obj = dvmMethod.callStaticObjectMethod(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticObjectMethod(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _CallStaticObjectMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticObjectMethodV clazz=" + clazz + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                DvmObject<?> obj = dvmMethod.callStaticObjectMethodV(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticObjectMethodV(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _CallStaticObjectMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer jvalue = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticObjectMethodA clazz=" + clazz + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                DvmObject<?> obj = dvmMethod.callStaticObjectMethodA(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticObjectMethodA(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _CallStaticBooleanMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticBooleanMethod clazz=" + clazz + ", jmethodID=" + jmethodID));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                boolean ret = dvmMethod.CallStaticBooleanMethod(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticBooleanMethod(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _CallStaticBooleanMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticBooleanMethodV clazz=" + clazz + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                boolean ret = dvmMethod.callStaticBooleanMethodV(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticBooleanMethodV(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _CallStaticBooleanMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer jvalue = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticBooleanMethodA clazz=" + clazz + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                boolean ret = dvmMethod.callStaticBooleanMethodV(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticBooleanMethodA(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _CallStaticByteMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticByteMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticByteMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticCharMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticCharMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticCharMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticShortMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticShortMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticShortMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticIntMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticIntMethodV clazz=" + clazz + ", jmethodID=" + jmethodID));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                int ret = dvmMethod.callStaticIntMethod(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticIntMethod(%s, %s(%s) => 0x%x) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallStaticIntMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticIntMethodV clazz=" + clazz + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                int ret = dvmMethod.callStaticIntMethodV(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticIntMethodV(%s, %s(%s) => 0x%x) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallStaticIntMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticLongMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticLongMethod clazz=" + clazz + ", jmethodID=" + jmethodID));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                long value = dvmMethod.callStaticLongMethod(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticLongMethod(%s, %s(%s)) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), context.getLRPointer());
                }
                return value;
            }
        });
        UnidbgPointer _CallStaticLongMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticLongMethodV clazz=" + clazz + ", jmethodID=" + jmethodID + ", va_list=" + va_list + ", lr=" + context.getLRPointer()));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                long ret = dvmMethod.callStaticLongMethodV(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticLongMethodV(%s, %s(%s) => 0x%xL) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _CallStaticLongMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticFloatMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticFloatMethod clazz=" + clazz + ", jmethodID=" + jmethodID));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                float ret = dvmMethod.callStaticFloatMethod(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticFloatMethod(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), Float.valueOf(ret), context.getLRPointer());
                }
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putFloat(ret);
                emulator.getBackend().reg_write_vector(104, buffer.array());
                return context.getLongArg(0);
            }
        });
        UnidbgPointer _CallStaticFloatMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticFloatMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticDoubleMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticDoubleMethod clazz=" + clazz + ", jmethodID=" + jmethodID));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                double ret = dvmMethod.callStaticDoubleMethod(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticDoubleMethod(%s, %s(%s) => %s) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), ret, context.getLRPointer());
                }
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putDouble(ret);
                emulator.getBackend().reg_write_vector(104, buffer.array());
                return context.getLongArg(0);
            }
        });
        UnidbgPointer _CallStaticDoubleMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticDoubleMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _CallStaticVoidMethod = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticVoidMethod clazz=" + clazz + ", jmethodID=" + jmethodID));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VarArg varArg = ArmVarArg.create(emulator, DalvikVM64.this, dvmMethod);
                dvmMethod.callStaticVoidMethod(varArg);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticVoidMethod(%s, %s(%s)) was called from %s%n", dvmClass, dvmMethod.methodName, varArg.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _CallStaticVoidMethodV = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer va_list = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticVoidMethodV clazz=" + clazz + ", jmethodID=" + jmethodID + ", va_list=" + va_list));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                VaList64 vaList = new VaList64(emulator, DalvikVM64.this, va_list, dvmMethod);
                dvmMethod.callStaticVoidMethodV(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticVoidMethodV(%s, %s(%s)) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _CallStaticVoidMethodA = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmMethod dvmMethod;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jmethodID = context.getPointerArg(2);
                UnidbgPointer jvalue = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallStaticVoidMethodA clazz=" + clazz + ", jmethodID=" + jmethodID + ", jvalue=" + jvalue));
                }
                DvmMethod dvmMethod2 = dvmMethod = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticMethod(jmethodID.toIntPeer());
                if (dvmMethod == null) {
                    throw new BackendException();
                }
                JValueList vaList = new JValueList(DalvikVM64.this, jvalue, dvmMethod);
                dvmMethod.callStaticVoidMethodA(vaList);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->CallStaticVoidMethodA(%s, %s(%s)) was called from %s%n", dvmClass, dvmMethod.methodName, vaList.formatArgs(), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _GetStaticFieldID = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer fieldName = context.getPointerArg(2);
                UnidbgPointer argsPointer = context.getPointerArg(3);
                String name = fieldName.getString(0L);
                String args = argsPointer.getString(0L);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStaticFieldID class=" + clazz + ", fieldName=" + name + ", args=" + args));
                }
                if ((dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null) {
                    throw new BackendException();
                }
                int hash = dvmClass.getStaticFieldID(name, args);
                if (DalvikVM64.this.verbose && hash != 0) {
                    System.out.printf("JNIEnv->GetStaticFieldID(%s.%s%s) => 0x%x was called from %s%n", dvmClass.getClassName(), name, args, (long)hash & 0xFFFFFFFFL, context.getLRPointer());
                }
                return hash;
            }
        });
        UnidbgPointer _GetStaticObjectField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStaticObjectField clazz=" + clazz + ", jfieldID=" + jfieldID));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                DvmObject<?> obj = dvmField.getStaticObjectField();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStaticObjectField(%s, %s %s => %s) was called from %s%n", dvmClass, dvmField.fieldName, dvmField.fieldType, obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _GetStaticBooleanField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStaticBooleanField clazz=" + clazz + ", jfieldID=" + jfieldID));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                boolean ret = dvmField.getStaticBooleanField();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStaticBooleanField(%s, %s => %s) was called from %s%n", dvmClass, dvmField.fieldName, ret, context.getLRPointer());
                }
                return ret ? 1L : 0L;
            }
        });
        UnidbgPointer _GetStaticByteField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStaticByteField clazz=" + clazz + ", jfieldID=" + jfieldID));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                byte ret = dvmField.getStaticByteField();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStaticByteField(%s, %s => %s) was called from %s%n", dvmClass, dvmField.fieldName, ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _GetStaticCharField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetStaticShortField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetStaticIntField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStaticIntField clazz=" + clazz + ", jfieldID=" + jfieldID));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                int ret = dvmField.getStaticIntField();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStaticIntField(%s, %s => 0x%x) was called from %s%n", dvmClass, dvmField.fieldName, ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _GetStaticLongField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                Arm64RegisterContext context = (Arm64RegisterContext)emulator.getContext();
                UnidbgPointer clazz = context.getXPointer(1);
                UnidbgPointer jfieldID = context.getXPointer(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStaticLongField clazz=" + clazz + ", jfieldID=" + jfieldID));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException();
                }
                long ret = dvmField.getStaticLongField();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStaticLongField(%s, %s => 0x%x) was called from %s%n", dvmClass, dvmField.fieldName, ret, context.getLRPointer());
                }
                return ret;
            }
        });
        UnidbgPointer _GetStaticFloatField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetStaticDoubleField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetStaticObjectField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetStaticBooleanField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetStaticByteField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetStaticCharField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetStaticShortField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetStaticIntField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                int value = context.getIntArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetStaticIntField clazz=" + clazz + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException("dvmClass=" + dvmClass);
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetStaticIntField(%s, %s, 0x%x) was called from %s%n", dvmClass, dvmField.fieldName, value, context.getLRPointer());
                }
                dvmField.setStaticIntField(value);
                return 0L;
            }
        });
        UnidbgPointer _SetStaticLongField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                long value = context.getLongArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetStaticLongField clazz=" + clazz + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException("dvmClass=" + dvmClass);
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetStaticLongField(%s, %s, 0x%x) was called from %s%n", dvmClass, dvmField.fieldName, value, context.getLRPointer());
                }
                dvmField.setStaticLongField(value);
                return 0L;
            }
        });
        UnidbgPointer _GetStringUTFLength = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                Object string = DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStringUTFLength string=" + string + ", lr=" + context.getLRPointer()));
                }
                String value = (String)((DvmObject)Objects.requireNonNull(string)).getValue();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStringUTFLength(%s) was called from %s%n", string, context.getLRPointer());
                }
                byte[] data = value.getBytes(StandardCharsets.UTF_8);
                return data.length;
            }
        });
        UnidbgPointer _GetStringUTFChars = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer isCopy = context.getPointerArg(2);
                StringObject string = (StringObject)DalvikVM64.this.getObject(object.toIntPeer());
                if (isCopy != null) {
                    isCopy.setInt(0L, 1);
                }
                String value = (String)Objects.requireNonNull(string).getValue();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStringUtfChars(%s) was called from %s%n", string, context.getLRPointer());
                }
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStringUTFChars string=" + string + ", isCopy=" + isCopy + ", value=" + value + ", lr=" + context.getLRPointer()));
                }
                byte[] data = Arrays.copyOf(bytes, bytes.length + 1);
                UnidbgPointer pointer = string.allocateMemoryBlock(emulator, data.length);
                pointer.write(0L, data, 0, data.length);
                return pointer.toIntPeer();
            }
        });
        UnidbgPointer _ReleaseStringUTFChars = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer pointer = context.getPointerArg(2);
                StringObject string = (StringObject)DalvikVM64.this.getObject(object.toIntPeer());
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->ReleaseStringUTFChars(%s) was called from %s%n", string, context.getLRPointer());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReleaseStringUTFChars string=" + string + ", pointer=" + pointer + ", lr=" + context.getLRPointer()));
                }
                Objects.requireNonNull(string).freeMemoryBlock((Pointer)pointer);
                return 0L;
            }
        });
        UnidbgPointer _GetArrayLength = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer pointer = context.getPointerArg(1);
                Array array = Objects.requireNonNull((Array)DalvikVM64.this.getObject(pointer.toIntPeer()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetArrayLength array=" + array));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetArrayLength(%s => %s) was called from %s%n", array, array.length(), context.getLRPointer());
                }
                return array.length();
            }
        });
        UnidbgPointer _NewObjectArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                RegisterContext context = emulator.getContext();
                int size = context.getIntArg(1);
                UnidbgPointer elementClass = context.getPointerArg(2);
                UnidbgPointer initialElement = context.getPointerArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewObjectArray size=" + size + ", elementClass=" + elementClass + ", initialElement=" + initialElement));
                }
                if ((dvmClass = (DvmClass)DalvikVM64.this.classMap.get(elementClass.toIntPeer())) == null) {
                    throw new BackendException("elementClass=" + elementClass);
                }
                Object obj = size == 0 ? null : (initialElement == null ? null : DalvikVM64.this.getObject(initialElement.toIntPeer()));
                DvmObject[] array = new DvmObject[size];
                for (int i = 0; i < size; ++i) {
                    array[i] = obj;
                }
                return DalvikVM64.this.addLocalObject(new ArrayObject(array));
            }
        });
        UnidbgPointer _GetObjectArrayElement = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int index = context.getIntArg(2);
                ArrayObject array = (ArrayObject)DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetObjectArrayElement array=" + array + ", index=" + index));
                }
                DvmObject obj = ((DvmObject[])Objects.requireNonNull(array).getValue())[index];
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetObjectArrayElement(%s, %d) => %s was called from %s%n", array, index, obj, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(obj);
            }
        });
        UnidbgPointer _SetObjectArrayElement = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                Object obj;
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int index = context.getIntArg(2);
                UnidbgPointer element = context.getPointerArg(3);
                ArrayObject array = (ArrayObject)DalvikVM64.this.getObject(object.toIntPeer());
                Object v0 = obj = element == null ? null : DalvikVM64.this.getObject(element.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("setObjectArrayElement array=" + array + ", index=" + index + ", obj=" + obj));
                }
                DvmObject[] objs = (DvmObject[])Objects.requireNonNull(array).getValue();
                objs[index] = obj;
                return 0L;
            }
        });
        UnidbgPointer _NewBooleanArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _NewByteArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                int size = context.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewByteArray size=" + size));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewByteArray(%d) was called from %s%n", size, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(new ByteArray(DalvikVM64.this, new byte[size]));
            }
        });
        UnidbgPointer _NewCharArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _NewShortArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _NewIntArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                int size = context.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewIntArray size=" + size));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewIntArray(%d) was called from %s%n", size, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(new IntArray(DalvikVM64.this, new int[size]));
            }
        });
        UnidbgPointer _NewLongArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _NewFloatArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                int size = context.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewFloatArray size=" + size));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewFloatArray(%d) was called from %s%n", size, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(new FloatArray(DalvikVM64.this, new float[size]));
            }
        });
        UnidbgPointer _NewDoubleArray = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                int size = context.getIntArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("_NewDoubleArray size=" + size));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewDoubleArray(%d) was called from %s%n", size, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(new DoubleArray(DalvikVM64.this, new double[size]));
            }
        });
        UnidbgPointer _GetBooleanArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetByteArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer arrayPointer = context.getPointerArg(1);
                UnidbgPointer isCopy = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetByteArrayElements arrayPointer=" + arrayPointer + ", isCopy=" + isCopy));
                }
                if (isCopy != null) {
                    isCopy.setInt(0L, 1);
                }
                ByteArray array = (ByteArray)DalvikVM64.this.getObject(arrayPointer.toIntPeer());
                return Objects.requireNonNull(array)._GetArrayCritical(emulator, (Pointer)isCopy).peer;
            }
        });
        UnidbgPointer _GetCharArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetShortArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetIntArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer isCopy = context.getPointerArg(2);
                IntArray array = (IntArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetIntArrayElements array=" + array + ", isCopy=" + isCopy));
                }
                return Objects.requireNonNull(array)._GetArrayCritical(emulator, (Pointer)isCopy).peer;
            }
        });
        UnidbgPointer _SetStaticFloatField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.put(emulator.getBackend().reg_read_vector(104));
                buffer.flip();
                float value = buffer.getFloat();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetStaticFloatField clazz=" + clazz + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException("dvmClass=" + dvmClass);
                }
                dvmField.setStaticFloatField(value);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetStaticFloatField(%s, %s, %s) was called from %s%n", dvmClass, dvmField.fieldName, Float.valueOf(value), context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _SetStaticDoubleField = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                DvmClass dvmClass;
                DvmField dvmField;
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer jfieldID = context.getPointerArg(2);
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.put(emulator.getBackend().reg_read_vector(104));
                buffer.flip();
                double value = buffer.getDouble();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetStaticDoubleField clazz=" + clazz + ", jfieldID=" + jfieldID + ", value=" + value));
                }
                DvmField dvmField2 = dvmField = (dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer())) == null ? null : dvmClass.getStaticField(jfieldID.toIntPeer());
                if (dvmField == null) {
                    throw new BackendException("dvmClass=" + dvmClass);
                }
                dvmField.setStaticDoubleField(value);
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetStaticDoubleField(%s, %s, %s) was called from %s%n", dvmClass, dvmField.fieldName, value, context.getLRPointer());
                }
                return 0L;
            }
        });
        UnidbgPointer _NewString = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetStringLength = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                Object string = DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStringLength string=" + string + ", lr=" + context.getLRPointer()));
                }
                String value = (String)((DvmObject)Objects.requireNonNull(string)).getValue();
                return value.length();
            }
        });
        UnidbgPointer _GetStringChars = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer isCopy = context.getPointerArg(2);
                StringObject string = (StringObject)DalvikVM64.this.getObject(object.toIntPeer());
                if (isCopy != null) {
                    isCopy.setInt(0L, 1);
                }
                String value = (String)Objects.requireNonNull(string).getValue();
                byte[] bytes = new byte[value.length() * 2];
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                for (char c : value.toCharArray()) {
                    buffer.putChar(c);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStringUTFChars string=" + string + ", isCopy=" + isCopy + ", value=" + value + ", lr=" + context.getLRPointer()));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStringUTFChars(\"%s\") was called from %s%n", string, context.getLRPointer());
                }
                byte[] data = Arrays.copyOf(bytes, bytes.length + 1);
                UnidbgPointer pointer = string.allocateMemoryBlock(emulator, data.length);
                pointer.write(0L, data, 0, data.length);
                return pointer.toIntPeer();
            }
        });
        UnidbgPointer _ReleaseStringChars = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer pointer = context.getPointerArg(2);
                StringObject string = (StringObject)DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReleaseStringChars string=" + string + ", pointer=" + pointer + ", lr=" + context.getLRPointer()));
                }
                Objects.requireNonNull(string).freeMemoryBlock((Pointer)pointer);
                return 0L;
            }
        });
        UnidbgPointer _NewStringUTF = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer bytes = context.getPointerArg(1);
                if (bytes == null) {
                    return 0L;
                }
                String string = bytes.getString(0L);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewStringUTF bytes=" + bytes + ", string=" + string));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->NewStringUTF(\"%s\") was called from %s%n", string, context.getLRPointer());
                }
                return DalvikVM64.this.addLocalObject(new StringObject(DalvikVM64.this, string));
            }
        });
        UnidbgPointer _GetLongArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetFloatArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer isCopy = context.getPointerArg(2);
                FloatArray array = (FloatArray)DalvikVM64.this.getObject(object.toIntPeer());
                return Objects.requireNonNull(array)._GetArrayCritical(emulator, (Pointer)isCopy).peer;
            }
        });
        UnidbgPointer _GetDoubleArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ReleaseBooleanArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ReleaseByteArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer arrayPointer = context.getPointerArg(1);
                UnidbgPointer pointer = context.getPointerArg(2);
                int mode = context.getIntArg(3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReleaseByteArrayElements arrayPointer=" + arrayPointer + ", pointer=" + pointer + ", mode=" + mode));
                }
                ByteArray array = (ByteArray)DalvikVM64.this.getObject(arrayPointer.toIntPeer());
                Objects.requireNonNull(array)._ReleaseArrayCritical((Pointer)pointer, mode);
                return 0L;
            }
        });
        UnidbgPointer _ReleaseCharArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ReleaseShortArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ReleaseIntArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer pointer = context.getPointerArg(2);
                int mode = context.getIntArg(3);
                IntArray array = (IntArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReleaseIntArrayElements array=" + array + ", pointer=" + pointer + ", mode=" + mode));
                }
                Objects.requireNonNull(array)._ReleaseArrayCritical((Pointer)pointer, mode);
                return 0L;
            }
        });
        UnidbgPointer _ReleaseLongArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ReleaseFloatArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer pointer = context.getPointerArg(2);
                int mode = context.getIntArg(3);
                FloatArray array = (FloatArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReleaseByteArrayElements array=" + array + ", pointer=" + pointer + ", mode=" + mode));
                }
                Objects.requireNonNull(array)._ReleaseArrayCritical((Pointer)pointer, mode);
                return 0L;
            }
        });
        UnidbgPointer _ReleaseDoubleArrayElements = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetBooleanArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetByteArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                ByteArray array = (ByteArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetByteArrayRegion(%s, %d, %d, %s) was called from %s%n", array, start, length, buf, context.getLRPointer());
                }
                byte[] data = Arrays.copyOfRange((byte[])Objects.requireNonNull(array).value, start, start + length);
                if (log.isDebugEnabled()) {
                    Inspector.inspect((byte[])data, (String)("GetByteArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                }
                buf.write(0L, data, 0, data.length);
                return 0L;
            }
        });
        UnidbgPointer _GetCharArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetShortArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                ShortArray array = (ShortArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetShortArrayRegion(%s, %d, %d, %s) was called from %s%n", array, start, length, buf, context.getLRPointer());
                }
                short[] data = Arrays.copyOfRange((short[])Objects.requireNonNull(array).value, start, start + length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetShortArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                }
                buf.write(0L, data, 0, data.length);
                return 0L;
            }
        });
        UnidbgPointer _GetIntArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetLongArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetFloatArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetDoubleArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                DoubleArray array = (DoubleArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetDoubleArrayRegion(%s, %d, %d, %s) was called from %s%n", array, start, length, buf, context.getLRPointer());
                }
                double[] data = Arrays.copyOfRange((double[])Objects.requireNonNull(array).value, start, start + length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetDoubleArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                }
                buf.write(0L, data, 0, data.length);
                return 0L;
            }
        });
        UnidbgPointer _SetBooleanArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetByteArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                ByteArray array = (ByteArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->SetByteArrayRegion(%s, %d, %d, %s) was called from %s%n", array, start, length, buf, context.getLRPointer());
                }
                byte[] data = buf.getByteArray(0L, length);
                if (log.isDebugEnabled()) {
                    if (data.length > 1024) {
                        Inspector.inspect((byte[])Arrays.copyOf(data, 1024), (String)("SetByteArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                    } else {
                        Inspector.inspect((byte[])data, (String)("SetByteArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                    }
                }
                Objects.requireNonNull(array).setData(start, data);
                return 0L;
            }
        });
        UnidbgPointer _SetCharArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetShortArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetIntArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                IntArray array = (IntArray)DalvikVM64.this.getObject(object.toIntPeer());
                int[] data = buf.getIntArray(0L, length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetIntArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                }
                Objects.requireNonNull(array).setData(start, data);
                return 0L;
            }
        });
        UnidbgPointer _SetLongArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _SetFloatArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                FloatArray array = (FloatArray)DalvikVM64.this.getObject(object.toIntPeer());
                float[] data = buf.getFloatArray(0L, length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetIntArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                }
                Objects.requireNonNull(array).setData(start, data);
                return 0L;
            }
        });
        UnidbgPointer _SetDoubleArrayRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                DoubleArray array = (DoubleArray)DalvikVM64.this.getObject(object.toIntPeer());
                double[] data = buf.getDoubleArray(0L, length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SetDoubleArrayRegion array=" + array + ", start=" + start + ", length=" + length + ", buf=" + buf));
                }
                Objects.requireNonNull(array).setData(start, data);
                return 0L;
            }
        });
        UnidbgPointer _RegisterNatives = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer clazz = context.getPointerArg(1);
                UnidbgPointer methods = context.getPointerArg(2);
                int nMethods = context.getIntArg(3);
                DvmClass dvmClass = (DvmClass)DalvikVM64.this.classMap.get(clazz.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RegisterNatives dvmClass=" + dvmClass + ", methods=" + methods + ", nMethods=" + nMethods));
                }
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->RegisterNatives(%s, %s, %d) was called from %s%n", dvmClass.getClassName(), methods, nMethods, context.getLRPointer());
                }
                for (int i = 0; i < nMethods; ++i) {
                    Pointer method = methods.share((long)i * (long)emulator.getPointerSize() * 3L);
                    Pointer name = method.getPointer(0L);
                    Pointer signature = method.getPointer((long)emulator.getPointerSize());
                    Pointer fnPtr = method.getPointer((long)emulator.getPointerSize() * 2L);
                    String methodName = name.getString(0L);
                    String signatureValue = signature.getString(0L);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RegisterNatives dvmClass=" + dvmClass + ", name=" + methodName + ", signature=" + signatureValue + ", fnPtr=" + fnPtr));
                    }
                    dvmClass.nativesMap.put(methodName + signatureValue, (UnidbgPointer)fnPtr);
                    if (!DalvikVM64.this.verbose) continue;
                    System.out.printf("RegisterNative(%s, %s%s, %s)%n", dvmClass.getClassName(), methodName, signatureValue, fnPtr);
                }
                return 0L;
            }
        });
        UnidbgPointer _UnregisterNatives = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _MonitorEnter = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer env = context.getPointerArg(0);
                Object obj = DalvikVM64.this.getObject(context.getPointerArg(1).toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MonitorEnter env=" + env + ", obj=" + obj));
                }
                return 0L;
            }
        });
        UnidbgPointer _MonitorExit = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer env = context.getPointerArg(0);
                Object obj = DalvikVM64.this.getObject(context.getPointerArg(1).toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MonitorExit env=" + env + ", obj=" + obj));
                }
                return 0L;
            }
        });
        UnidbgPointer _GetJavaVM = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer vm = context.getPointerArg(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetJavaVM vm=" + vm));
                }
                vm.setPointer(0L, (Pointer)DalvikVM64.this._JavaVM);
                return 0L;
            }
        });
        UnidbgPointer _GetStringRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                StringObject string = (StringObject)DalvikVM64.this.getObject(object.toIntPeer());
                String value = (String)Objects.requireNonNull(string).getValue();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStringRegion(%s) was called from %s%n", string, context.getLRPointer());
                }
                byte[] bytes = new byte[value.length() * 2];
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                for (char c : value.toCharArray()) {
                    buffer.putChar(c);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStringRegion string=" + string + ", value=" + value + ", start=" + start + ", length=" + length + ", buf" + buf + ", lr=" + context.getLRPointer()));
                }
                byte[] data = Arrays.copyOfRange(bytes, start, start + length + 1);
                buf.write(0L, data, 0, data.length);
                return 0L;
            }
        });
        UnidbgPointer _GetStringUTFRegion = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                int start = context.getIntArg(2);
                int length = context.getIntArg(3);
                UnidbgPointer buf = context.getPointerArg(4);
                StringObject string = (StringObject)DalvikVM64.this.getObject(object.toIntPeer());
                String value = (String)Objects.requireNonNull(string).getValue();
                if (DalvikVM64.this.verbose) {
                    System.out.printf("JNIEnv->GetStringUTFRegion(%s) was called from %s%n", string, context.getLRPointer());
                }
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetStringUTFRegion string=" + string + ", value=" + value + ", start=" + start + ", length=" + length + ", buf" + buf + ", lr=" + context.getLRPointer()));
                }
                byte[] data = Arrays.copyOfRange(bytes, start, start + length + 1);
                buf.write(0L, data, 0, data.length);
                return 0L;
            }
        });
        UnidbgPointer _GetPrimitiveArrayCritical = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer isCopy = context.getPointerArg(2);
                PrimitiveArray array = (PrimitiveArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetPrimitiveArrayCritical array=" + array + ", isCopy=" + isCopy));
                }
                return Objects.requireNonNull(array)._GetArrayCritical(emulator, (Pointer)isCopy).peer;
            }
        });
        UnidbgPointer _ReleasePrimitiveArrayCritical = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                UnidbgPointer pointer = context.getPointerArg(2);
                int mode = context.getIntArg(3);
                PrimitiveArray array = (PrimitiveArray)DalvikVM64.this.getObject(object.toIntPeer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReleasePrimitiveArrayCritical array=" + array + ", pointer=" + pointer + ", mode=" + mode));
                }
                Objects.requireNonNull(array)._ReleaseArrayCritical((Pointer)pointer, mode);
                return 0L;
            }
        });
        UnidbgPointer _GetStringCritical = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ReleaseStringCritical = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _NewWeakGlobalRef = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                if (object == null) {
                    return 0L;
                }
                DvmObject dvmObject = (DvmObject)Objects.requireNonNull(DalvikVM64.this.getObject(object.toIntPeer()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NewWeakGlobalRef object=" + object + ", dvmObject=" + dvmObject + ", class=" + dvmObject.getClass()));
                }
                return DalvikVM64.this.addObject(dvmObject, true, true);
            }
        });
        UnidbgPointer _DeleteWeakGlobalRef = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _ExceptionCheck = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ExceptionCheck throwable=" + DalvikVM64.this.throwable));
                }
                return DalvikVM64.this.throwable == null ? 0L : 1L;
            }
        });
        UnidbgPointer _NewDirectByteBuffer = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetDirectBufferAddress = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetDirectBufferCapacity = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        UnidbgPointer _GetObjectRefType = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer object = context.getPointerArg(1);
                if (object == null) {
                    return 0L;
                }
                int hash = object.toIntPeer();
                BaseVM.ObjRef dvmLocalObject = (BaseVM.ObjRef)DalvikVM64.this.localObjectMap.get(object.toIntPeer());
                BaseVM.ObjRef dvmGlobalObject = DalvikVM64.this.globalObjectMap.containsKey(hash) ? (BaseVM.ObjRef)DalvikVM64.this.globalObjectMap.get(hash) : (DalvikVM64.this.weakGlobalObjectMap.containsKey(hash) ? (BaseVM.ObjRef)DalvikVM64.this.weakGlobalObjectMap.get(hash) : null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetObjectRefType object=" + object + ", dvmGlobalObject=" + dvmGlobalObject + ", dvmLocalObject=" + dvmLocalObject));
                }
                if (dvmGlobalObject != null) {
                    return dvmGlobalObject.weak ? 3L : 2L;
                }
                if (dvmLocalObject != null) {
                    return 1L;
                }
                return 0L;
            }
        });
        UnidbgPointer _GetModule = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        });
        int last = 1864;
        UnidbgPointer impl = svcMemory.allocate(1872, "JNIEnv.impl");
        for (int i = 0; i <= 1864; i += 8) {
            impl.setLong((long)i, (long)i);
        }
        impl.setPointer(32L, (Pointer)_GetVersion);
        impl.setPointer(40L, (Pointer)_DefineClass);
        impl.setPointer(48L, (Pointer)_FindClass);
        impl.setPointer(56L, (Pointer)_FromReflectedMethod);
        impl.setPointer(64L, (Pointer)_FromReflectedField);
        impl.setPointer(72L, (Pointer)_ToReflectedMethod);
        impl.setPointer(80L, (Pointer)_GetSuperclass);
        impl.setPointer(88L, (Pointer)_IsAssignableFrom);
        impl.setPointer(96L, (Pointer)_ToReflectedField);
        impl.setPointer(104L, (Pointer)_Throw);
        impl.setPointer(112L, (Pointer)_ThrowNew);
        impl.setPointer(120L, (Pointer)_ExceptionOccurred);
        impl.setPointer(128L, (Pointer)_ExceptionDescribe);
        impl.setPointer(136L, (Pointer)_ExceptionClear);
        impl.setPointer(144L, (Pointer)_FatalError);
        impl.setPointer(152L, (Pointer)_PushLocalFrame);
        impl.setPointer(160L, (Pointer)_PopLocalFrame);
        impl.setPointer(168L, (Pointer)_NewGlobalRef);
        impl.setPointer(176L, (Pointer)_DeleteGlobalRef);
        impl.setPointer(184L, (Pointer)_DeleteLocalRef);
        impl.setPointer(192L, (Pointer)_IsSameObject);
        impl.setPointer(200L, (Pointer)_NewLocalRef);
        impl.setPointer(208L, (Pointer)_EnsureLocalCapacity);
        impl.setPointer(216L, (Pointer)_AllocObject);
        impl.setPointer(224L, (Pointer)_NewObject);
        impl.setPointer(232L, (Pointer)_NewObjectV);
        impl.setPointer(240L, (Pointer)_NewObjectA);
        impl.setPointer(248L, (Pointer)_GetObjectClass);
        impl.setPointer(256L, (Pointer)_IsInstanceOf);
        impl.setPointer(264L, (Pointer)_GetMethodID);
        impl.setPointer(272L, (Pointer)_CallObjectMethod);
        impl.setPointer(280L, (Pointer)_CallObjectMethodV);
        impl.setPointer(288L, (Pointer)_CallObjectMethodA);
        impl.setPointer(296L, (Pointer)_CallBooleanMethod);
        impl.setPointer(304L, (Pointer)_CallBooleanMethodV);
        impl.setPointer(312L, (Pointer)_CallBooleanMethodA);
        impl.setPointer(320L, (Pointer)_CallByteMethod);
        impl.setPointer(328L, (Pointer)_CallByteMethodV);
        impl.setPointer(336L, (Pointer)_CallByteMethodA);
        impl.setPointer(344L, (Pointer)_CallCharMethod);
        impl.setPointer(352L, (Pointer)_CallCharMethodV);
        impl.setPointer(360L, (Pointer)_CallCharMethodA);
        impl.setPointer(368L, (Pointer)_CallShortMethod);
        impl.setPointer(376L, (Pointer)_CallShortMethodV);
        impl.setPointer(384L, (Pointer)_CallShortMethodA);
        impl.setPointer(392L, (Pointer)_CallIntMethod);
        impl.setPointer(400L, (Pointer)_CallIntMethodV);
        impl.setPointer(408L, (Pointer)_CallIntMethodA);
        impl.setPointer(416L, (Pointer)_CallLongMethod);
        impl.setPointer(424L, (Pointer)_CallLongMethodV);
        impl.setPointer(432L, (Pointer)_CallLongMethodA);
        impl.setPointer(440L, (Pointer)_CallFloatMethod);
        impl.setPointer(448L, (Pointer)_CallFloatMethodV);
        impl.setPointer(456L, (Pointer)_CallFloatMethodA);
        impl.setPointer(464L, (Pointer)_CallDoubleMethod);
        impl.setPointer(472L, (Pointer)_CallDoubleMethodV);
        impl.setPointer(480L, (Pointer)_CallDoubleMethodA);
        impl.setPointer(488L, (Pointer)_CallVoidMethod);
        impl.setPointer(496L, (Pointer)_CallVoidMethodV);
        impl.setPointer(504L, (Pointer)_CallVoidMethodA);
        impl.setPointer(512L, (Pointer)_CallNonvirtualObjectMethod);
        impl.setPointer(520L, (Pointer)_CallNonvirtualObjectMethodV);
        impl.setPointer(528L, (Pointer)_CallNonvirtualObjectMethodA);
        impl.setPointer(536L, (Pointer)_CallNonvirtualBooleanMethod);
        impl.setPointer(544L, (Pointer)_CallNonvirtualBooleanMethodV);
        impl.setPointer(552L, (Pointer)_CallNonvirtualBooleanMethodA);
        impl.setPointer(560L, (Pointer)_CallNonvirtualByteMethod);
        impl.setPointer(568L, (Pointer)_CallNonvirtualByteMethodV);
        impl.setPointer(576L, (Pointer)_CallNonvirtualByteMethodA);
        impl.setPointer(584L, (Pointer)_CallNonvirtualCharMethod);
        impl.setPointer(592L, (Pointer)_CallNonvirtualCharMethodV);
        impl.setPointer(600L, (Pointer)_CallNonvirtualCharMethodA);
        impl.setPointer(608L, (Pointer)_CallNonvirtualShortMethod);
        impl.setPointer(616L, (Pointer)_CallNonvirtualShortMethodV);
        impl.setPointer(624L, (Pointer)_CallNonvirtualShortMethodA);
        impl.setPointer(632L, (Pointer)_CallNonvirtualIntMethod);
        impl.setPointer(640L, (Pointer)_CallNonvirtualIntMethodV);
        impl.setPointer(648L, (Pointer)_CallNonvirtualIntMethodA);
        impl.setPointer(656L, (Pointer)_CallNonvirtualLongMethod);
        impl.setPointer(664L, (Pointer)_CallNonvirtualLongMethodV);
        impl.setPointer(672L, (Pointer)_CallNonvirtualLongMethodA);
        impl.setPointer(680L, (Pointer)_CallNonvirtualFloatMethod);
        impl.setPointer(688L, (Pointer)_CallNonvirtualFloatMethodV);
        impl.setPointer(696L, (Pointer)_CallNonvirtualFloatMethodA);
        impl.setPointer(704L, (Pointer)_CallNonvirtualDoubleMethod);
        impl.setPointer(712L, (Pointer)_CallNonvirtualDoubleMethodV);
        impl.setPointer(720L, (Pointer)_CallNonvirtualDoubleMethodA);
        impl.setPointer(728L, (Pointer)_CallNonvirtualVoidMethod);
        impl.setPointer(736L, (Pointer)_CallNonvirtualVoidMethodV);
        impl.setPointer(744L, (Pointer)_CallNonVirtualVoidMethodA);
        impl.setPointer(752L, (Pointer)_GetFieldID);
        impl.setPointer(760L, (Pointer)_GetObjectField);
        impl.setPointer(768L, (Pointer)_GetBooleanField);
        impl.setPointer(776L, (Pointer)_GetByteField);
        impl.setPointer(784L, (Pointer)_GetCharField);
        impl.setPointer(792L, (Pointer)_GetShortField);
        impl.setPointer(800L, (Pointer)_GetIntField);
        impl.setPointer(808L, (Pointer)_GetLongField);
        impl.setPointer(816L, (Pointer)_GetFloatField);
        impl.setPointer(824L, (Pointer)_GetDoubleField);
        impl.setPointer(832L, (Pointer)_SetObjectField);
        impl.setPointer(840L, (Pointer)_SetBooleanField);
        impl.setPointer(848L, (Pointer)_SetByteField);
        impl.setPointer(856L, (Pointer)_SetCharField);
        impl.setPointer(864L, (Pointer)_SetShortField);
        impl.setPointer(872L, (Pointer)_SetIntField);
        impl.setPointer(880L, (Pointer)_SetLongField);
        impl.setPointer(888L, (Pointer)_SetFloatField);
        impl.setPointer(896L, (Pointer)_SetDoubleField);
        impl.setPointer(904L, (Pointer)_GetStaticMethodID);
        impl.setPointer(912L, (Pointer)_CallStaticObjectMethod);
        impl.setPointer(920L, (Pointer)_CallStaticObjectMethodV);
        impl.setPointer(928L, (Pointer)_CallStaticObjectMethodA);
        impl.setPointer(936L, (Pointer)_CallStaticBooleanMethod);
        impl.setPointer(944L, (Pointer)_CallStaticBooleanMethodV);
        impl.setPointer(952L, (Pointer)_CallStaticBooleanMethodA);
        impl.setPointer(960L, (Pointer)_CallStaticByteMethod);
        impl.setPointer(968L, (Pointer)_CallStaticByteMethodV);
        impl.setPointer(976L, (Pointer)_CallStaticByteMethodA);
        impl.setPointer(984L, (Pointer)_CallStaticCharMethod);
        impl.setPointer(992L, (Pointer)_CallStaticCharMethodV);
        impl.setPointer(1000L, (Pointer)_CallStaticCharMethodA);
        impl.setPointer(1008L, (Pointer)_CallStaticShortMethod);
        impl.setPointer(1016L, (Pointer)_CallStaticShortMethodV);
        impl.setPointer(1024L, (Pointer)_CallStaticShortMethodA);
        impl.setPointer(1032L, (Pointer)_CallStaticIntMethod);
        impl.setPointer(1040L, (Pointer)_CallStaticIntMethodV);
        impl.setPointer(1048L, (Pointer)_CallStaticIntMethodA);
        impl.setPointer(1056L, (Pointer)_CallStaticLongMethod);
        impl.setPointer(1064L, (Pointer)_CallStaticLongMethodV);
        impl.setPointer(1072L, (Pointer)_CallStaticLongMethodA);
        impl.setPointer(1080L, (Pointer)_CallStaticFloatMethod);
        impl.setPointer(1088L, (Pointer)_CallStaticFloatMethodV);
        impl.setPointer(1096L, (Pointer)_CallStaticFloatMethodA);
        impl.setPointer(1104L, (Pointer)_CallStaticDoubleMethod);
        impl.setPointer(1112L, (Pointer)_CallStaticDoubleMethodV);
        impl.setPointer(1120L, (Pointer)_CallStaticDoubleMethodA);
        impl.setPointer(1128L, (Pointer)_CallStaticVoidMethod);
        impl.setPointer(1136L, (Pointer)_CallStaticVoidMethodV);
        impl.setPointer(1144L, (Pointer)_CallStaticVoidMethodA);
        impl.setPointer(1152L, (Pointer)_GetStaticFieldID);
        impl.setPointer(1160L, (Pointer)_GetStaticObjectField);
        impl.setPointer(1168L, (Pointer)_GetStaticBooleanField);
        impl.setPointer(1176L, (Pointer)_GetStaticByteField);
        impl.setPointer(1184L, (Pointer)_GetStaticCharField);
        impl.setPointer(1192L, (Pointer)_GetStaticShortField);
        impl.setPointer(1200L, (Pointer)_GetStaticIntField);
        impl.setPointer(1208L, (Pointer)_GetStaticLongField);
        impl.setPointer(1216L, (Pointer)_GetStaticFloatField);
        impl.setPointer(1224L, (Pointer)_GetStaticDoubleField);
        impl.setPointer(1232L, (Pointer)_SetStaticObjectField);
        impl.setPointer(1240L, (Pointer)_SetStaticBooleanField);
        impl.setPointer(1248L, (Pointer)_SetStaticByteField);
        impl.setPointer(1256L, (Pointer)_SetStaticCharField);
        impl.setPointer(1264L, (Pointer)_SetStaticShortField);
        impl.setPointer(1272L, (Pointer)_SetStaticIntField);
        impl.setPointer(1280L, (Pointer)_SetStaticLongField);
        impl.setPointer(1288L, (Pointer)_SetStaticFloatField);
        impl.setPointer(1296L, (Pointer)_SetStaticDoubleField);
        impl.setPointer(1304L, (Pointer)_NewString);
        impl.setPointer(1312L, (Pointer)_GetStringLength);
        impl.setPointer(1320L, (Pointer)_GetStringChars);
        impl.setPointer(1328L, (Pointer)_ReleaseStringChars);
        impl.setPointer(1336L, (Pointer)_NewStringUTF);
        impl.setPointer(1344L, (Pointer)_GetStringUTFLength);
        impl.setPointer(1352L, (Pointer)_GetStringUTFChars);
        impl.setPointer(1360L, (Pointer)_ReleaseStringUTFChars);
        impl.setPointer(1368L, (Pointer)_GetArrayLength);
        impl.setPointer(1376L, (Pointer)_NewObjectArray);
        impl.setPointer(1384L, (Pointer)_GetObjectArrayElement);
        impl.setPointer(1392L, (Pointer)_SetObjectArrayElement);
        impl.setPointer(1400L, (Pointer)_NewBooleanArray);
        impl.setPointer(1408L, (Pointer)_NewByteArray);
        impl.setPointer(1416L, (Pointer)_NewCharArray);
        impl.setPointer(1424L, (Pointer)_NewShortArray);
        impl.setPointer(1432L, (Pointer)_NewIntArray);
        impl.setPointer(1440L, (Pointer)_NewLongArray);
        impl.setPointer(1448L, (Pointer)_NewFloatArray);
        impl.setPointer(1456L, (Pointer)_NewDoubleArray);
        impl.setPointer(1464L, (Pointer)_GetBooleanArrayElements);
        impl.setPointer(1472L, (Pointer)_GetByteArrayElements);
        impl.setPointer(1480L, (Pointer)_GetCharArrayElements);
        impl.setPointer(1488L, (Pointer)_GetShortArrayElements);
        impl.setPointer(1496L, (Pointer)_GetIntArrayElements);
        impl.setPointer(1504L, (Pointer)_GetLongArrayElements);
        impl.setPointer(1512L, (Pointer)_GetFloatArrayElements);
        impl.setPointer(1520L, (Pointer)_GetDoubleArrayElements);
        impl.setPointer(1528L, (Pointer)_ReleaseBooleanArrayElements);
        impl.setPointer(1536L, (Pointer)_ReleaseByteArrayElements);
        impl.setPointer(1544L, (Pointer)_ReleaseCharArrayElements);
        impl.setPointer(1552L, (Pointer)_ReleaseShortArrayElements);
        impl.setPointer(1560L, (Pointer)_ReleaseIntArrayElements);
        impl.setPointer(1568L, (Pointer)_ReleaseLongArrayElements);
        impl.setPointer(1576L, (Pointer)_ReleaseFloatArrayElements);
        impl.setPointer(1584L, (Pointer)_ReleaseDoubleArrayElements);
        impl.setPointer(1592L, (Pointer)_GetBooleanArrayRegion);
        impl.setPointer(1600L, (Pointer)_GetByteArrayRegion);
        impl.setPointer(1608L, (Pointer)_GetCharArrayRegion);
        impl.setPointer(1616L, (Pointer)_GetShortArrayRegion);
        impl.setPointer(1624L, (Pointer)_GetIntArrayRegion);
        impl.setPointer(1632L, (Pointer)_GetLongArrayRegion);
        impl.setPointer(1640L, (Pointer)_GetFloatArrayRegion);
        impl.setPointer(1648L, (Pointer)_GetDoubleArrayRegion);
        impl.setPointer(1656L, (Pointer)_SetBooleanArrayRegion);
        impl.setPointer(1664L, (Pointer)_SetByteArrayRegion);
        impl.setPointer(1672L, (Pointer)_SetCharArrayRegion);
        impl.setPointer(1680L, (Pointer)_SetShortArrayRegion);
        impl.setPointer(1688L, (Pointer)_SetIntArrayRegion);
        impl.setPointer(1696L, (Pointer)_SetLongArrayRegion);
        impl.setPointer(1704L, (Pointer)_SetFloatArrayRegion);
        impl.setPointer(1712L, (Pointer)_SetDoubleArrayRegion);
        impl.setPointer(1720L, (Pointer)_RegisterNatives);
        impl.setPointer(1728L, (Pointer)_UnregisterNatives);
        impl.setPointer(1736L, (Pointer)_MonitorEnter);
        impl.setPointer(1744L, (Pointer)_MonitorExit);
        impl.setPointer(1752L, (Pointer)_GetJavaVM);
        impl.setPointer(1760L, (Pointer)_GetStringRegion);
        impl.setPointer(1768L, (Pointer)_GetStringUTFRegion);
        impl.setPointer(1776L, (Pointer)_GetPrimitiveArrayCritical);
        impl.setPointer(1784L, (Pointer)_ReleasePrimitiveArrayCritical);
        impl.setPointer(1792L, (Pointer)_GetStringCritical);
        impl.setPointer(1800L, (Pointer)_ReleaseStringCritical);
        impl.setPointer(1808L, (Pointer)_NewWeakGlobalRef);
        impl.setPointer(1816L, (Pointer)_DeleteWeakGlobalRef);
        impl.setPointer(1824L, (Pointer)_ExceptionCheck);
        impl.setPointer(1832L, (Pointer)_NewDirectByteBuffer);
        impl.setPointer(1840L, (Pointer)_GetDirectBufferAddress);
        impl.setPointer(1848L, (Pointer)_GetDirectBufferCapacity);
        impl.setPointer(1856L, (Pointer)_GetObjectRefType);
        impl.setPointer(1864L, (Pointer)_GetModule);
        this._JNIEnv = svcMemory.allocate(emulator.getPointerSize(), "_JNIEnv");
        this._JNIEnv.setPointer(0L, (Pointer)impl);
        UnidbgPointer _AttachCurrentThread = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer vm = context.getPointerArg(0);
                UnidbgPointer env = context.getPointerArg(1);
                UnidbgPointer args = context.getPointerArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AttachCurrentThread vm=" + vm + ", env=" + env.getPointer(0L) + ", args=" + args));
                }
                env.setPointer(0L, (Pointer)DalvikVM64.this._JNIEnv);
                return 0L;
            }
        });
        UnidbgPointer _GetEnv = svcMemory.registerSvc((Svc)new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer vm = context.getPointerArg(0);
                UnidbgPointer env = context.getPointerArg(1);
                int version = context.getIntArg(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GetEnv vm=" + vm + ", env=" + env.getPointer(0L) + ", version=0x" + Integer.toHexString(version)));
                }
                env.setPointer(0L, (Pointer)DalvikVM64.this._JNIEnv);
                return 0L;
            }
        });
        UnidbgPointer _JNIInvokeInterface = svcMemory.allocate(emulator.getPointerSize() * 8, "_JNIInvokeInterface");
        for (int i = 0; i < emulator.getPointerSize() * 8; i += emulator.getPointerSize()) {
            _JNIInvokeInterface.setInt((long)i, i);
        }
        _JNIInvokeInterface.setPointer((long)emulator.getPointerSize() * 4L, (Pointer)_AttachCurrentThread);
        _JNIInvokeInterface.setPointer((long)emulator.getPointerSize() * 6L, (Pointer)_GetEnv);
        this._JavaVM.setPointer(0L, (Pointer)_JNIInvokeInterface);
        if (log.isDebugEnabled()) {
            log.debug((Object)("_JavaVM=" + this._JavaVM + ", _JNIInvokeInterface=" + _JNIInvokeInterface + ", _JNIEnv=" + this._JNIEnv));
        }
    }

    @Override
    public Pointer getJavaVM() {
        return this._JavaVM;
    }

    @Override
    public Pointer getJNIEnv() {
        return this._JNIEnv;
    }

    @Override
    byte[] loadLibraryData(Apk apk, String soName) {
        byte[] soData = apk.getFileData("lib/arm64-v8a/" + soName);
        if (soData != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolve arm64-v8a library: " + soName));
            }
            return soData;
        }
        return null;
    }
}

