/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmAwareObject;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.Hashable;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObject;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.util.ArrayList;

public class DvmObject<T>
extends Hashable {
    private final DvmClass objectType;
    protected T value;
    private final BaseVM vm;
    protected MemoryBlock memoryBlock;

    protected DvmObject(DvmClass objectType, T value) {
        this(objectType == null ? null : objectType.vm, objectType, value);
    }

    private DvmObject(BaseVM vm, DvmClass objectType, T value) {
        this.vm = vm;
        this.objectType = objectType;
        this.value = value;
    }

    final void setValue(Object obj) {
        this.value = obj;
    }

    public T getValue() {
        return this.value;
    }

    public DvmClass getObjectType() {
        return this.objectType;
    }

    protected boolean isInstanceOf(DvmClass dvmClass) {
        return this.objectType != null && this.objectType.isInstance(dvmClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callJniMethod(Emulator<?> emulator, String method, Object ... args) {
        if (this.objectType == null) {
            throw new IllegalStateException("objectType is null");
        }
        try {
            DvmObject.callJniMethod(emulator, this.vm, this.objectType, this, method, args);
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    public boolean callJniMethodBoolean(Emulator<?> emulator, String method, Object ... args) {
        return BaseVM.valueOf(this.callJniMethodInt(emulator, method, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callJniMethodInt(Emulator<?> emulator, String method, Object ... args) {
        if (this.objectType == null) {
            throw new IllegalStateException("objectType is null");
        }
        try {
            int n = DvmObject.callJniMethod(emulator, this.vm, this.objectType, this, method, args).intValue();
            return n;
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long callJniMethodLong(Emulator<?> emulator, String method, Object ... args) {
        if (this.objectType == null) {
            throw new IllegalStateException("objectType is null");
        }
        try {
            long l = DvmObject.callJniMethod(emulator, this.vm, this.objectType, this, method, args).longValue();
            return l;
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends DvmObject<?>> V callJniMethodObject(Emulator<?> emulator, String method, Object ... args) {
        if (this.objectType == null) {
            throw new IllegalStateException("objectType is null");
        }
        try {
            Number number = DvmObject.callJniMethod(emulator, this.vm, this.objectType, this, method, args);
            Object t = this.objectType.vm.getObject(number.intValue());
            return (V)t;
        }
        finally {
            this.vm.deleteLocalRefs();
        }
    }

    protected static Number callJniMethod(Emulator<?> emulator, VM vm, DvmClass objectType, DvmObject<?> thisObj, String method, Object ... args) {
        UnidbgPointer fnPtr = objectType.findNativeFunction(emulator, method);
        vm.addLocalObject(thisObj);
        ArrayList<Object> list = new ArrayList<Object>(10);
        list.add(vm.getJNIEnv());
        list.add(thisObj.hashCode());
        if (args != null) {
            for (Object arg : args) {
                if (arg instanceof Boolean) {
                    list.add((Boolean)arg != false ? 1 : 0);
                    continue;
                }
                if (arg instanceof Hashable) {
                    list.add(arg.hashCode());
                    if (!(arg instanceof DvmObject)) continue;
                    vm.addLocalObject((DvmObject)arg);
                    continue;
                }
                if (arg instanceof DvmAwareObject || arg instanceof String || arg instanceof byte[] || arg instanceof short[] || arg instanceof int[] || arg instanceof float[] || arg instanceof double[] || arg instanceof Enum) {
                    DvmObject<?> obj = ProxyDvmObject.createObject(vm, arg);
                    list.add(obj.hashCode());
                    vm.addLocalObject(obj);
                    continue;
                }
                list.add(arg);
            }
        }
        return Module.emulateFunction(emulator, (long)fnPtr.peer, (Object[])list.toArray());
    }

    public String toString() {
        if (this.value instanceof Enum) {
            return this.value.toString();
        }
        if (this.objectType == null) {
            return this.getClass().getSimpleName() + "{value=" + this.value + '}';
        }
        return this.objectType.getName() + "@" + Integer.toHexString(this.hashCode());
    }

    protected final UnidbgPointer allocateMemoryBlock(Emulator<?> emulator, int length) {
        if (this.memoryBlock == null) {
            this.memoryBlock = emulator.getMemory().malloc(length, true);
        }
        return this.memoryBlock.getPointer();
    }

    protected final void freeMemoryBlock(Pointer pointer) {
        if (this.memoryBlock != null && (pointer == null || this.memoryBlock.isSame(pointer))) {
            this.memoryBlock.free();
            this.memoryBlock = null;
        }
    }

    final void onDeleteRef() {
        this.freeMemoryBlock(null);
    }
}

