/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.api;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;

public class Asset
extends DvmObject<String> {
    public Asset(VM vm, String value) {
        super(vm.resolveClass("android/content/res/Asset", new DvmClass[0]), value);
    }

    public void open(Emulator<?> emulator, byte[] data) {
        UnidbgPointer pointer = this.allocateMemoryBlock(emulator, data.length + 8);
        pointer.setInt(0L, 0);
        pointer.setInt(4L, data.length);
        pointer.write(8L, data, 0, data.length);
    }

    public void close() {
        this.freeMemoryBlock(null);
    }

    public UnidbgPointer getBuffer() {
        return this.memoryBlock.getPointer().share(8L, 0L);
    }

    public int getLength() {
        return this.memoryBlock.getPointer().getInt(4L);
    }

    public byte[] read(int count) {
        UnidbgPointer pointer = this.memoryBlock.getPointer();
        int index = pointer.getInt(0L);
        int length = pointer.getInt(4L);
        Pointer data = pointer.share(8L, 0L);
        int remaining = length - index;
        int read = Math.min(remaining, count);
        pointer.setInt(0L, index + read);
        return data.getByteArray((long)index, read);
    }
}

