/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.linux.file.LocalSocketIO;
import com.github.unidbg.utils.Inspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DnsProxyDaemon
implements LocalSocketIO.SocketHandler {
    private static final Log log = LogFactory.getLog(DnsProxyDaemon.class);
    private static final int DnsProxyQueryResult = 222;
    private static final int DnsProxyOperationFailed = 401;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    private final int sdk;

    DnsProxyDaemon(int sdk) {
        this.sdk = sdk;
    }

    @Override
    public int fstat(StatStructure stat) {
        stat.st_size = 0L;
        stat.st_blksize = 0;
        stat.pack();
        return 0;
    }

    @Override
    public byte[] handle(byte[] request) throws IOException {
        this.baos.write(request);
        byte[] data = this.baos.toByteArray();
        int endIndex = -1;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            return null;
        }
        this.baos.reset();
        String command = new String(data, 0, endIndex);
        if (command.startsWith("getaddrinfo")) {
            return this.getaddrinfo(command);
        }
        if (command.startsWith("gethostbyaddr")) {
            return this.gethostbyaddr(command);
        }
        throw new AbstractMethodError(command);
    }

    private byte[] gethostbyaddr(String command) {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        String[] tokens = command.split("\\s");
        String addr = tokens[1];
        try {
            InetAddress address = InetAddress.getByName(addr);
            String host = address.getCanonicalHostName();
            if (host != null && host.equals(addr)) {
                host = null;
            }
            if (host == null) {
                throw new UnknownHostException();
            }
            buffer.put("222\u0000".getBytes());
            byte[] bytes = host.getBytes(StandardCharsets.UTF_8);
            buffer.putInt(bytes.length + 1);
            buffer.put(bytes);
            buffer.put((byte)0);
            buffer.putInt(0);
            buffer.putInt(2);
            buffer.putInt(4);
            buffer.putInt(0);
        }
        catch (UnknownHostException e) {
            buffer.put("401\u0000".getBytes());
            buffer.putInt(0);
        }
        buffer.flip();
        byte[] response = new byte[buffer.remaining()];
        buffer.get(response);
        if (log.isDebugEnabled()) {
            Inspector.inspect((byte[])response, (String)"gethostbyaddr");
        }
        return response;
    }

    private byte[] getaddrinfo(String command) {
        String[] tokens = command.split("\\s");
        String hostname = tokens[1];
        String servername = tokens[2];
        short port = 0;
        if (!"^".equals(servername)) {
            try {
                port = Short.parseShort(servername);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int ai_flags = Integer.parseInt(tokens[3]);
        int ai_family = Integer.parseInt(tokens[4]);
        int ai_socktype = Integer.parseInt(tokens[5]);
        int ai_protocol = Integer.parseInt(tokens[6]);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        try {
            Object[] addresses = InetAddress.getAllByName(hostname);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getaddrinfo hostname=" + hostname + ", servername=" + servername + ", addresses=" + Arrays.toString(addresses) + ", ai_flags=" + ai_flags + ", ai_family=" + ai_family + ", ai_socktype=" + ai_socktype + ", ai_protocol=" + ai_protocol));
            }
            buffer.put("222\u0000".getBytes());
            for (Object address : addresses) {
                this.putAddress(buffer, (InetAddress)address, ai_flags, ai_socktype, port);
            }
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(0);
        }
        catch (UnknownHostException e) {
            int EAI_NODATA = 7;
            buffer.put("401\u0000".getBytes());
            buffer.putInt(4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(7);
        }
        buffer.flip();
        byte[] response = new byte[buffer.remaining()];
        buffer.get(response);
        if (log.isDebugEnabled()) {
            Inspector.inspect((byte[])response, (String)"getaddrinfo");
        }
        return response;
    }

    private void putAddress(ByteBuffer buffer, InetAddress address, int ai_flags, int ai_socktype, short port) {
        if (this.sdk == 19) {
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(32);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(ai_flags);
            buffer.putInt(2);
            buffer.putInt(ai_socktype);
            buffer.putInt(6);
            buffer.putInt(16);
            buffer.putInt(0);
            buffer.putInt(0);
            buffer.putInt(0);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(16);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort((short)2);
            buffer.putShort(Short.reverseBytes(port));
            buffer.put(Arrays.copyOf(address.getAddress(), 4));
            buffer.put(new byte[8]);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(0);
        } else if (this.sdk == 23) {
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(1);
            buffer.putInt(ai_flags);
            buffer.putInt(2);
            buffer.putInt(ai_socktype);
            buffer.putInt(6);
            buffer.putInt(16);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort((short)2);
            buffer.putShort(Short.reverseBytes(port));
            buffer.put(Arrays.copyOf(address.getAddress(), 4));
            buffer.put(new byte[8]);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(0);
        } else {
            throw new IllegalStateException("sdk=" + this.sdk);
        }
    }
}

