/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.linux.file.SocketIO;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LocalUdpSocket
extends SocketIO
implements FileIO {
    private static final Log log = LogFactory.getLog(LocalUdpSocket.class);
    protected final Emulator<?> emulator;
    protected UdpHandler handler;

    protected LocalUdpSocket(Emulator<?> emulator) {
        this.emulator = emulator;
    }

    public void close() {
        this.handler = null;
    }

    public int write(byte[] data) {
        try {
            this.handler.handle(data);
            return data.length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract int connect(String var1);

    @Override
    public int connect(Pointer addr, int addrlen) {
        short sa_family = addr.getShort(0L);
        if (sa_family != 1) {
            throw new UnsupportedOperationException("sa_family=" + sa_family);
        }
        String path = addr.getString(2L);
        log.debug((Object)("connect sa_family=" + sa_family + ", path=" + path));
        return this.connect(path);
    }

    @Override
    protected int getTcpNoDelay() {
        throw new AbstractMethodError();
    }

    @Override
    protected void setTcpNoDelay(int tcpNoDelay) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setReuseAddress(int reuseAddress) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setKeepAlive(int keepAlive) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setSendBufferSize(int size) {
        throw new AbstractMethodError();
    }

    @Override
    protected void setReceiveBufferSize(int size) {
        throw new AbstractMethodError();
    }

    @Override
    protected InetSocketAddress getLocalSocketAddress() {
        throw new AbstractMethodError();
    }

    @Override
    protected int connect_ipv6(Pointer addr, int addrlen) {
        throw new AbstractMethodError();
    }

    @Override
    protected int connect_ipv4(Pointer addr, int addrlen) {
        throw new AbstractMethodError();
    }

    protected static interface UdpHandler {
        public void handle(byte[] var1) throws IOException;
    }
}

