/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.Utils;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleFileIO
extends BaseAndroidFileIO
implements NewFileIO {
    private static final Log log = LogFactory.getLog(SimpleFileIO.class);
    protected final File file;
    protected final String path;
    private RandomAccessFile _randomAccessFile;
    OutputStream debugStream;

    private synchronized RandomAccessFile checkOpenFile() {
        try {
            if (this._randomAccessFile == null) {
                FileUtils.forceMkdir((File)this.file.getParentFile());
                if (!this.file.exists() && !this.file.createNewFile()) {
                    throw new IOException("createNewFile failed: " + this.file);
                }
                this._randomAccessFile = new RandomAccessFile(this.file, "rws");
                this.onFileOpened(this._randomAccessFile);
            }
            return this._randomAccessFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public SimpleFileIO(int oflags, File file, String path) {
        super(oflags);
        this.file = file;
        this.path = path;
        if (file.isDirectory()) {
            throw new IllegalArgumentException("file is directory: " + file);
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file not exists: " + file);
        }
    }

    void onFileOpened(RandomAccessFile randomAccessFile) throws IOException {
    }

    public void close() {
        IOUtils.close((Closeable)this._randomAccessFile);
        if (this.debugStream != null) {
            try {
                this.debugStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int write(byte[] data) {
        try {
            if (this.debugStream != null) {
                this.debugStream.write(data);
                this.debugStream.flush();
            }
            if (log.isDebugEnabled() && data.length < 12288) {
                Inspector.inspect((byte[])data, (String)"write");
            }
            RandomAccessFile randomAccessFile = this.checkOpenFile();
            if ((this.oflags & 0x400) != 0) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            randomAccessFile.write(data);
            return data.length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void setDebugStream(OutputStream stream) {
        this.debugStream = new BufferedOutputStream(stream);
    }

    public int read(Backend backend, Pointer pointer, int _count) {
        RandomAccessFile randomAccessFile = this.checkOpenFile();
        return Utils.readFile((RandomAccessFile)randomAccessFile, (Pointer)pointer, (int)_count);
    }

    @Override
    public int fstat(Emulator<?> emulator, StatStructure stat) {
        int st_mode = "stdout".equals(this.file.getName()) ? 10103 : (Files.isSymbolicLink(this.file.toPath()) ? 40960 : 32768);
        stat.st_dev = 1L;
        stat.st_mode = st_mode;
        stat.st_uid = 0;
        stat.st_gid = 0;
        stat.st_size = this.file.length();
        stat.st_blksize = emulator.getPageAlign();
        stat.st_ino = 1L;
        stat.st_blocks = (this.file.length() + (long)emulator.getPageAlign() - 1L) / (long)emulator.getPageAlign();
        stat.setLastModification(this.file.lastModified());
        stat.pack();
        return 0;
    }

    protected byte[] getMmapData(long addr, int offset, int length) throws IOException {
        int count;
        RandomAccessFile randomAccessFile = this.checkOpenFile();
        randomAccessFile.seek(offset);
        int remaining = (int)(randomAccessFile.length() - randomAccessFile.getFilePointer());
        ByteArrayOutputStream baos = remaining <= 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(Math.min(length, remaining));
        byte[] buf = new byte[1024];
        while ((count = length - baos.size()) != 0) {
            int read;
            if (count > buf.length) {
                count = buf.length;
            }
            if ((read = randomAccessFile.read(buf, 0, count)) == -1) break;
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }

    public String toString() {
        return this.path;
    }

    public int ioctl(Emulator<?> emulator, long request, long argp) {
        if ("stdout".equals(this.path) || "stderr".equals(this.path)) {
            return 0;
        }
        return super.ioctl(emulator, request, argp);
    }

    public FileIO dup2() {
        SimpleFileIO dup = new SimpleFileIO(this.oflags, this.file, this.path);
        dup.debugStream = this.debugStream;
        dup.op = this.op;
        dup.oflags = this.oflags;
        return dup;
    }

    public int lseek(int offset, int whence) {
        try {
            RandomAccessFile randomAccessFile = this.checkOpenFile();
            switch (whence) {
                case 0: {
                    randomAccessFile.seek(offset);
                    return (int)randomAccessFile.getFilePointer();
                }
                case 1: {
                    randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)offset);
                    return (int)randomAccessFile.getFilePointer();
                }
                case 2: {
                    randomAccessFile.seek(randomAccessFile.length() + (long)offset);
                    return (int)randomAccessFile.getFilePointer();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.lseek(offset, whence);
    }

    public int llseek(long offset, Pointer result, int whence) {
        try {
            RandomAccessFile randomAccessFile = this.checkOpenFile();
            switch (whence) {
                case 0: {
                    randomAccessFile.seek(offset);
                    result.setLong(0L, randomAccessFile.getFilePointer());
                    return 0;
                }
                case 2: {
                    randomAccessFile.seek(randomAccessFile.length() - offset);
                    result.setLong(0L, randomAccessFile.getFilePointer());
                    return 0;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.llseek(offset, result, whence);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int ftruncate(int length) {
        try (FileChannel channel = new FileOutputStream(this.file, true).getChannel();){
            channel.truncate(length);
            int n = 0;
            return n;
        }
        catch (IOException e) {
            log.debug((Object)"ftruncate failed", (Throwable)e);
            return -1;
        }
    }

    public String getPath() {
        return this.path;
    }
}

