/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.ThreadTask;
import com.sun.jna.Pointer;

public class KitKatThread
extends ThreadTask {
    private final UnidbgPointer child_stack;
    private final UnidbgPointer fn;
    private final UnidbgPointer arg;
    private Pointer errno;

    public KitKatThread(int tid, long until, UnidbgPointer child_stack, UnidbgPointer fn, UnidbgPointer arg) {
        super(tid, until);
        this.child_stack = child_stack;
        this.fn = fn;
        this.arg = arg;
    }

    public boolean setErrno(Emulator<?> emulator, int errno) {
        if (this.errno != null) {
            this.errno.setInt(0L, errno);
            return true;
        }
        return super.setErrno(emulator, errno);
    }

    public String toString() {
        return "KitKatThread fn=" + this.fn + ", arg=" + this.arg + ", child_stack=" + this.child_stack;
    }

    protected Number runThread(AbstractEmulator<?> emulator) {
        Backend backend = emulator.getBackend();
        UnidbgPointer stack = this.allocateStack((Emulator)emulator);
        backend.reg_write(12, (Number)stack.peer);
        this.errno = this.child_stack.share(8L);
        backend.reg_write(66, (Number)this.fn.peer);
        backend.reg_write(67, (Number)(this.arg == null ? 0L : this.arg.peer));
        backend.reg_write(68, (Number)this.child_stack.peer);
        backend.reg_write(10, (Number)this.until);
        Module libc = emulator.getMemory().findModule("libc.so");
        Symbol __thread_entry = libc.findSymbolByName("__thread_entry", false);
        if (__thread_entry == null) {
            throw new IllegalStateException();
        }
        return emulator.emulate(__thread_entry.getAddress(), this.until);
    }
}

