/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.virtualmodule.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.api.Asset;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.virtualmodule.VirtualModule;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AndroidModule
extends VirtualModule<VM> {
    private static final Log log = LogFactory.getLog(AndroidModule.class);

    public AndroidModule(Emulator<?> emulator, VM vm) {
        super(emulator, (Object)vm, "libandroid.so");
    }

    protected void onInitialize(Emulator<?> emulator, final VM vm, Map<String, UnidbgPointer> symbols) {
        boolean is64Bit = emulator.is64Bit();
        SvcMemory svcMemory = emulator.getSvcMemory();
        symbols.put("AAssetManager_fromJava", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.fromJava(emulator, vm);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.fromJava(emulator, vm);
            }
        })));
        symbols.put("AAssetManager_open", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.open(emulator, vm);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.open(emulator, vm);
            }
        })));
        symbols.put("AAsset_close", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.close(emulator, vm);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.close(emulator, vm);
            }
        })));
        symbols.put("AAsset_getBuffer", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.getBuffer(emulator, vm);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.getBuffer(emulator, vm);
            }
        })));
        symbols.put("AAsset_getLength", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.getLength(emulator, vm);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.getLength(emulator, vm);
            }
        })));
        symbols.put("AAsset_read", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new BackendException();
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return AndroidModule.read(emulator, vm);
            }
        })));
    }

    private static long fromJava(Emulator<?> emulator, VM vm) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer env = context.getPointerArg(0);
        UnidbgPointer assetManager = context.getPointerArg(1);
        Object obj = vm.getObject(assetManager.toIntPeer());
        if (log.isDebugEnabled()) {
            log.debug((Object)("AAssetManager_fromJava env=" + env + ", assetManager=" + ((DvmObject)obj).getObjectType() + ", LR=" + context.getLRPointer()));
        }
        return assetManager.peer;
    }

    private static long open(Emulator<?> emulator, VM vm) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer amgr = context.getPointerArg(0);
        String filename = context.getPointerArg(1).getString(0L);
        int mode = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("AAssetManager_open amgr=" + amgr + ", filename=" + filename + ", mode=" + mode + ", LR=" + context.getLRPointer()));
        }
        boolean AASSET_MODE_UNKNOWN = false;
        boolean AASSET_MODE_RANDOM = true;
        int AASSET_MODE_STREAMING = 2;
        int AASSET_MODE_BUFFER = 3;
        if (mode == 2 || 3 == mode || mode == 0 || mode == 1) {
            byte[] data = vm.openAsset(filename);
            if (data == null) {
                return 0L;
            }
            Asset asset = new Asset(vm, filename);
            asset.open(emulator, data);
            return vm.addLocalObject(asset);
        }
        throw new BackendException("filename=" + filename + ", mode=" + mode + ", LR=" + context.getLRPointer());
    }

    private static long close(Emulator<?> emulator, VM vm) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer pointer = context.getPointerArg(0);
        Asset asset = (Asset)vm.getObject(pointer.toIntPeer());
        asset.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("AAsset_close pointer=" + pointer + ", LR=" + context.getLRPointer()));
        }
        return 0L;
    }

    private static long getBuffer(Emulator<?> emulator, VM vm) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer pointer = context.getPointerArg(0);
        Asset asset = (Asset)vm.getObject(pointer.toIntPeer());
        UnidbgPointer buffer = asset.getBuffer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("AAsset_getBuffer pointer=" + pointer + ", buffer=" + buffer + ", LR=" + context.getLRPointer()));
        }
        return buffer.peer;
    }

    private static long getLength(Emulator<?> emulator, VM vm) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer pointer = context.getPointerArg(0);
        Asset asset = (Asset)vm.getObject(pointer.toIntPeer());
        int length = asset.getLength();
        if (log.isDebugEnabled()) {
            log.debug((Object)("AAsset_getLength pointer=" + pointer + ", length=" + length + ", LR=" + context.getLRPointer()));
        }
        return length;
    }

    private static long read(Emulator<?> emulator, VM vm) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer pointer = context.getPointerArg(0);
        UnidbgPointer buf = context.getPointerArg(1);
        int count = context.getIntArg(2);
        Asset asset = (Asset)vm.getObject(pointer.toIntPeer());
        byte[] bytes = asset.read(count);
        if (log.isDebugEnabled()) {
            log.debug((Object)("AAsset_read pointer=" + pointer + ", buf=" + buf + ", count=" + count + ", LR=" + context.getLRPointer()));
        }
        buf.write(0L, bytes, 0, bytes.length);
        return bytes.length;
    }
}

