/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.virtualmodule.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.virtualmodule.VirtualModule;
import com.sun.jna.Pointer;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MediaNdkModule
extends VirtualModule<VM> {
    private static final Log log = LogFactory.getLog(MediaNdkModule.class);
    public static final byte[] WIDE_VINE_UUID = new byte[]{-19, -17, -117, -87, 121, -42, 74, -50, -93, -56, 39, -36, -43, 29, 33, -19};
    private MemoryBlock vendorPropertyBlock;

    public MediaNdkModule(Emulator<?> emulator, VM vm) {
        super(emulator, (Object)vm, "libmediandk.so");
    }

    protected void onInitialize(Emulator<?> emulator, VM extra, Map<String, UnidbgPointer> symbols) {
        boolean is64Bit = emulator.is64Bit();
        SvcMemory svcMemory = emulator.getSvcMemory();
        symbols.put("AMediaDrm_createByUUID", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.createByUUID(emulator);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.createByUUID(emulator);
            }
        })));
        symbols.put("AMediaDrm_getPropertyByteArray", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.getPropertyByteArray(emulator);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.getPropertyByteArray(emulator);
            }
        })));
        symbols.put("AMediaDrm_getPropertyString", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.getPropertyString(emulator);
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.getPropertyString(emulator);
            }
        })));
        symbols.put("AMediaDrm_release", svcMemory.registerSvc((Svc)(is64Bit ? new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.release();
            }
        } : new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                return MediaNdkModule.this.release();
            }
        })));
    }

    private long createByUUID(Emulator<?> emulator) {
        RegisterContext context;
        UnidbgPointer uuidPtr;
        byte[] uuid;
        if (log.isDebugEnabled()) {
            log.debug((Object)"call createByUUID");
        }
        if (Arrays.equals(uuid = (uuidPtr = (context = emulator.getContext()).getPointerArg(0)).getByteArray(0L, 16), WIDE_VINE_UUID)) {
            return emulator.getMemory().malloc((int)8, (boolean)true).getPointer().peer;
        }
        throw new UnsupportedOperationException("createByUUID");
    }

    private long getPropertyByteArray(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer propertyNamePtr = context.getPointerArg(1);
        UnidbgPointer propertyValuePtr = context.getPointerArg(2);
        String propertyName = propertyNamePtr.getString(0L);
        if (propertyName.equals("deviceUniqueId")) {
            MemoryBlock memoryBlock = emulator.getMemory().malloc(32, true);
            byte[] b = new byte[32];
            new Random().nextBytes(b);
            memoryBlock.getPointer().write(0L, b, 0, 32);
            propertyValuePtr.setPointer(0L, (Pointer)memoryBlock.getPointer());
            propertyValuePtr.setLong((long)emulator.getPointerSize(), 32L);
            return 0L;
        }
        throw new UnsupportedOperationException("getPropertyByteArray");
    }

    private long getPropertyString(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer propertyNamePtr = context.getPointerArg(1);
        UnidbgPointer propertyValuePtr = context.getPointerArg(2);
        String propertyName = propertyNamePtr.getString(0L);
        if ("vendor".equals(propertyName)) {
            String value = "Google";
            if (this.vendorPropertyBlock == null) {
                this.vendorPropertyBlock = emulator.getMemory().malloc("Google".length(), true);
            }
            this.vendorPropertyBlock.getPointer().setString(0L, "Google");
            propertyValuePtr.setPointer(0L, (Pointer)this.vendorPropertyBlock.getPointer());
            if (emulator.is32Bit()) {
                propertyValuePtr.setInt(4L, "Google".length());
            } else {
                propertyValuePtr.setLong(8L, (long)"Google".length());
            }
            return 0L;
        }
        throw new UnsupportedOperationException("getPropertyString: " + propertyName);
    }

    private long release() {
        if (this.vendorPropertyBlock != null) {
            this.vendorPropertyBlock.free();
            this.vendorPropertyBlock = null;
        }
        return 0L;
    }
}

