/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import com.github.unidbg.Utils;
import com.github.unidbg.utils.Inspector;
import java.nio.ByteBuffer;
import java.util.Iterator;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfRelocation;
import net.fornwall.jelf.MemoizedObject;
import net.fornwall.jelf.SymbolLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AndroidRelocationIterator
implements Iterator<MemoizedObject<ElfRelocation>> {
    private static final Log log = LogFactory.getLog(AndroidRelocationIterator.class);
    private static final int RELOCATION_GROUPED_BY_INFO_FLAG = 1;
    private static final int RELOCATION_GROUPED_BY_OFFSET_DELTA_FLAG = 2;
    private static final int RELOCATION_GROUPED_BY_ADDEND_FLAG = 4;
    private static final int RELOCATION_GROUP_HAS_ADDEND_FLAG = 8;
    private final int objectSize;
    private final ByteBuffer buffer;
    private long relocation_count_;
    private final ElfRelocation reloc_;
    private final boolean rela;
    private long relocation_index_;
    private long relocation_group_index_;
    private long group_size_;
    private long group_flags_;
    private long group_r_offset_delta_;

    private long readSleb128() {
        return Utils.readSignedLeb128((ByteBuffer)this.buffer, (int)(this.objectSize == 1 ? 32 : 64));
    }

    public AndroidRelocationIterator(int objectSize, SymbolLocator symtab, ByteBuffer buffer, boolean rela) {
        this.objectSize = objectSize;
        this.buffer = buffer;
        this.rela = rela;
        this.reloc_ = new ElfRelocation(objectSize, symtab);
        this.relocation_count_ = this.readSleb128();
        this.reloc_.offset = this.readSleb128();
        this.relocation_index_ = 0L;
        this.relocation_group_index_ = 0L;
        this.group_size_ = 0L;
    }

    @Override
    public boolean hasNext() {
        boolean next;
        boolean bl = next = this.relocation_index_ < this.relocation_count_;
        if (!next && log.isDebugEnabled()) {
            byte[] remaining = new byte[this.buffer.remaining()];
            this.buffer.get(remaining);
            Inspector.inspect((byte[])remaining, (String)"end");
        }
        return next;
    }

    @Override
    public MemoizedObject<ElfRelocation> next() {
        if (this.relocation_group_index_ == this.group_size_ && !this.read_group_fields()) {
            this.relocation_index_ = 0L;
            this.relocation_count_ = 0L;
            return null;
        }
        this.reloc_.offset = this.is_relocation_grouped_by_offset_delta() ? (this.reloc_.offset += this.group_r_offset_delta_) : (this.reloc_.offset += this.readSleb128());
        if (!this.is_relocation_grouped_by_info()) {
            this.reloc_.info = this.readSleb128();
        }
        if (this.is_relocation_group_has_addend() && !this.is_relocation_grouped_by_addend()) {
            if (!this.rela) {
                throw new IllegalStateException("unexpected r_addend in android.rel section");
            }
            this.reloc_.addend += this.readSleb128();
        }
        ++this.relocation_index_;
        ++this.relocation_group_index_;
        try {
            final ElfRelocation copy = this.reloc_.clone();
            return new MemoizedObject<ElfRelocation>(){

                @Override
                protected ElfRelocation computeValue() throws ElfException {
                    return copy;
                }
            };
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean read_group_fields() {
        this.group_size_ = this.readSleb128();
        this.group_flags_ = this.readSleb128();
        if (this.is_relocation_grouped_by_offset_delta()) {
            this.group_r_offset_delta_ = this.readSleb128();
        }
        if (this.is_relocation_grouped_by_info()) {
            this.reloc_.info = this.readSleb128();
        }
        if (this.is_relocation_group_has_addend() && this.is_relocation_grouped_by_addend()) {
            if (!this.rela) {
                throw new IllegalStateException("unexpected r_addend in android.rel section");
            }
            this.reloc_.addend += this.readSleb128();
        } else if (!this.is_relocation_group_has_addend() && this.rela) {
            this.reloc_.addend = 0L;
        }
        this.relocation_group_index_ = 0L;
        return true;
    }

    private boolean is_relocation_grouped_by_info() {
        return (this.group_flags_ & 1L) != 0L;
    }

    private boolean is_relocation_grouped_by_offset_delta() {
        return (this.group_flags_ & 2L) != 0L;
    }

    private boolean is_relocation_grouped_by_addend() {
        return (this.group_flags_ & 4L) != 0L;
    }

    private boolean is_relocation_group_has_addend() {
        return (this.group_flags_ & 8L) != 0L;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

