/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSegment;
import net.fornwall.jelf.ElfStringTable;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.MemoizedObject;

public final class ElfFile {
    public static final int FT_REL = 1;
    public static final int FT_EXEC = 2;
    public static final int FT_DYN = 3;
    public static final int FT_CORE = 4;
    public static final byte CLASS_32 = 1;
    public static final byte CLASS_64 = 2;
    public static final byte DATA_LSB = 1;
    public static final byte DATA_MSB = 2;
    public static final int ARCH_NONE = 0;
    public static final int ARCH_ATT = 1;
    public static final int ARCH_SPARC = 2;
    public static final int ARCH_i386 = 3;
    public static final int ARCH_68k = 4;
    public static final int ARCH_88k = 5;
    public static final int ARCH_i860 = 7;
    public static final int ARCH_MIPS = 8;
    public static final int ARCH_ARM = 40;
    public static final int ARCH_X86_64 = 62;
    public static final int ARCH_AARCH64 = 183;
    public final byte objectSize;
    public final byte encoding;
    public final short file_type;
    public final short arch;
    public final int version;
    public final long entry_point;
    public final long ph_offset;
    public final long sh_offset;
    public int flags;
    public short eh_size;
    public final short ph_entry_size;
    public final short num_ph;
    public final short sh_entry_size;
    public final short num_sh;
    private final int sh_string_ndx;
    private final MemoizedObject<ElfSection>[] sectionHeaders;
    private final MemoizedObject<ElfSegment>[] programHeaders;
    private ElfSection symbolTableSection;
    private ElfSection dynamicSymbolTableSection;
    private ElfSection dynamicLinkSection;
    private ElfSection initArraySection;
    private ElfSection preInitArraySection;

    public ElfSection getSection(int index) throws ElfException, IOException {
        return this.sectionHeaders[index].getValue();
    }

    public ElfStringTable getSectionNameStringTable() throws ElfException, IOException {
        return this.getSection(this.sh_string_ndx).getStringTable();
    }

    public ElfStringTable getStringTable() throws ElfException, IOException {
        return this.findStringTableWithName(".strtab");
    }

    public ElfStringTable getDynamicStringTable() throws ElfException, IOException {
        return this.findStringTableWithName(".dynstr");
    }

    private ElfStringTable findStringTableWithName(String tableName) throws ElfException, IOException {
        for (int i = 1; i < this.num_sh; ++i) {
            ElfSection sh = this.getSection(i);
            if (!tableName.equals(sh.getName())) continue;
            return sh.getStringTable();
        }
        return null;
    }

    public ElfSection getSymbolTableSection() throws ElfException, IOException {
        return this.symbolTableSection != null ? this.symbolTableSection : (this.symbolTableSection = this.findSectionSectionByType(2));
    }

    public ElfSection getDynamicSymbolTableSection() throws ElfException, IOException {
        return this.dynamicSymbolTableSection != null ? this.dynamicSymbolTableSection : (this.dynamicSymbolTableSection = this.findSectionSectionByType(11));
    }

    public ElfSection getDynamicLinkSection() throws IOException {
        return this.dynamicLinkSection != null ? this.dynamicLinkSection : (this.dynamicLinkSection = this.findSectionSectionByType(6));
    }

    public ElfSection getInitArraySection() throws IOException {
        return this.initArraySection != null ? this.initArraySection : (this.initArraySection = this.findSectionSectionByType(14));
    }

    public ElfSection getPreInitArraySection() throws IOException {
        return this.preInitArraySection != null ? this.preInitArraySection : (this.preInitArraySection = this.findSectionSectionByType(16));
    }

    private ElfSection findSectionSectionByType(int type) throws ElfException, IOException {
        for (int i = 1; i < this.num_sh; ++i) {
            ElfSection sh = this.getSection(i);
            if (sh.type != type) continue;
            return sh;
        }
        return null;
    }

    public ElfSymbol getELFSymbol(String symbolName) throws ElfException, IOException {
        ElfSymbol symbol;
        int i;
        int numSymbols;
        if (symbolName == null) {
            return null;
        }
        ElfSection sh = this.getDynamicSymbolTableSection();
        if (sh != null) {
            numSymbols = sh.getNumberOfSymbols();
            i = 0;
            while ((double)i < Math.ceil((double)numSymbols / 2.0)) {
                symbol = sh.getELFSymbol(i);
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                symbol = sh.getELFSymbol(numSymbols - 1 - i);
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                ++i;
            }
        }
        if ((sh = this.getSymbolTableSection()) != null) {
            numSymbols = sh.getNumberOfSymbols();
            i = 0;
            while ((double)i < Math.ceil((double)numSymbols / 2.0)) {
                symbol = sh.getELFSymbol(i);
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                symbol = sh.getELFSymbol(numSymbols - 1 - i);
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                ++i;
            }
        }
        return null;
    }

    public ElfSymbol getELFSymbol(long address) throws ElfException, IOException {
        long value;
        ElfSymbol symbol;
        int i;
        int numSymbols;
        ElfSection sh = this.getDynamicSymbolTableSection();
        if (sh != null) {
            numSymbols = sh.getNumberOfSymbols();
            for (i = 0; i < numSymbols; ++i) {
                symbol = sh.getELFSymbol(i);
                value = symbol.value;
                if (address < value || address >= value + symbol.size) continue;
                return symbol;
            }
        }
        if ((sh = this.getSymbolTableSection()) != null) {
            numSymbols = sh.getNumberOfSymbols();
            for (i = 0; i < numSymbols; ++i) {
                symbol = sh.getELFSymbol(i);
                value = symbol.value;
                if (address < value || address >= value + symbol.size) continue;
                return symbol;
            }
        }
        return null;
    }

    public ElfSegment getProgramHeader(int index) throws IOException {
        return this.programHeaders[index].getValue();
    }

    public static ElfFile fromBytes(ByteBuffer buffer) throws ElfException {
        return new ElfFile(buffer);
    }

    private ElfFile(ByteBuffer buffer) throws ElfException {
        int i;
        byte[] ident = new byte[16];
        final ElfParser parser = new ElfParser(this, buffer);
        int bytesRead = parser.read(ident);
        if (bytesRead != ident.length) {
            throw new ElfException("Error reading elf header (read " + bytesRead + "bytes - expected to read " + ident.length + "bytes)");
        }
        if (127 != ident[0] || 69 != ident[1] || 76 != ident[2] || 70 != ident[3]) {
            throw new ElfException("Bad magic number for file");
        }
        this.objectSize = ident[4];
        if (this.objectSize != 1 && this.objectSize != 2) {
            throw new ElfException("Invalid object size class: " + this.objectSize);
        }
        this.encoding = ident[5];
        if (this.encoding != 1 && this.encoding != 2) {
            throw new ElfException("Invalid encoding: " + this.encoding);
        }
        byte elfVersion = ident[6];
        if (elfVersion != 1) {
            throw new ElfException("Invalid elf version: " + elfVersion);
        }
        this.file_type = parser.readShort();
        this.arch = parser.readShort();
        this.version = parser.readInt();
        this.entry_point = parser.readIntOrLong();
        this.ph_offset = parser.readIntOrLong();
        this.sh_offset = parser.readIntOrLong();
        this.flags = parser.readInt();
        this.eh_size = parser.readShort();
        this.ph_entry_size = parser.readShort();
        this.num_ph = parser.readShort();
        this.sh_entry_size = parser.readShort();
        this.num_sh = parser.readShort();
        if (this.num_sh == 0) {
            throw new ElfException("e_shnum is SHN_UNDEF(0), which is not supported yet (the actual number of section header table entries is contained in the sh_size field of the section header at index 0)");
        }
        this.sh_string_ndx = parser.readShort() & 0xFFFF;
        if (this.sh_string_ndx == 65535) {
            throw new ElfException("e_shstrndx is SHN_XINDEX(0xffff), which is not supported yet (the actual index of the section name string table section is contained in the sh_link field of the section header at index 0)");
        }
        this.sectionHeaders = MemoizedObject.uncheckedArray(this.num_sh);
        for (i = 0; i < this.num_sh; ++i) {
            final long sectionHeaderOffset = this.sh_offset + (long)(i * this.sh_entry_size);
            this.sectionHeaders[i] = new MemoizedObject<ElfSection>(){

                @Override
                public ElfSection computeValue() throws ElfException {
                    return new ElfSection(ElfFile.this, parser, sectionHeaderOffset);
                }
            };
        }
        this.programHeaders = MemoizedObject.uncheckedArray(this.num_ph);
        for (i = 0; i < this.num_ph; ++i) {
            final long programHeaderOffset = this.ph_offset + (long)(i * this.ph_entry_size);
            this.programHeaders[i] = new MemoizedObject<ElfSegment>(){

                @Override
                public ElfSegment computeValue() {
                    return new ElfSegment(ElfFile.this, parser, programHeaderOffset);
                }
            };
        }
    }

    public String getInterpreter() throws IOException {
        for (MemoizedObject<ElfSegment> programHeader : this.programHeaders) {
            ElfSegment ph = programHeader.getValue();
            if (ph.type != 3) continue;
            return ph.getInterpreter();
        }
        return null;
    }

    public long virtualMemoryAddrToFileOffset(long address) throws IOException {
        for (int i = 0; i < this.num_ph; ++i) {
            ElfSegment ph = this.getProgramHeader(i);
            if (address < ph.virtual_address || address >= ph.virtual_address + ph.mem_size) continue;
            long relativeOffset = address - ph.virtual_address;
            if (relativeOffset >= ph.file_size) {
                throw new ElfException("Can not convert virtual memory address " + Long.toHexString(address) + " to file offset - found segment " + ph + " but address maps to memory outside file range");
            }
            return ph.offset + relativeOffset;
        }
        throw new ElfException("Cannot find segment for address 0x" + Long.toHexString(address));
    }
}

