/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfStringTable;

public final class ElfSymbol {
    private static final int SHN_UNDEF = 0;
    public static final int BINDING_LOCAL = 0;
    public static final int BINDING_GLOBAL = 1;
    public static final int BINDING_WEAK = 2;
    public static final int BINDING_LOPROC = 13;
    public static final int BINDING_HIPROC = 15;
    public static final byte STT_NOTYPE = 0;
    public static final byte STT_OBJECT = 1;
    public static final byte STT_FUNC = 2;
    public static final byte STT_SECTION = 3;
    public static final byte STT_FILE = 4;
    public static final byte STT_COMMON = 5;
    public static final byte STT_TLS = 6;
    public static final byte STT_LOOS = 10;
    public static final byte STT_HIOS = 12;
    public static final byte STT_LOPROC = 13;
    public static final byte STT_HIPROC = 15;
    private final int name_ndx;
    public final long value;
    public final long size;
    private final short info;
    public final short other;
    public final short section_header_ndx;
    private final int section_type;
    public final long offset;
    private final ElfFile elfHeader;
    private ElfStringTable stringTable;

    ElfSymbol(ElfParser parser, long offset, int section_type) {
        this.elfHeader = parser.elfFile;
        parser.seek(offset);
        this.offset = offset;
        if (parser.elfFile.objectSize == 1) {
            this.name_ndx = parser.readInt();
            this.value = parser.readInt();
            this.size = parser.readInt();
            this.info = parser.readUnsignedByte();
            this.other = parser.readUnsignedByte();
            this.section_header_ndx = parser.readShort();
        } else {
            this.name_ndx = parser.readInt();
            this.info = parser.readUnsignedByte();
            this.other = parser.readUnsignedByte();
            this.section_header_ndx = parser.readShort();
            this.value = parser.readLong();
            this.size = parser.readLong();
        }
        this.section_type = section_type;
        switch (this.getType()) {
            default: 
        }
    }

    final boolean matches(long soaddr) {
        long value = this.value & 0xFFFFFFFFFFFFFFFEL;
        return this.section_header_ndx != 0 && soaddr >= value && soaddr < value + this.size;
    }

    ElfSymbol setStringTable(ElfStringTable stringTable) {
        this.stringTable = stringTable;
        return this;
    }

    public int getBinding() {
        return this.info >> 4;
    }

    public int getType() {
        return this.info & 0xF;
    }

    public String getName() throws ElfException, IOException {
        if (this.name_ndx == 0) {
            return null;
        }
        String symbol_name = null;
        if (this.stringTable != null) {
            symbol_name = this.stringTable.get(this.name_ndx);
        } else if (this.section_type == 2) {
            symbol_name = this.elfHeader.getStringTable().get(this.name_ndx);
        } else if (this.section_type == 11) {
            symbol_name = this.elfHeader.getDynamicStringTable().get(this.name_ndx);
        }
        return symbol_name;
    }

    public boolean isUndef() {
        return this.section_header_ndx == 0;
    }

    public String toString() {
        String typeString;
        switch (this.getType()) {
            case 0: 
            case 1: {
                typeString = "object";
                break;
            }
            case 2: {
                typeString = "function";
                break;
            }
            case 3: {
                typeString = "section";
                break;
            }
            case 4: {
                typeString = "file";
                break;
            }
            case 13: {
                typeString = "loproc";
                break;
            }
            case 15: {
                typeString = "hiproc";
                break;
            }
            default: {
                typeString = "???";
            }
        }
        try {
            return "ElfSymbol[name=" + this.getName() + ", type=" + typeString + ", size=" + this.size + "]";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

