/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.context;

import com.gomyck.trans4j.context.TransHolder;
import com.gomyck.trans4j.filter.FilterComposite;
import com.gomyck.trans4j.handler.ConverterHandlerComposite;
import com.gomyck.trans4j.handler.dictionary.DicConverterHandler;
import com.gomyck.trans4j.handler.dictionary.DicConverterInitConditional;
import com.gomyck.trans4j.handler.dictionary.DicInfoConverterHandlerFactory;
import com.gomyck.trans4j.handler.dictionary.serialize.AutoEncoder;
import com.gomyck.trans4j.profile.Trans4JProfiles;
import javax.sql.DataSource;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;

@Configuration
public class Trans4jContext
implements ApplicationListener<ContextRefreshedEvent> {
    private Trans4JProfiles trans4jProfiles;
    @Nullable
    private DataSource dataSource;
    @Nullable
    private AutoEncoder autoEncoder;

    @Bean
    @Order(value=-2147483648)
    public FilterComposite<?, ?> initFilterComposite() {
        return new FilterComposite();
    }

    @Bean
    @Order(value=-2147483648)
    public ConverterHandlerComposite initHandlerComposite() {
        return new ConverterHandlerComposite(this.initFilterComposite());
    }

    @Bean
    @Conditional(value={DicConverterInitConditional.class})
    public DicInfoConverterHandlerFactory initDicConverterHandlerFactory() {
        DicInfoConverterHandlerFactory dicInfoConverterHandlerFactory = new DicInfoConverterHandlerFactory();
        dicInfoConverterHandlerFactory.setTrans4jProfiles(this.trans4jProfiles);
        dicInfoConverterHandlerFactory.setDataSource(this.dataSource);
        dicInfoConverterHandlerFactory.setConverterHandlerComposite(this.initHandlerComposite());
        if (this.autoEncoder != null) {
            dicInfoConverterHandlerFactory.setAutoEncoder(this.autoEncoder);
        }
        return dicInfoConverterHandlerFactory;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        TransHolder.dicConverterHandler = (DicConverterHandler)this.initDicConverterHandlerFactory().getObject();
    }

    public Trans4jContext(Trans4JProfiles trans4jProfiles, @Nullable DataSource dataSource, @Nullable AutoEncoder autoEncoder) {
        this.trans4jProfiles = trans4jProfiles;
        this.dataSource = dataSource;
        this.autoEncoder = autoEncoder;
    }
}

