/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.converter.annotation;

import com.gomyck.trans4j.cache.MemCache4ResultConvert;
import com.gomyck.trans4j.converter.SimpleDefaultConverter;
import com.gomyck.trans4j.converter.annotation.TransEnhance;
import com.gomyck.trans4j.support.ConverterType;
import com.gomyck.trans4j.support.TransBus;
import com.gomyck.util.ObjectJudge;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Aspect
@Primary
@Component(value="MVCMessageAdvice-origin")
public class MVCMessageAdvice {
    private MemCache4ResultConvert memCache4ResultConvert;
    private SimpleDefaultConverter simpleDefaultConverter;

    @Pointcut(value="@annotation(com.gomyck.trans4j.converter.annotation.TransEnhance)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object aroundIt(ProceedingJoinPoint point) throws Throwable {
        Object proceed;
        MethodSignature signature;
        String methodName;
        String className = point.getTarget().getClass().getName();
        String fullMethodName = MessageFormat.format("{0}.{1}()", className, methodName = (signature = (MethodSignature)point.getSignature()).getName());
        TransEnhance annotation = (TransEnhance)this.memCache4ResultConvert.getCache(fullMethodName);
        if (annotation == null) {
            Method method = signature.getMethod();
            annotation = method.getAnnotation(TransEnhance.class);
            this.memCache4ResultConvert.setCache(fullMethodName, annotation);
        }
        if (annotation.overTurn()) {
            TransBus.overturn();
        }
        if (ObjectJudge.notNull((Object)annotation.i18nFlag())) {
            TransBus.setI18nFlag(annotation.i18nFlag());
        }
        TransBus.convert(annotation.converterType().length == 0 ? TransBus.DEFAULT_CONVERTER_TYPE : annotation.converterType());
        try {
            proceed = this.simpleDefaultConverter.doConvert(point.proceed());
        }
        catch (Exception e) {
            TransBus.clearCurrentBusInfo();
            throw e;
        }
        finally {
            if (!TransBus.getConvertType().contains((Object)ConverterType.RESPONSE_BODY_ADVICE_CONVERTER)) {
                TransBus.clearCurrentBusInfo();
            }
        }
        return proceed;
    }

    public MVCMessageAdvice(MemCache4ResultConvert memCache4ResultConvert, SimpleDefaultConverter simpleDefaultConverter) {
        this.memCache4ResultConvert = memCache4ResultConvert;
        this.simpleDefaultConverter = simpleDefaultConverter;
    }
}

