/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.filter.dictionary;

import com.gomyck.trans4j.filter.dictionary.AbstractDicConverterFilter;
import com.gomyck.trans4j.handler.dictionary.AfterDicHandleInfo;
import com.gomyck.trans4j.support.ConverterUtil;
import com.gomyck.util.DataFilter;
import com.gomyck.util.ObjectJudge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DicColMapColFilter
extends AbstractDicConverterFilter {
    private final List<Map<String, String>> includeColNames = new ArrayList<Map<String, String>>();
    private final List<String> ignoreColNames = new ArrayList<String>();
    private boolean convertOriginCol = false;

    @Override
    public int getOrder() {
        return 10;
    }

    @Override
    public void clearProp() {
        this.includeColNames.clear();
        this.ignoreColNames.clear();
        this.convertOriginCol = false;
    }

    @Override
    public void afterConvert(AfterDicHandleInfo convertInfo) {
        if (!this.convertOriginCol && this.ignoreColNames.contains(convertInfo.getCommonColName())) {
            convertInfo.setTargetValue(null);
        }
        this.includeColNames.forEach(e -> {
            String col = (String)e.get(convertInfo.getCommonColName());
            if (ObjectJudge.isNull((Object)col)) {
                return;
            }
            Map<String, Object> originDicInfo = convertInfo.getOverallDicInfo().get(col);
            convertInfo.setTargetValue(originDicInfo.get(DataFilter.toString((Object)convertInfo.getOriginValue())));
        });
    }

    private DicColMapColFilter() {
    }

    public static DicColMapColFilter init() {
        return new DicColMapColFilter();
    }

    public DicColMapColFilter addSpecialConvertColName(String originColName, String targetColName) {
        HashMap<String, String> specialCol = new HashMap<String, String>();
        originColName = ConverterUtil.getCommonColName(originColName);
        specialCol.put(ConverterUtil.getCommonColName(targetColName), originColName);
        this.includeColNames.add(specialCol);
        this.ignoreColNames.add(originColName);
        return this;
    }

    public DicColMapColFilter convertOriginCol() {
        this.convertOriginCol = true;
        return this;
    }
}

