/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.filter.dictionary;

import com.gomyck.trans4j.filter.dictionary.AbstractDicConverterFilter;
import com.gomyck.trans4j.handler.dictionary.AfterDicHandleInfo;
import com.gomyck.trans4j.support.ConverterUtil;
import com.gomyck.util.ObjectJudge;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class DicPartConvertFilter
extends AbstractDicConverterFilter {
    private final List<String> includeColNames = new ArrayList<String>();
    private Integer from = 0;
    private String endFlag = "-";

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public void clearProp() {
        this.includeColNames.clear();
        this.from = 0;
        this.endFlag = "-";
    }

    @Override
    public void afterConvert(AfterDicHandleInfo convertInfo) {
        this.includeColNames.forEach(commonColName -> {
            if (ObjectJudge.isNull((Object)commonColName)) {
                return;
            }
            if (commonColName.equals(convertInfo.getCommonColName())) {
                String preStr = "";
                String sufStr = "";
                String originValue = convertInfo.getOriginValue().toString();
                try {
                    preStr = originValue.substring(0, this.from);
                    originValue = originValue.substring(this.from);
                    sufStr = originValue.substring(originValue.indexOf(this.endFlag));
                    originValue = originValue.substring(0, originValue.indexOf(this.endFlag));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String finalPreStr = preStr;
                String finalSufStr = sufStr;
                convertInfo.setTargetWrapper(new HashMap<String, Function<Object, Object>>());
                convertInfo.getTargetWrapper().put((String)commonColName, e -> MessageFormat.format("{0}{1}{2}", finalPreStr, e.toString(), finalSufStr));
                convertInfo.setOriginValue(originValue);
                convertInfo.setTargetValue(convertInfo.getUsedDicInfo().get(originValue.trim()));
            }
        });
    }

    private DicPartConvertFilter() {
    }

    public static DicPartConvertFilter init() {
        return new DicPartConvertFilter();
    }

    public DicPartConvertFilter addPartColName(String colName) {
        this.includeColNames.add(ConverterUtil.getCommonColName(colName));
        return this;
    }

    public DicPartConvertFilter setPartFrom(Integer from) {
        this.from = from;
        return this;
    }

    public DicPartConvertFilter setEndFlag(String endFlag) {
        this.endFlag = endFlag;
        return this;
    }
}

