/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.support;

import com.gomyck.trans4j.filter.ConverterFilter;
import com.gomyck.trans4j.filter.InnerConverterFilter;
import com.gomyck.trans4j.handler.ConverterHandler;
import com.gomyck.trans4j.support.BusEnum;
import com.gomyck.trans4j.support.ConverterType;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.parallel.TL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class TransBus {
    public static ConverterType[] DEFAULT_CONVERTER_TYPE = new ConverterType[]{ConverterType.SIMPLE_DEFAULT_CONVERTER};
    private static final TL CONVERTER_SHARE_HOLDER = TL.init((String)"trans4j_bus_holder");

    public static void convert(ConverterType ... converterType) {
        if (converterType == null || converterType.length == 0) {
            return;
        }
        ArrayList<ConverterType> types = new ArrayList<ConverterType>(Arrays.asList(converterType));
        TransBus.threadLocalSet(BusEnum.CONVERT_STATUS, types);
    }

    public static List<ConverterType> getConvertType() {
        List converterTypes = (List)TransBus.threadLocalGet(BusEnum.CONVERT_STATUS);
        return converterTypes == null ? Collections.EMPTY_LIST : converterTypes;
    }

    public static void overturn() {
        TransBus.threadLocalSet(BusEnum.CONVERT_OVERTURN_STATUS, true);
    }

    public static boolean isOverturn() {
        return TransBus.threadLocalGet(BusEnum.CONVERT_OVERTURN_STATUS) != null;
    }

    public static void setI18nFlag(String flag) {
        TransBus.threadLocalSet(BusEnum.I18N_FLAG, ObjectJudge.isNull((Object)flag) ? "" : flag);
    }

    public static String getI18nFlag() {
        return TransBus.threadLocalGet(BusEnum.I18N_FLAG) == null ? null : Objects.requireNonNull(TransBus.threadLocalGet(BusEnum.I18N_FLAG)).toString();
    }

    public static void addTempFilter(InnerConverterFilter<?, ?> convertFilter) {
        ArrayList filters = (ArrayList)TransBus.threadLocalGet(BusEnum.CONVERT_FILTER);
        if (filters == null) {
            filters = new ArrayList();
            TransBus.threadLocalSet(BusEnum.CONVERT_FILTER, filters);
        }
        filters.add(convertFilter);
        filters.sort(Comparator.comparingInt(ConverterFilter::getOrder));
    }

    public static <T extends InnerConverterFilter<?, ?>> List<T> getTempFilter() {
        Object result = TransBus.threadLocalGet(BusEnum.CONVERT_FILTER);
        if (result == null) {
            return null;
        }
        return (List)result;
    }

    public static void setCurrentHandler(ConverterHandler converterHandler) {
        TransBus.threadLocalSet(BusEnum.CURRENT_CONVERTER_HANDLER, converterHandler);
    }

    public static ConverterHandler getCurrentHandler() {
        return (ConverterHandler)TransBus.threadLocalGet(BusEnum.CURRENT_CONVERTER_HANDLER);
    }

    public static void clearCurrentBusInfo() {
        CONVERTER_SHARE_HOLDER.clear();
    }

    private static void threadLocalSet(BusEnum key, Object value) {
        CONVERTER_SHARE_HOLDER.set((Object)key, value);
    }

    private static Object threadLocalGet(BusEnum key) {
        return CONVERTER_SHARE_HOLDER.get((Object)key);
    }
}

