/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Maps;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.processor.AutoValueProcessor;
import com.google.auto.value.processor.TypeSimplifier;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class ExtensionContext
implements AutoValueExtension.Context {
    private final ProcessingEnvironment processingEnvironment;
    private final TypeElement autoValueClass;
    private final $ImmutableMap<String, ExecutableElement> properties;
    private final $ImmutableMap<String, TypeMirror> propertyTypes;
    private final $ImmutableSet<ExecutableElement> abstractMethods;
    private Optional<AutoValueExtension.BuilderContext> builderContext = Optional.empty();

    ExtensionContext(ProcessingEnvironment processingEnvironment, TypeElement autoValueClass, $ImmutableMap<String, ExecutableElement> properties, $ImmutableMap<ExecutableElement, TypeMirror> propertyMethodsAndTypes, $ImmutableSet<ExecutableElement> abstractMethods) {
        this.processingEnvironment = processingEnvironment;
        this.autoValueClass = autoValueClass;
        this.properties = properties;
        this.propertyTypes = $ImmutableMap.copyOf($Maps.transformValues(properties, propertyMethodsAndTypes::get));
        this.abstractMethods = abstractMethods;
    }

    void setBuilderContext(AutoValueExtension.BuilderContext builderContext) {
        this.builderContext = Optional.of(builderContext);
    }

    @Override
    public ProcessingEnvironment processingEnvironment() {
        return this.processingEnvironment;
    }

    @Override
    public String packageName() {
        return TypeSimplifier.packageNameOf(this.autoValueClass);
    }

    @Override
    public TypeElement autoValueClass() {
        return this.autoValueClass;
    }

    @Override
    public String finalAutoValueClassName() {
        return AutoValueProcessor.generatedSubclassName(this.autoValueClass, 0);
    }

    @Override
    public Map<String, ExecutableElement> properties() {
        return this.properties;
    }

    @Override
    public Map<String, TypeMirror> propertyTypes() {
        return this.propertyTypes;
    }

    @Override
    public Set<ExecutableElement> abstractMethods() {
        return this.abstractMethods;
    }

    @Override
    public Optional<AutoValueExtension.BuilderContext> builder() {
        return this.builderContext;
    }
}

