/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeMetadata;
import com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest;
import com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.EstimateBillingServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.EstimateBillingServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EstimateBillingServiceClient
implements BackgroundResource {
    private final EstimateBillingServiceSettings settings;
    private final EstimateBillingServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;
    private final com.google.longrunning.OperationsClient operationsClient;

    public static final EstimateBillingServiceClient create() throws IOException {
        return EstimateBillingServiceClient.create(EstimateBillingServiceSettings.newBuilder().build());
    }

    public static final EstimateBillingServiceClient create(EstimateBillingServiceSettings settings) throws IOException {
        return new EstimateBillingServiceClient(settings);
    }

    public static final EstimateBillingServiceClient create(EstimateBillingServiceStub stub) {
        return new EstimateBillingServiceClient(stub);
    }

    protected EstimateBillingServiceClient(EstimateBillingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EstimateBillingServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EstimateBillingServiceClient(EstimateBillingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EstimateBillingServiceSettings getSettings() {
        return this.settings;
    }

    public EstimateBillingServiceStub getStub() {
        return this.stub;
    }

    public final com.google.longrunning.OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<EstimateDataSizeResponse, EstimateDataSizeMetadata> estimateDataSizeAsync(EstimateDataSizeRequest request) {
        return this.estimateDataSizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EstimateDataSizeRequest, EstimateDataSizeResponse, EstimateDataSizeMetadata> estimateDataSizeOperationCallable() {
        return this.stub.estimateDataSizeOperationCallable();
    }

    public final UnaryCallable<EstimateDataSizeRequest, Operation> estimateDataSizeCallable() {
        return this.stub.estimateDataSizeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

