/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.LayerEntry;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CacheStorageFiles;
import com.google.cloud.tools.jib.cache.CacheStorageReader;
import com.google.cloud.tools.jib.cache.CacheStorageWriter;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.LayerEntriesSelector;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.ManifestAndConfig;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Cache {
    private final CacheStorageWriter cacheStorageWriter;
    private final CacheStorageReader cacheStorageReader;

    public static Cache withDirectory(Path cacheDirectory) throws IOException {
        Files.createDirectories(cacheDirectory, new FileAttribute[0]);
        return new Cache(new CacheStorageFiles(cacheDirectory));
    }

    private Cache(CacheStorageFiles cacheStorageFiles) {
        this.cacheStorageWriter = new CacheStorageWriter(cacheStorageFiles);
        this.cacheStorageReader = new CacheStorageReader(cacheStorageFiles);
    }

    public void writeMetadata(ImageReference imageReference, BuildableManifestTemplate manifestTemplate, ContainerConfigurationTemplate containerConfigurationTemplate) throws IOException {
        this.cacheStorageWriter.writeMetadata(imageReference, manifestTemplate, containerConfigurationTemplate);
    }

    public void writeMetadata(ImageReference imageReference, V21ManifestTemplate manifestTemplate) throws IOException {
        this.cacheStorageWriter.writeMetadata(imageReference, manifestTemplate);
    }

    public CachedLayer writeCompressedLayer(Blob compressedLayerBlob) throws IOException {
        return this.cacheStorageWriter.writeCompressed(compressedLayerBlob);
    }

    public CachedLayer writeUncompressedLayer(Blob uncompressedLayerBlob, ImmutableList<LayerEntry> layerEntries) throws IOException {
        return this.cacheStorageWriter.writeUncompressed(uncompressedLayerBlob, LayerEntriesSelector.generateSelector(layerEntries));
    }

    public CachedLayer writeTarLayer(DescriptorDigest diffId, Blob compressedBlob) throws IOException {
        return this.cacheStorageWriter.writeTarLayer(diffId, compressedBlob);
    }

    public void writeLocalConfig(DescriptorDigest imageId, ContainerConfigurationTemplate containerConfiguration) throws IOException {
        this.cacheStorageWriter.writeLocalConfig(imageId, containerConfiguration);
    }

    public Optional<ManifestAndConfig> retrieveMetadata(ImageReference imageReference) throws IOException, CacheCorruptedException {
        return this.cacheStorageReader.retrieveMetadata(imageReference);
    }

    public Optional<CachedLayer> retrieve(ImmutableList<LayerEntry> layerEntries) throws IOException, CacheCorruptedException {
        Optional<DescriptorDigest> optionalSelectedLayerDigest = this.cacheStorageReader.select(LayerEntriesSelector.generateSelector(layerEntries));
        if (!optionalSelectedLayerDigest.isPresent()) {
            return Optional.empty();
        }
        return this.cacheStorageReader.retrieve(optionalSelectedLayerDigest.get());
    }

    public Optional<CachedLayer> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        return this.cacheStorageReader.retrieve(layerDigest);
    }

    public Optional<CachedLayer> retrieveTarLayer(DescriptorDigest diffId) throws IOException, CacheCorruptedException {
        return this.cacheStorageReader.retrieveTarLayer(diffId);
    }

    public Optional<ContainerConfigurationTemplate> retrieveLocalConfig(DescriptorDigest imageId) throws IOException {
        return this.cacheStorageReader.retrieveLocalConfig(imageId);
    }
}

