/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.image.ImageTarball;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class DockerClient {
    public static final Path DEFAULT_DOCKER_CLIENT = Paths.get("docker", new String[0]);
    private final Function<List<String>, ProcessBuilder> processBuilderFactory;

    public static boolean isDefaultDockerInstalled() {
        return DockerClient.isDockerInstalled(DEFAULT_DOCKER_CLIENT);
    }

    public static boolean isDockerInstalled(Path dockerExecutable) {
        try {
            new ProcessBuilder(dockerExecutable.toString()).start();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @VisibleForTesting
    static Function<List<String>, ProcessBuilder> defaultProcessBuilderFactory(String dockerExecutable, ImmutableMap<String, String> dockerEnvironment) {
        return dockerSubCommand -> {
            ArrayList<String> dockerCommand = new ArrayList<String>(1 + dockerSubCommand.size());
            dockerCommand.add(dockerExecutable);
            dockerCommand.addAll((Collection<String>)dockerSubCommand);
            ProcessBuilder processBuilder = new ProcessBuilder(dockerCommand);
            Map<String, String> environment = processBuilder.environment();
            environment.putAll((Map<String, String>)dockerEnvironment);
            return processBuilder;
        };
    }

    @VisibleForTesting
    static DockerImageDetails parseInspectResults(String inspectOutput) throws IOException {
        return JsonTemplateMapper.readJson(inspectOutput, DockerImageDetails.class);
    }

    private static String getStderrOutput(Process process) {
        String string;
        InputStreamReader stderr = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            string = CharStreams.toString((Readable)stderr);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    DockerClient.$closeResource(throwable, stderr);
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                return "unknown (failed to read error message from stderr due to " + ex.getMessage() + ")";
            }
        }
        DockerClient.$closeResource(throwable, stderr);
        return string;
    }

    public DockerClient(Path dockerExecutable, Map<String, String> dockerEnvironment) {
        this(DockerClient.defaultProcessBuilderFactory(dockerExecutable.toString(), (ImmutableMap<String, String>)ImmutableMap.copyOf(dockerEnvironment)));
    }

    @VisibleForTesting
    DockerClient(Function<List<String>, ProcessBuilder> processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    public String load(ImageTarball imageTarball, Consumer<Long> writtenByteCountListener) throws InterruptedException, IOException {
        Throwable throwable;
        Process dockerProcess = this.docker("load");
        try {
            throwable = null;
            try (NotifyingOutputStream stdin = new NotifyingOutputStream(dockerProcess.getOutputStream(), writtenByteCountListener);){
                imageTarball.writeTo(stdin);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ex) {
            String error;
            try (InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);){
                error = CharStreams.toString((Readable)stderr);
            }
            catch (IOException ignored) {
                error = ex.getMessage();
            }
            throw new IOException("'docker load' command failed with error: " + error, ex);
        }
        throwable = null;
        try (InputStreamReader stdout = new InputStreamReader(dockerProcess.getInputStream(), StandardCharsets.UTF_8);){
            String output = CharStreams.toString((Readable)stdout);
            if (dockerProcess.waitFor() != 0) {
                throw new IOException("'docker load' command failed with error: " + DockerClient.getStderrOutput(dockerProcess));
            }
            String string = output;
            return string;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public void save(ImageReference imageReference, Path outputPath, Consumer<Long> writtenByteCountListener) throws InterruptedException, IOException {
        Process dockerProcess = this.docker("save", imageReference.toString());
        try (BufferedInputStream stdout = new BufferedInputStream(dockerProcess.getInputStream());
             BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));
             NotifyingOutputStream notifyingFileStream = new NotifyingOutputStream(fileStream, writtenByteCountListener);){
            ByteStreams.copy((InputStream)stdout, (OutputStream)notifyingFileStream);
        }
        if (dockerProcess.waitFor() != 0) {
            throw new IOException("'docker save' command failed with error: " + DockerClient.getStderrOutput(dockerProcess));
        }
    }

    public DockerImageDetails inspect(ImageReference imageReference) throws IOException, InterruptedException {
        Process inspectProcess = this.docker("inspect", "-f", "{\"size\":{{.Size}},\"imageId\":\"{{.Id}}\",\"diffIds\":{{json .RootFS.Layers}}}", "--type", "image", imageReference.toString());
        if (inspectProcess.waitFor() != 0) {
            throw new IOException("'docker inspect' command failed with error: " + DockerClient.getStderrOutput(inspectProcess));
        }
        return DockerClient.parseInspectResults(CharStreams.toString((Readable)new InputStreamReader(inspectProcess.getInputStream(), StandardCharsets.UTF_8)).trim());
    }

    private Process docker(String ... subCommand) throws IOException {
        return this.processBuilderFactory.apply(Arrays.asList(subCommand)).start();
    }

    public static class DockerImageDetails
    implements JsonTemplate {
        private long size;
        private String imageId = "";
        private List<String> diffIds = Collections.emptyList();

        public DockerImageDetails() {
        }

        @VisibleForTesting
        public DockerImageDetails(long size, String imageId, List<String> diffIds) {
            this.size = size;
            this.imageId = imageId;
            this.diffIds = diffIds;
        }

        public long getSize() {
            return this.size;
        }

        public DescriptorDigest getImageId() throws DigestException {
            return DescriptorDigest.fromDigest(this.imageId);
        }

        public List<DescriptorDigest> getDiffIds() throws DigestException {
            ArrayList<DescriptorDigest> processedDiffIds = new ArrayList<DescriptorDigest>(this.diffIds.size());
            for (String diffId : this.diffIds) {
                processedDiffIds.add(DescriptorDigest.fromDigest(diffId.trim()));
            }
            return processedDiffIds;
        }
    }
}

