/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InsecureRegistryException;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.http.ResponseException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.ImageMetadataOutput;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpHostConnectException;

public class JibBuildRunner {
    private static final String STARTUP_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY = "Containerizing application to ";
    private static final String SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY = "Built and pushed image as ";
    private static final String STARTUP_MESSAGE_PREFIX_FOR_DOCKER_DAEMON = "Containerizing application to Docker daemon as ";
    private static final String SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_DAEMON = "Built image to Docker daemon as ";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_TARBALL = "Containerizing application to file at '%s'...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_TARBALL = "Built image tarball at \u001b[36m%s\u001b[0m";
    private final String startupMessage;
    private final String successMessage;
    private final JibContainerBuilder jibContainerBuilder;
    private final Containerizer containerizer;
    private final Consumer<LogEvent> logger;
    private final HelpfulSuggestions helpfulSuggestions;
    @Nullable
    private Path imageDigestOutputPath;
    @Nullable
    private Path imageIdOutputPath;
    @Nullable
    private Path imageJsonOutputPath;

    private static CharSequence colorCyan(CharSequence innerText) {
        return new StringBuilder().append("\u001b[36m").append(innerText).append("\u001b[0m");
    }

    private static String buildMessageWithTargetImageReferences(ImageReference targetImageReference, Set<String> additionalTags, String prefix, String suffix) {
        StringJoiner successMessageBuilder = new StringJoiner(", ", prefix, suffix);
        successMessageBuilder.add(JibBuildRunner.colorCyan(targetImageReference.toString()));
        for (String tag : additionalTags) {
            successMessageBuilder.add(JibBuildRunner.colorCyan(targetImageReference.withTag(tag).toString()));
        }
        return successMessageBuilder.toString();
    }

    public static JibBuildRunner forBuildImage(JibContainerBuilder jibContainerBuilder, Containerizer containerizer, Consumer<LogEvent> logger, HelpfulSuggestions helpfulSuggestions, ImageReference targetImageReference, Set<String> additionalTags) {
        return new JibBuildRunner(jibContainerBuilder, containerizer, logger, helpfulSuggestions, JibBuildRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, STARTUP_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY, "..."), JibBuildRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY, ""));
    }

    public static JibBuildRunner forBuildToDockerDaemon(JibContainerBuilder jibContainerBuilder, Containerizer containerizer, Consumer<LogEvent> logger, HelpfulSuggestions helpfulSuggestions, ImageReference targetImageReference, Set<String> additionalTags) {
        return new JibBuildRunner(jibContainerBuilder, containerizer, logger, helpfulSuggestions, JibBuildRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, STARTUP_MESSAGE_PREFIX_FOR_DOCKER_DAEMON, "..."), JibBuildRunner.buildMessageWithTargetImageReferences(targetImageReference, additionalTags, SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_DAEMON, ""));
    }

    public static JibBuildRunner forBuildTar(JibContainerBuilder jibContainerBuilder, Containerizer containerizer, Consumer<LogEvent> logger, HelpfulSuggestions helpfulSuggestions, Path outputPath) {
        return new JibBuildRunner(jibContainerBuilder, containerizer, logger, helpfulSuggestions, String.format(STARTUP_MESSAGE_FORMAT_FOR_TARBALL, outputPath.toString()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_TARBALL, outputPath.toString()));
    }

    private static void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpStatusCodeForbidden(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
        }
        throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialsDefined(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
    }

    @VisibleForTesting
    JibBuildRunner(JibContainerBuilder jibContainerBuilder, Containerizer containerizer, Consumer<LogEvent> logger, HelpfulSuggestions helpfulSuggestions, String startupMessage, String successMessage) {
        this.jibContainerBuilder = jibContainerBuilder;
        this.containerizer = containerizer;
        this.logger = logger;
        this.helpfulSuggestions = helpfulSuggestions;
        this.startupMessage = startupMessage;
        this.successMessage = successMessage;
    }

    public JibContainer runBuild() throws BuildStepsExecutionException, IOException, CacheDirectoryCreationException {
        try {
            this.logger.accept(LogEvent.lifecycle(""));
            this.logger.accept(LogEvent.lifecycle(this.startupMessage));
            JibContainer jibContainer = this.jibContainerBuilder.containerize(this.containerizer);
            this.logger.accept(LogEvent.lifecycle(""));
            this.logger.accept(LogEvent.lifecycle(this.successMessage));
            if (this.imageDigestOutputPath != null) {
                String imageDigest = jibContainer.getDigest().toString();
                Files.write(this.imageDigestOutputPath, imageDigest.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            if (this.imageIdOutputPath != null) {
                String imageId = jibContainer.getImageId().toString();
                Files.write(this.imageIdOutputPath, imageId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            if (this.imageJsonOutputPath != null) {
                ImageMetadataOutput metadataOutput = ImageMetadataOutput.fromJibContainer(jibContainer);
                String imageJson = metadataOutput.toJson();
                Files.write(this.imageJsonOutputPath, imageJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            return jibContainer;
        }
        catch (HttpHostConnectException ex) {
            throw new BuildStepsExecutionException(this.helpfulSuggestions.forHttpHostConnect(), ex);
        }
        catch (RegistryUnauthorizedException ex) {
            JibBuildRunner.handleRegistryUnauthorizedException(ex, this.helpfulSuggestions);
        }
        catch (RegistryCredentialsNotSentException ex) {
            throw new BuildStepsExecutionException(this.helpfulSuggestions.forCredentialsNotSent(), ex);
        }
        catch (RegistryAuthenticationFailedException ex) {
            if (ex.getCause() instanceof ResponseException) {
                JibBuildRunner.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(ex.getServerUrl(), ex.getImageName(), (ResponseException)ex.getCause()), this.helpfulSuggestions);
            }
            throw new BuildStepsExecutionException(this.helpfulSuggestions.none(), ex);
        }
        catch (UnknownHostException ex) {
            throw new BuildStepsExecutionException(this.helpfulSuggestions.forUnknownHost(), ex);
        }
        catch (InsecureRegistryException ex) {
            throw new BuildStepsExecutionException(this.helpfulSuggestions.forInsecureRegistry(), ex);
        }
        catch (RegistryException ex) {
            String message = (String)Verify.verifyNotNull((Object)ex.getMessage());
            throw new BuildStepsExecutionException(message, ex);
        }
        catch (ExecutionException ex) {
            String message = ex.getCause().getMessage();
            throw new BuildStepsExecutionException(message == null ? "(null exception message)" : message, ex.getCause());
        }
        catch (InterruptedException ex) {
            throw new BuildStepsExecutionException(this.helpfulSuggestions.none(), ex);
        }
        throw new IllegalStateException("unreachable");
    }

    public JibBuildRunner writeImageDigest(@Nullable Path imageDigestOutputPath) {
        this.imageDigestOutputPath = imageDigestOutputPath;
        return this;
    }

    public JibBuildRunner writeImageId(@Nullable Path imageIdOutputPath) {
        this.imageIdOutputPath = imageIdOutputPath;
        return this;
    }

    public JibBuildRunner writeImageJson(@Nullable Path imageJsonOutputPath) {
        this.imageJsonOutputPath = imageJsonOutputPath;
        return this;
    }
}

