/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.Port;
import com.google.cloud.tools.jib.api.Ports;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.DefaultCredentialRetrievers;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InferredAuthException;
import com.google.cloud.tools.jib.plugins.common.InferredAuthProvider;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidCreationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidFilesModificationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.JavaContainerBuilderHelper;
import com.google.cloud.tools.jib.plugins.common.JibBuildRunner;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.MainClassResolver;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import com.google.cloud.tools.jib.plugins.common.SkaffoldSyncMapTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public class PluginConfigurationProcessor {
    private static final ImmutableList<String> GENERATED_LAYERS = ImmutableList.of((Object)JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES.getName(), (Object)JavaContainerBuilder.LayerType.RESOURCES.getName(), (Object)JavaContainerBuilder.LayerType.CLASSES.getName());
    private static final ImmutableList<String> CONST_LAYERS = ImmutableList.of((Object)JavaContainerBuilder.LayerType.DEPENDENCIES.getName());

    public static JibBuildRunner createJibBuildRunnerForDockerDaemonImage(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException {
        ImageReference targetImageReference = PluginConfigurationProcessor.getGeneratedTargetDockerTag(rawConfiguration, projectProperties, helpfulSuggestions);
        DockerDaemonImage targetImage = DockerDaemonImage.named(targetImageReference);
        if (rawConfiguration.getDockerExecutable().isPresent()) {
            targetImage.setDockerExecutable(rawConfiguration.getDockerExecutable().get());
        }
        targetImage.setDockerEnvironment(rawConfiguration.getDockerEnvironment());
        Containerizer containerizer = Containerizer.to(targetImage);
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties, containerizer);
        return JibBuildRunner.forBuildToDockerDaemon(jibContainerBuilder, containerizer, projectProperties::log, helpfulSuggestions, targetImageReference, rawConfiguration.getToTags()).writeImageDigest(rawConfiguration.getDigestOutputPath()).writeImageId(rawConfiguration.getImageIdOutputPath()).writeImageJson(rawConfiguration.getImageJsonOutputPath());
    }

    public static JibBuildRunner createJibBuildRunnerForTarImage(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException {
        ImageReference targetImageReference = PluginConfigurationProcessor.getGeneratedTargetDockerTag(rawConfiguration, projectProperties, helpfulSuggestions);
        TarImage targetImage = TarImage.at(rawConfiguration.getTarOutputPath()).named(targetImageReference);
        Containerizer containerizer = Containerizer.to(targetImage);
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties, containerizer);
        jibContainerBuilder.setFormat(rawConfiguration.getImageFormat());
        return JibBuildRunner.forBuildTar(jibContainerBuilder, containerizer, projectProperties::log, helpfulSuggestions, rawConfiguration.getTarOutputPath()).writeImageDigest(rawConfiguration.getDigestOutputPath()).writeImageId(rawConfiguration.getImageIdOutputPath()).writeImageJson(rawConfiguration.getImageJsonOutputPath());
    }

    public static JibBuildRunner createJibBuildRunnerForRegistryImage(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException {
        Preconditions.checkArgument((boolean)rawConfiguration.getToImage().isPresent());
        ImageReference targetImageReference = ImageReference.parse(rawConfiguration.getToImage().get());
        RegistryImage targetImage = RegistryImage.named(targetImageReference);
        PluginConfigurationProcessor.configureCredentialRetrievers(rawConfiguration, projectProperties, targetImage, targetImageReference, "jib.to.auth.username", "jib.to.auth.password", rawConfiguration.getToAuth(), inferredAuthProvider, rawConfiguration.getToCredHelper().orElse(null));
        boolean alwaysCacheBaseImage = Boolean.parseBoolean(rawConfiguration.getProperty("jib.alwaysCacheBaseImage").orElse("false"));
        Containerizer containerizer = Containerizer.to(targetImage).setAlwaysCacheBaseImage(alwaysCacheBaseImage);
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties, containerizer);
        jibContainerBuilder.setFormat(rawConfiguration.getImageFormat());
        return JibBuildRunner.forBuildImage(jibContainerBuilder, containerizer, projectProperties::log, helpfulSuggestions, targetImageReference, rawConfiguration.getToTags()).writeImageDigest(rawConfiguration.getDigestOutputPath()).writeImageId(rawConfiguration.getImageIdOutputPath()).writeImageJson(rawConfiguration.getImageJsonOutputPath());
    }

    public static String getSkaffoldSyncMap(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws IOException, InvalidCreationTimeException, InvalidImageReferenceException, IncompatibleBaseImageJavaVersionException, InvalidContainerVolumeException, MainClassInferenceException, InvalidAppRootException, InvalidWorkingDirectoryException, InvalidFilesModificationTimeException, InvalidContainerizingModeException {
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, ignored -> Optional.empty(), projectProperties);
        SkaffoldSyncMapTemplate syncMap = new SkaffoldSyncMapTemplate();
        for (LayerConfiguration layer : jibContainerBuilder.describeContainer().getLayers()) {
            if (CONST_LAYERS.contains((Object)layer.getName())) continue;
            if (GENERATED_LAYERS.contains((Object)layer.getName())) {
                layer.getLayerEntries().stream().filter(layerEntry -> Files.isRegularFile(layerEntry.getSourceFile(), new LinkOption[0])).forEach(syncMap::addGenerated);
                continue;
            }
            layer.getLayerEntries().stream().filter(layerEntry -> Files.isRegularFile(layerEntry.getSourceFile(), new LinkOption[0])).forEach(syncMap::addDirect);
        }
        return syncMap.getJsonString();
    }

    @VisibleForTesting
    static JibContainerBuilder processCommonConfiguration(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties) throws InvalidFilesModificationTimeException, InvalidAppRootException, IncompatibleBaseImageJavaVersionException, IOException, InvalidImageReferenceException, InvalidContainerizingModeException, MainClassInferenceException, InvalidContainerVolumeException, InvalidWorkingDirectoryException, InvalidCreationTimeException {
        BiFunction<Path, AbsoluteUnixPath, Instant> modificationTimeProvider = PluginConfigurationProcessor.createModificationTimeProvider(rawConfiguration.getFilesModificationTime());
        JavaContainerBuilder javaContainerBuilder = PluginConfigurationProcessor.getJavaContainerBuilderWithBaseImage(rawConfiguration, projectProperties, inferredAuthProvider).setAppRoot(PluginConfigurationProcessor.getAppRootChecked(rawConfiguration, projectProperties)).setModificationTimeProvider(modificationTimeProvider);
        JibContainerBuilder jibContainerBuilder = projectProperties.createJibContainerBuilder(javaContainerBuilder, PluginConfigurationProcessor.getContainerizingModeChecked(rawConfiguration, projectProperties)).setEntrypoint(PluginConfigurationProcessor.computeEntrypoint(rawConfiguration, projectProperties)).setProgramArguments((List<String>)rawConfiguration.getProgramArguments().orElse(null)).setEnvironment(rawConfiguration.getEnvironment()).setExposedPorts((Set<Port>)Ports.parse(rawConfiguration.getPorts())).setVolumes(PluginConfigurationProcessor.getVolumesSet(rawConfiguration)).setLabels(rawConfiguration.getLabels()).setUser(rawConfiguration.getUser().orElse(null));
        PluginConfigurationProcessor.getWorkingDirectoryChecked(rawConfiguration).ifPresent(jibContainerBuilder::setWorkingDirectory);
        jibContainerBuilder.setCreationTime(PluginConfigurationProcessor.getCreationTime(rawConfiguration.getCreationTime(), projectProperties));
        for (Path directory : rawConfiguration.getExtraDirectories()) {
            if (!Files.exists(directory, new LinkOption[0])) continue;
            jibContainerBuilder.addLayer(JavaContainerBuilderHelper.extraDirectoryLayerConfiguration(directory, rawConfiguration.getExtraDirectoryPermissions(), modificationTimeProvider));
        }
        return jibContainerBuilder;
    }

    @VisibleForTesting
    static JibContainerBuilder processCommonConfiguration(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, Containerizer containerizer) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException {
        JibSystemProperties.checkHttpTimeoutProperty();
        JibSystemProperties.checkProxyPortProperty();
        if (JibSystemProperties.sendCredentialsOverHttp()) {
            projectProperties.log(LogEvent.warn("Authentication over HTTP is enabled. It is strongly recommended that you do not enable this on a public network!"));
        }
        PluginConfigurationProcessor.configureContainerizer(containerizer, rawConfiguration, projectProperties);
        return PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties);
    }

    @VisibleForTesting
    static JavaContainerBuilder getJavaContainerBuilderWithBaseImage(RawConfiguration rawConfiguration, ProjectProperties projectProperties, InferredAuthProvider inferredAuthProvider) throws IncompatibleBaseImageJavaVersionException, InvalidImageReferenceException, FileNotFoundException {
        String baseImageConfig;
        String string = baseImageConfig = rawConfiguration.getFromImage().isPresent() ? rawConfiguration.getFromImage().get() : PluginConfigurationProcessor.getDefaultBaseImage(projectProperties);
        if (baseImageConfig.startsWith("tar://")) {
            return JavaContainerBuilder.from(baseImageConfig);
        }
        String prefixRemoved = baseImageConfig.replaceFirst(".*://", "");
        int javaVersion = projectProperties.getMajorJavaVersion();
        if (PluginConfigurationProcessor.isKnownDistrolessJava8Image(prefixRemoved) && javaVersion > 8) {
            throw new IncompatibleBaseImageJavaVersionException(8, javaVersion);
        }
        if (PluginConfigurationProcessor.isKnownDistrolessJava11Image(prefixRemoved) && javaVersion > 11) {
            throw new IncompatibleBaseImageJavaVersionException(11, javaVersion);
        }
        ImageReference baseImageReference = ImageReference.parse(prefixRemoved);
        if (baseImageConfig.startsWith("docker://")) {
            DockerDaemonImage dockerDaemonImage = DockerDaemonImage.named(baseImageReference).setDockerEnvironment(rawConfiguration.getDockerEnvironment());
            if (rawConfiguration.getDockerExecutable().isPresent()) {
                dockerDaemonImage.setDockerExecutable(rawConfiguration.getDockerExecutable().get());
            }
            return JavaContainerBuilder.from(dockerDaemonImage);
        }
        RegistryImage baseImage = RegistryImage.named(baseImageReference);
        PluginConfigurationProcessor.configureCredentialRetrievers(rawConfiguration, projectProperties, baseImage, baseImageReference, "jib.from.auth.username", "jib.from.auth.password", rawConfiguration.getFromAuth(), inferredAuthProvider, rawConfiguration.getFromCredHelper().orElse(null));
        return JavaContainerBuilder.from(baseImage);
    }

    @Nullable
    @VisibleForTesting
    static List<String> computeEntrypoint(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws MainClassInferenceException, InvalidAppRootException, IOException, InvalidContainerizingModeException {
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(rawConfiguration, projectProperties);
        Optional<List<String>> rawEntrypoint = rawConfiguration.getEntrypoint();
        List<String> rawExtraClasspath = rawConfiguration.getExtraClasspath();
        if (rawEntrypoint.isPresent() && !rawEntrypoint.get().isEmpty()) {
            if (rawConfiguration.getMainClass().isPresent() || !rawConfiguration.getJvmFlags().isEmpty() || !rawExtraClasspath.isEmpty()) {
                projectProperties.log(LogEvent.warn("mainClass, extraClasspath, and jvmFlags are ignored when entrypoint is specified"));
            }
            if (rawEntrypoint.get().size() == 1 && "INHERIT".equals(rawEntrypoint.get().get(0))) {
                return null;
            }
            return rawEntrypoint.get();
        }
        if (projectProperties.isWarProject()) {
            if (rawConfiguration.getMainClass().isPresent() || !rawConfiguration.getJvmFlags().isEmpty() || !rawExtraClasspath.isEmpty()) {
                projectProperties.log(LogEvent.warn("mainClass, extraClasspath, and jvmFlags are ignored for WAR projects"));
            }
            return null;
        }
        ArrayList<String> classpath = new ArrayList<String>(rawExtraClasspath);
        ContainerizingMode mode = PluginConfigurationProcessor.getContainerizingModeChecked(rawConfiguration, projectProperties);
        switch (mode) {
            case EXPLODED: {
                classpath.add(appRoot.resolve("resources").toString());
                classpath.add(appRoot.resolve("classes").toString());
                classpath.add(appRoot.resolve("libs/*").toString());
                break;
            }
            case PACKAGED: {
                classpath.add(appRoot.resolve("classpath/*").toString());
                classpath.add(appRoot.resolve("libs/*").toString());
                break;
            }
            default: {
                throw new IllegalStateException("unknown containerizing mode: " + (Object)((Object)mode));
            }
        }
        String classpathString = String.join((CharSequence)":", classpath);
        String mainClass = MainClassResolver.resolveMainClass(rawConfiguration.getMainClass().orElse(null), projectProperties);
        ArrayList<String> entrypoint = new ArrayList<String>(4 + rawConfiguration.getJvmFlags().size());
        entrypoint.add("java");
        entrypoint.addAll(rawConfiguration.getJvmFlags());
        entrypoint.add("-cp");
        entrypoint.add(classpathString);
        entrypoint.add(mainClass);
        return entrypoint;
    }

    @VisibleForTesting
    static String getDefaultBaseImage(ProjectProperties projectProperties) throws IncompatibleBaseImageJavaVersionException {
        int javaVersion = projectProperties.getMajorJavaVersion();
        if (javaVersion <= 8) {
            return projectProperties.isWarProject() ? "gcr.io/distroless/java/jetty:java8" : "gcr.io/distroless/java:8";
        }
        if (javaVersion <= 11) {
            return projectProperties.isWarProject() ? "gcr.io/distroless/java/jetty:java11" : "gcr.io/distroless/java:11";
        }
        throw new IncompatibleBaseImageJavaVersionException(11, javaVersion);
    }

    @VisibleForTesting
    static Set<AbsoluteUnixPath> getVolumesSet(RawConfiguration rawConfiguration) throws InvalidContainerVolumeException {
        HashSet<AbsoluteUnixPath> volumes = new HashSet<AbsoluteUnixPath>();
        for (String path : rawConfiguration.getVolumes()) {
            try {
                AbsoluteUnixPath absoluteUnixPath = AbsoluteUnixPath.get(path);
                volumes.add(absoluteUnixPath);
            }
            catch (IllegalArgumentException exception) {
                throw new InvalidContainerVolumeException(path, path, exception);
            }
        }
        return volumes;
    }

    @VisibleForTesting
    static AbsoluteUnixPath getAppRootChecked(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws InvalidAppRootException {
        String appRoot = rawConfiguration.getAppRoot();
        if (appRoot.isEmpty()) {
            appRoot = projectProperties.isWarProject() ? "/jetty/webapps/ROOT" : "/app";
        }
        try {
            return AbsoluteUnixPath.get(appRoot);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidAppRootException(appRoot, appRoot, ex);
        }
    }

    static ContainerizingMode getContainerizingModeChecked(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws InvalidContainerizingModeException {
        ContainerizingMode mode = ContainerizingMode.from(rawConfiguration.getContainerizingMode());
        if (mode == ContainerizingMode.PACKAGED && projectProperties.isWarProject()) {
            throw new UnsupportedOperationException("packaged containerizing mode for WAR is not yet supported");
        }
        return mode;
    }

    @VisibleForTesting
    static Optional<AbsoluteUnixPath> getWorkingDirectoryChecked(RawConfiguration rawConfiguration) throws InvalidWorkingDirectoryException {
        if (!rawConfiguration.getWorkingDirectory().isPresent()) {
            return Optional.empty();
        }
        String path = rawConfiguration.getWorkingDirectory().get();
        try {
            return Optional.of(AbsoluteUnixPath.get(path));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidWorkingDirectoryException(path, path, ex);
        }
    }

    @VisibleForTesting
    static BiFunction<Path, AbsoluteUnixPath, Instant> createModificationTimeProvider(String modificationTime) throws InvalidFilesModificationTimeException {
        try {
            switch (modificationTime) {
                case "EPOCH_PLUS_SECOND": {
                    Instant epochPlusSecond = Instant.ofEpochSecond(1L);
                    return (ignored1, ignored2) -> epochPlusSecond;
                }
            }
            Instant timestamp = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)modificationTime, Instant::from);
            return (ignored1, ignored2) -> timestamp;
        }
        catch (DateTimeParseException ex) {
            throw new InvalidFilesModificationTimeException(modificationTime, modificationTime, ex);
        }
    }

    @VisibleForTesting
    static Instant getCreationTime(String configuredCreationTime, ProjectProperties projectProperties) throws DateTimeParseException, InvalidCreationTimeException {
        try {
            switch (configuredCreationTime) {
                case "EPOCH": {
                    return Instant.EPOCH;
                }
                case "USE_CURRENT_TIMESTAMP": {
                    projectProperties.log(LogEvent.warn("Setting image creation time to current time; your image may not be reproducible."));
                    return Instant.now();
                }
            }
            return DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)configuredCreationTime, Instant::from);
        }
        catch (DateTimeParseException ex) {
            throw new InvalidCreationTimeException(configuredCreationTime, configuredCreationTime, ex);
        }
    }

    private static void configureCredentialRetrievers(RawConfiguration rawConfiguration, ProjectProperties projectProperties, RegistryImage registryImage, ImageReference imageReference, String usernamePropertyName, String passwordPropertyName, AuthProperty rawAuthConfiguration, InferredAuthProvider inferredAuthProvider, @Nullable String credHelper) throws FileNotFoundException {
        DefaultCredentialRetrievers defaultCredentialRetrievers = DefaultCredentialRetrievers.init(CredentialRetrieverFactory.forImage(imageReference, projectProperties::log));
        Optional<Credential> optionalCredential = ConfigurationPropertyValidator.getImageCredential(projectProperties::log, usernamePropertyName, passwordPropertyName, rawAuthConfiguration, rawConfiguration);
        if (optionalCredential.isPresent()) {
            defaultCredentialRetrievers.setKnownCredential(optionalCredential.get(), rawAuthConfiguration.getAuthDescriptor());
        } else {
            try {
                Optional<AuthProperty> optionalInferredAuth = inferredAuthProvider.inferAuth(imageReference.getRegistry());
                if (optionalInferredAuth.isPresent()) {
                    AuthProperty auth = optionalInferredAuth.get();
                    String username = (String)Verify.verifyNotNull((Object)auth.getUsername());
                    String password = (String)Verify.verifyNotNull((Object)auth.getPassword());
                    Credential credential = Credential.from(username, password);
                    defaultCredentialRetrievers.setInferredCredential(credential, auth.getAuthDescriptor());
                }
            }
            catch (InferredAuthException ex) {
                projectProperties.log(LogEvent.warn("InferredAuthException: " + ex.getMessage()));
            }
        }
        defaultCredentialRetrievers.setCredentialHelper(credHelper);
        defaultCredentialRetrievers.asList().forEach(registryImage::addCredentialRetriever);
    }

    private static ImageReference getGeneratedTargetDockerTag(RawConfiguration rawConfiguration, ProjectProperties projectProperties, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException {
        return ConfigurationPropertyValidator.getGeneratedTargetDockerTag(rawConfiguration.getToImage().orElse(null), projectProperties, helpfulSuggestions);
    }

    private static void configureContainerizer(Containerizer containerizer, RawConfiguration rawConfiguration, ProjectProperties projectProperties) {
        projectProperties.configureEventHandlers(containerizer);
        containerizer.setOfflineMode(projectProperties.isOffline()).setToolName(projectProperties.getToolName()).setAllowInsecureRegistries(rawConfiguration.getAllowInsecureRegistries()).setBaseImageLayersCache(PluginConfigurationProcessor.getCheckedCacheDirectory("jib.baseImageCache", Boolean.getBoolean("jib.useOnlyProjectCache") ? projectProperties.getDefaultCacheDirectory() : Containerizer.DEFAULT_BASE_CACHE_DIRECTORY)).setApplicationLayersCache(PluginConfigurationProcessor.getCheckedCacheDirectory("jib.applicationCache", projectProperties.getDefaultCacheDirectory()));
        rawConfiguration.getToTags().forEach(containerizer::withAdditionalTag);
    }

    private static Path getCheckedCacheDirectory(String property, Path defaultPath) {
        if (System.getProperty(property) != null) {
            return Paths.get(System.getProperty(property), new String[0]);
        }
        return defaultPath;
    }

    private static boolean isKnownDistrolessJava8Image(String imageReference) {
        return imageReference.equals("gcr.io/distroless/java") || imageReference.equals("gcr.io/distroless/java:latest") || imageReference.equals("gcr.io/distroless/java:debug") || imageReference.equals("gcr.io/distroless/java:8") || imageReference.equals("gcr.io/distroless/java:8-debug") || imageReference.equals("gcr.io/distroless/java/jetty") || imageReference.equals("gcr.io/distroless/java/jetty:latest") || imageReference.equals("gcr.io/distroless/java/jetty:debug") || imageReference.equals("gcr.io/distroless/java/jetty:java8") || imageReference.equals("gcr.io/distroless/java/jetty:java8-debug");
    }

    private static boolean isKnownDistrolessJava11Image(String imageReference) {
        return imageReference.equals("gcr.io/distroless/java:11") || imageReference.equals("gcr.io/distroless/java:11-debug") || imageReference.equals("gcr.io/distroless/java/jetty:java11") || imageReference.equals("gcr.io/distroless/java/jetty:java11-debug");
    }
}

