/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.progress.ThrottledAccumulatingConsumer;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;

public class LocalBaseImageSteps {
    @VisibleForTesting
    static boolean isGzipped(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.mark(2);
            int magic = inputStream.read() & 0xFF | inputStream.read() << 8 & 0xFF00;
            boolean bl = magic == 35615;
            return bl;
        }
    }

    static Callable<LocalImage> retrieveDockerDaemonLayersStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, DockerClient dockerClient, TempDirectoryProvider tempDirectoryProvider) {
        return () -> {
            ImageReference imageReference = buildContext.getBaseImageConfiguration().getImage();
            ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("processing base image " + imageReference, 2L);
            Throwable throwable = null;
            try {
                LocalImage localImage;
                Throwable throwable2;
                TimerEventDispatcher ignored;
                block24: {
                    ignored = new TimerEventDispatcher(buildContext.getEventHandlers(), "Saving " + imageReference + " from Docker daemon");
                    throwable2 = null;
                    DockerClient.DockerImageDetails dockerImageDetails = dockerClient.inspect(imageReference);
                    Optional<LocalImage> cachedImage = LocalBaseImageSteps.getCachedDockerImage(buildContext.getBaseImageLayersCache(), dockerImageDetails);
                    if (!cachedImage.isPresent()) break block24;
                    LocalImage localImage2 = cachedImage.get();
                    LocalBaseImageSteps.$closeResource(throwable2, ignored);
                    return localImage2;
                }
                try {
                    Path tarPath = tempDirectoryProvider.newDirectory().resolve("out.tar");
                    long size = dockerClient.inspect(imageReference).getSize();
                    ProgressEventDispatcher dockerProgress = progressEventDispatcher.newChildProducer().create("saving base image " + imageReference, size);
                    Throwable throwable3 = null;
                    try {
                        ThrottledAccumulatingConsumer throttledProgressReporter = new ThrottledAccumulatingConsumer(dockerProgress::dispatchProgress);
                        Throwable throwable4 = null;
                        try {
                            dockerClient.save(imageReference, tarPath, throttledProgressReporter);
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            LocalBaseImageSteps.$closeResource(throwable4, throttledProgressReporter);
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (dockerProgress != null) {
                            LocalBaseImageSteps.$closeResource(throwable3, dockerProgress);
                        }
                    }
                    localImage = LocalBaseImageSteps.cacheDockerImageTar(buildContext, tarPath, progressEventDispatcher.newChildProducer(), tempDirectoryProvider);
                }
                catch (Throwable throwable7) {
                    try {
                        try {
                            throwable2 = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            LocalBaseImageSteps.$closeResource(throwable2, ignored);
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable = throwable9;
                        throw throwable9;
                    }
                }
                LocalBaseImageSteps.$closeResource(throwable2, ignored);
                return localImage;
            }
            finally {
                if (progressEventDispatcher != null) {
                    LocalBaseImageSteps.$closeResource(throwable, progressEventDispatcher);
                }
            }
        };
    }

    static Callable<LocalImage> retrieveTarLayersStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Path tarPath, TempDirectoryProvider tempDirectoryProvider) {
        return () -> LocalBaseImageSteps.cacheDockerImageTar(buildContext, tarPath, progressEventDispatcherFactory, tempDirectoryProvider);
    }

    static Callable<PullBaseImageStep.ImageAndRegistryClient> returnImageAndRegistryClientStep(List<PreparedLayer> layers, ContainerConfigurationTemplate configurationTemplate) {
        return () -> {
            V22ManifestTemplate v22Manifest = new V22ManifestTemplate();
            for (PreparedLayer layer : layers) {
                BlobDescriptor descriptor = layer.getBlobDescriptor();
                v22Manifest.addLayer(descriptor.getSize(), descriptor.getDigest());
            }
            BlobDescriptor configDescriptor = Blobs.from(configurationTemplate).writeTo(ByteStreams.nullOutputStream());
            v22Manifest.setContainerConfiguration(configDescriptor.getSize(), configDescriptor.getDigest());
            return new PullBaseImageStep.ImageAndRegistryClient(JsonToImageTranslator.toImage(v22Manifest, configurationTemplate), null);
        };
    }

    @VisibleForTesting
    static Optional<LocalImage> getCachedDockerImage(Cache cache, DockerClient.DockerImageDetails dockerImageDetails) throws DigestException, IOException, CacheCorruptedException {
        Optional<ContainerConfigurationTemplate> cachedConfig = cache.retrieveLocalConfig(dockerImageDetails.getImageId());
        if (!cachedConfig.isPresent()) {
            return Optional.empty();
        }
        ArrayList<Future<PreparedLayer>> cachedLayers = new ArrayList<Future<PreparedLayer>>();
        for (DescriptorDigest diffId : dockerImageDetails.getDiffIds()) {
            Optional<CachedLayer> cachedLayer = cache.retrieveTarLayer(diffId);
            if (!cachedLayer.isPresent()) {
                return Optional.empty();
            }
            CachedLayer layer = cachedLayer.get();
            cachedLayers.add((Future<PreparedLayer>)Futures.immediateFuture((Object)new PreparedLayer.Builder(layer).build()));
        }
        return Optional.of(new LocalImage(cachedLayers, cachedConfig.get()));
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    static LocalImage cacheDockerImageTar(BuildContext buildContext, Path tarPath, ProgressEventDispatcher.Factory progressEventDispatcherFactory, TempDirectoryProvider tempDirectoryProvider) throws IOException, LayerCountMismatchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PreparedLayer compressAndCacheTarLayer(Cache cache, DescriptorDigest diffId, Path layerFile, boolean layersAreCompressed, ProgressEventDispatcher.Factory progressEventDispatcherFactory) throws IOException, CacheCorruptedException {
        Throwable throwable = null;
        try (ProgressEventDispatcher childDispatcher = progressEventDispatcherFactory.create("compressing layer " + diffId, Files.size(layerFile));){
            PreparedLayer preparedLayer;
            Throwable throwable2;
            ThrottledAccumulatingConsumer throttledProgressReporter;
            block16: {
                block15: {
                    throttledProgressReporter = new ThrottledAccumulatingConsumer(childDispatcher::dispatchProgress);
                    throwable2 = null;
                    Optional<CachedLayer> optionalLayer = cache.retrieveTarLayer(diffId);
                    if (!optionalLayer.isPresent()) break block15;
                    PreparedLayer preparedLayer2 = new PreparedLayer.Builder(optionalLayer.get()).build();
                    LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
                    return preparedLayer2;
                }
                if (!layersAreCompressed) break block16;
                PreparedLayer preparedLayer3 = new PreparedLayer.Builder(cache.writeTarLayer(diffId, Blobs.from(layerFile))).build();
                LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
                return preparedLayer3;
            }
            try {
                Blob compressedBlob = Blobs.from(outputStream -> {
                    GZIPOutputStream compressorStream = new GZIPOutputStream(outputStream);
                    Throwable throwable = null;
                    try {
                        NotifyingOutputStream notifyingOutputStream = new NotifyingOutputStream(compressorStream, throttledProgressReporter);
                        Throwable throwable2 = null;
                        try {
                            Blobs.from(layerFile).writeTo(notifyingOutputStream);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            LocalBaseImageSteps.$closeResource(throwable2, notifyingOutputStream);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        LocalBaseImageSteps.$closeResource(throwable, compressorStream);
                    }
                });
                preparedLayer = new PreparedLayer.Builder(cache.writeTarLayer(diffId, compressedBlob)).build();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            LocalBaseImageSteps.$closeResource(throwable2, throttledProgressReporter);
            return preparedLayer;
        }
    }

    private static /* synthetic */ PreparedLayer lambda$cacheDockerImageTar$3(BuildContext buildContext, DescriptorDigest diffId, Path layerFile, boolean layersAreCompressed, ProgressEventDispatcher.Factory layerProgressDispatcherFactory) throws Exception {
        return LocalBaseImageSteps.compressAndCacheTarLayer(buildContext.getBaseImageLayersCache(), diffId, layerFile, layersAreCompressed, layerProgressDispatcherFactory);
    }

    static class LocalImage {
        final List<Future<PreparedLayer>> layers;
        final ContainerConfigurationTemplate configurationTemplate;

        LocalImage(List<Future<PreparedLayer>> layers, ContainerConfigurationTemplate configurationTemplate) {
            this.layers = layers;
            this.configurationTemplate = configurationTemplate;
        }
    }
}

