/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.util.SslUtils;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.http.ResponseException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;

public class FailoverHttpClient {
    private final boolean enableHttpAndInsecureFailover;
    private final boolean sendAuthorizationOverHttp;
    private final Consumer<LogEvent> logger;
    private final Supplier<HttpTransport> secureHttpTransportFactory;
    private final Supplier<HttpTransport> insecureHttpTransportFactory;
    private final ConcurrentHashMap<String, Failover> failoverHistory = new ConcurrentHashMap();
    private final Deque<HttpTransport> transportsCreated = new ArrayDeque<HttpTransport>();
    private final Deque<Response> responsesCreated = new ArrayDeque<Response>();

    private static boolean isHttpsProtocol(URL url) {
        return "https".equals(url.getProtocol());
    }

    private static URL toHttp(URL url) {
        GenericUrl httpUrl = new GenericUrl(url);
        httpUrl.setScheme("http");
        return httpUrl.toURL();
    }

    private static HttpTransport getSecureHttpTransport() {
        return new ApacheHttpTransport();
    }

    private static HttpTransport getInsecureHttpTransport() {
        try {
            HttpClientBuilder httpClientBuilder = ApacheHttpTransport.newDefaultHttpClientBuilder().setSSLSocketFactory(null).setSSLContext(SslUtils.trustAllSSLContext()).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
            return new ApacheHttpTransport((HttpClient)httpClientBuilder.build());
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("platform does not support TLS protocol", ex);
        }
    }

    public FailoverHttpClient(boolean enableHttpAndInsecureFailover, boolean sendAuthorizationOverHttp, Consumer<LogEvent> logger) {
        this(enableHttpAndInsecureFailover, sendAuthorizationOverHttp, logger, FailoverHttpClient::getSecureHttpTransport, FailoverHttpClient::getInsecureHttpTransport);
    }

    @VisibleForTesting
    FailoverHttpClient(boolean enableHttpAndInsecureFailover, boolean sendAuthorizationOverHttp, Consumer<LogEvent> logger, Supplier<HttpTransport> secureHttpTransportFactory, Supplier<HttpTransport> insecureHttpTransportFactory) {
        this.enableHttpAndInsecureFailover = enableHttpAndInsecureFailover;
        this.sendAuthorizationOverHttp = sendAuthorizationOverHttp;
        this.logger = logger;
        this.secureHttpTransportFactory = secureHttpTransportFactory;
        this.insecureHttpTransportFactory = insecureHttpTransportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws IOException {
        Deque<Object> deque = this.transportsCreated;
        synchronized (deque) {
            while (!this.transportsCreated.isEmpty()) {
                this.transportsCreated.peekFirst().shutdown();
                this.transportsCreated.removeFirst();
            }
        }
        deque = this.responsesCreated;
        synchronized (deque) {
            while (!this.responsesCreated.isEmpty()) {
                this.responsesCreated.peekFirst().close();
                this.responsesCreated.removeFirst();
            }
        }
    }

    public Response get(URL url, Request request) throws IOException {
        return this.call("GET", url, request);
    }

    public Response post(URL url, Request request) throws IOException {
        return this.call("POST", url, request);
    }

    public Response put(URL url, Request request) throws IOException {
        return this.call("PUT", url, request);
    }

    public Response call(String httpMethod, URL url, Request request) throws IOException {
        if (!FailoverHttpClient.isHttpsProtocol(url)) {
            if (this.enableHttpAndInsecureFailover) {
                return this.call(httpMethod, url, request, this.getHttpTransport(true));
            }
            throw new SSLException("insecure HTTP connection not allowed: " + url);
        }
        Optional<Response> fastPathResponse = this.followFailoverHistory(httpMethod, url, request);
        if (fastPathResponse.isPresent()) {
            return fastPathResponse.get();
        }
        try {
            return this.call(httpMethod, url, request, this.getHttpTransport(true));
        }
        catch (SSLException ex) {
            if (!this.enableHttpAndInsecureFailover) {
                throw ex;
            }
            try {
                this.logInsecureHttpsFailover(url);
                Response response = this.call(httpMethod, url, request, this.getHttpTransport(false));
                this.failoverHistory.put(url.getHost() + ":" + url.getPort(), Failover.INSECURE_HTTPS);
                return response;
            }
            catch (SSLException ignored) {
                this.logHttpFailover(url);
                Response response = this.call(httpMethod, FailoverHttpClient.toHttp(url), request, this.getHttpTransport(true));
                this.failoverHistory.put(url.getHost() + ":" + url.getPort(), Failover.HTTP);
                return response;
            }
        }
        catch (ConnectException ex) {
            if ((ex.getMessage() == null || !ex.getMessage().contains("timed out")) && this.enableHttpAndInsecureFailover && FailoverHttpClient.isHttpsProtocol(url) && url.getPort() == -1) {
                this.logHttpFailover(url);
                Response response = this.call(httpMethod, FailoverHttpClient.toHttp(url), request, this.getHttpTransport(true));
                this.failoverHistory.put(url.getHost() + ":" + url.getPort(), Failover.HTTP);
                return response;
            }
            throw ex;
        }
    }

    private Optional<Response> followFailoverHistory(String httpMethod, URL url, Request request) throws IOException {
        Preconditions.checkArgument((boolean)FailoverHttpClient.isHttpsProtocol(url));
        switch (this.failoverHistory.getOrDefault(url.getHost() + ":" + url.getPort(), Failover.NONE)) {
            case HTTP: {
                return Optional.of(this.call(httpMethod, FailoverHttpClient.toHttp(url), request, this.getHttpTransport(true)));
            }
            case INSECURE_HTTPS: {
                return Optional.of(this.call(httpMethod, url, request, this.getHttpTransport(false)));
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response call(String httpMethod, URL url, Request request, HttpTransport httpTransport) throws IOException {
        boolean clearAuthorization = !FailoverHttpClient.isHttpsProtocol(url) && !this.sendAuthorizationOverHttp;
        HttpHeaders requestHeaders = clearAuthorization ? request.getHeaders().clone().setAuthorization((String)null) : request.getHeaders();
        HttpRequest httpRequest = httpTransport.createRequestFactory().buildRequest(httpMethod, new GenericUrl(url), request.getHttpContent()).setUseRawRedirectUrls(true).setHeaders(requestHeaders);
        if (request.getHttpTimeout() != null) {
            httpRequest.setConnectTimeout(request.getHttpTimeout().intValue());
            httpRequest.setReadTimeout(request.getHttpTimeout().intValue());
        }
        try {
            Response response = new Response(httpRequest.execute());
            Deque<Response> deque = this.responsesCreated;
            synchronized (deque) {
                this.responsesCreated.add(response);
            }
            return response;
        }
        catch (HttpResponseException ex) {
            throw new ResponseException(ex, clearAuthorization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpTransport getHttpTransport(boolean secureTransport) {
        HttpTransport transport = secureTransport ? this.secureHttpTransportFactory.get() : this.insecureHttpTransportFactory.get();
        Deque<HttpTransport> deque = this.transportsCreated;
        synchronized (deque) {
            this.transportsCreated.add(transport);
        }
        return transport;
    }

    private void logHttpFailover(URL url) {
        String log = "Failed to connect to " + url + " over HTTPS. Attempting again with HTTP.";
        this.logger.accept(LogEvent.warn(log));
    }

    private void logInsecureHttpsFailover(URL url) {
        String log = "Cannot verify server at " + url + ". Attempting again with no TLS verification.";
        this.logger.accept(LogEvent.warn(log));
    }

    private static enum Failover {
        NONE,
        INSECURE_HTTPS,
        HTTP;

    }
}

