/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ManifestListTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class OciIndexTemplate
implements ManifestListTemplate {
    public static final String MEDIA_TYPE = "application/vnd.oci.image.index.v1+json";
    private final int schemaVersion = 2;
    private final String mediaType = "application/vnd.oci.image.index.v1+json";
    private final List<ManifestDescriptorTemplate> manifests = new ArrayList<ManifestDescriptorTemplate>();

    @Override
    public int getSchemaVersion() {
        return 2;
    }

    @Override
    public String getManifestMediaType() {
        return MEDIA_TYPE;
    }

    public void addManifest(BlobDescriptor descriptor, String imageReferenceName) {
        ManifestDescriptorTemplate contentDescriptorTemplate = new ManifestDescriptorTemplate("application/vnd.oci.image.manifest.v1+json", descriptor.getSize(), descriptor.getDigest());
        contentDescriptorTemplate.setAnnotations((Map<String, String>)ImmutableMap.of((Object)"org.opencontainers.image.ref.name", (Object)imageReferenceName));
        this.manifests.add(contentDescriptorTemplate);
    }

    public void addManifest(ManifestDescriptorTemplate manifest) {
        this.manifests.add(manifest);
    }

    @VisibleForTesting
    public List<ManifestDescriptorTemplate> getManifests() {
        return this.manifests;
    }

    @Override
    public List<String> getDigestsForPlatform(String architecture, String os) {
        return this.getManifests().stream().filter(manifest -> ((ManifestDescriptorTemplate)manifest).platform != null && os.equals(((ManifestDescriptorTemplate)manifest).platform.os) && architecture.equals(((ManifestDescriptorTemplate)manifest).platform.architecture)).map(BuildableManifestTemplate.ContentDescriptorTemplate::getDigest).filter(Objects::nonNull).map(DescriptorDigest::toString).collect(Collectors.toList());
    }

    public static class ManifestDescriptorTemplate
    extends BuildableManifestTemplate.ContentDescriptorTemplate {
        @Nullable
        private Platform platform;

        ManifestDescriptorTemplate(String mediaType, long size, DescriptorDigest digest) {
            super(mediaType, size, digest);
        }

        private ManifestDescriptorTemplate() {
        }

        public void setPlatform(String architecture, String os) {
            this.platform = new Platform();
            this.platform.architecture = architecture;
            this.platform.os = os;
        }

        @Nullable
        public Platform getPlatform() {
            return this.platform;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Platform
        implements JsonTemplate {
            @Nullable
            private String architecture;
            @Nullable
            private String os;

            @Nullable
            public String getArchitecture() {
                return this.architecture;
            }

            @Nullable
            public String getOs() {
                return this.os;
            }
        }
    }
}

