/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableMultimapBuilder<K, V> {
    private ListMultimap<K, V> multimap = new ArrayListMultimap();

    public ImmutableMultimapBuilder<K, V> put(@Nullable K key, @Nullable V value) {
        Preconditions.checkState(this.multimap != null, "multimap has already been created");
        this.multimap.put(key, value);
        return this;
    }

    public ImmutableMultimapBuilder<K, V> putAll(@Nullable K key, Iterable<? extends V> values) {
        Preconditions.checkState(this.multimap != null, "multimap has already been created");
        this.multimap.putAll(key, values);
        return this;
    }

    public ImmutableMultimapBuilder<K, V> putAll(@Nullable K key, V ... values) {
        Preconditions.checkState(this.multimap != null, "multimap has already been created");
        this.multimap.putAll(key, Arrays.asList(values));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListMultimap<K, V> getMultimap() {
        Preconditions.checkState(this.multimap != null, "multimap has already been created");
        try {
            ListMultimap<K, V> listMultimap = Multimaps.unmodifiableListMultimap(this.multimap);
            return listMultimap;
        }
        finally {
            this.multimap = null;
        }
    }
}

