/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.StandardSetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedHashMultimap<K, V>
extends StandardSetMultimap<K, V> {
    private final Collection<Map.Entry<K, V>> linkedEntries;
    private static final long serialVersionUID = -7860829607800920333L;

    public LinkedHashMultimap() {
        super(new LinkedHashMap());
        this.linkedEntries = Sets.newLinkedHashSet();
    }

    public LinkedHashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(new LinkedHashMap(Maps.capacity(multimap.keySet().size())));
        this.linkedEntries = new LinkedHashSet<Map.Entry<K, V>>(Maps.capacity(multimap.size()));
        this.putAll(multimap);
    }

    @Override
    Set<V> createCollection() {
        return new LinkedHashSet();
    }

    @Override
    Collection<V> createCollection(@Nullable K key) {
        return new SetDecorator(key, this.createCollection());
    }

    @Override
    Iterator<Map.Entry<K, V>> createEntryIterator() {
        final Iterator<Map.Entry<K, V>> delegateIterator = this.linkedEntries.iterator();
        return new Iterator<Map.Entry<K, V>>(){
            Map.Entry<K, V> entry;

            @Override
            public boolean hasNext() {
                return delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)delegateIterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                delegateIterator.remove();
                LinkedHashMultimap.this.remove(this.entry.getKey(), this.entry.getValue());
            }
        };
    }

    @Override
    public Set<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        return super.replaceValues((Object)key, (Iterable)values);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetDecorator
    extends ForwardingSet<V> {
        final K key;

        SetDecorator(K key, Set<V> delegate) {
            super(delegate);
            this.key = key;
        }

        <E> Map.Entry<K, E> createEntry(@Nullable E value) {
            return Maps.immutableEntry(this.key, value);
        }

        <E> Collection<Map.Entry<K, E>> createEntries(Collection<E> values) {
            ArrayList entries = Lists.newArrayListWithExpectedSize(values.size());
            for (E value : values) {
                entries.add(this.createEntry(value));
            }
            return entries;
        }

        @Override
        public boolean add(@Nullable V value) {
            boolean changed = super.add(value);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.add(this.createEntry(value));
            }
            return changed;
        }

        @Override
        public boolean addAll(Collection<? extends V> values) {
            boolean changed = super.addAll(values);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.addAll(this.createEntries(this.delegate()));
            }
            return changed;
        }

        @Override
        public void clear() {
            LinkedHashMultimap.this.linkedEntries.removeAll(this.createEntries(this.delegate()));
            super.clear();
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator delegateIterator = super.iterator();
            return new Iterator<V>(){
                V value;

                @Override
                public boolean hasNext() {
                    return delegateIterator.hasNext();
                }

                @Override
                public V next() {
                    this.value = delegateIterator.next();
                    return this.value;
                }

                @Override
                public void remove() {
                    delegateIterator.remove();
                    LinkedHashMultimap.this.linkedEntries.remove(SetDecorator.this.createEntry(this.value));
                }
            };
        }

        @Override
        public boolean remove(@Nullable Object value) {
            boolean changed = super.remove(value);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.remove(this.createEntry(value));
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> values) {
            boolean changed = super.removeAll(values);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.removeAll(this.createEntries(values));
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> values) {
            boolean changed = false;
            Iterator iterator = super.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (values.contains(value)) continue;
                iterator.remove();
                LinkedHashMultimap.this.linkedEntries.remove(Maps.immutableEntry(this.key, value));
                changed = true;
            }
            return changed;
        }
    }
}

