/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.nio;

import com.sun.tools.javac.file.BaseFileManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public abstract class PathFileObject
implements JavaFileObject {
    private final BaseFileManager fileManager;
    private final Path path;

    static PathFileObject createDirectoryPathFileObject(BaseFileManager fileManager, final Path path, final Path dir) {
        return new PathFileObject(fileManager, path){

            @Override
            public String inferBinaryName(Iterable<? extends Path> paths) {
                return 1.toBinaryName(dir.relativize(path));
            }
        };
    }

    public static PathFileObject createJarPathFileObject(BaseFileManager fileManager, final Path path) {
        return new PathFileObject(fileManager, path){

            @Override
            public String inferBinaryName(Iterable<? extends Path> paths) {
                return 2.toBinaryName(path);
            }
        };
    }

    public static PathFileObject createJRTPathFileObject(BaseFileManager fileManager, final Path path) {
        return new PathFileObject(fileManager, path){

            @Override
            public String inferBinaryName(Iterable<? extends Path> paths) {
                return 3.toBinaryName(path.subpath(1, path.getNameCount()));
            }
        };
    }

    static PathFileObject createSiblingPathFileObject(BaseFileManager fileManager, Path path, final String relativePath) {
        return new PathFileObject(fileManager, path){

            @Override
            public String inferBinaryName(Iterable<? extends Path> paths) {
                return 4.toBinaryName(relativePath, "/");
            }
        };
    }

    static PathFileObject createSimplePathFileObject(BaseFileManager fileManager, final Path path) {
        return new PathFileObject(fileManager, path){

            @Override
            public String inferBinaryName(Iterable<? extends Path> paths) {
                Path absPath = path.toAbsolutePath();
                for (Path path2 : paths) {
                    Path ap = path2.toAbsolutePath();
                    if (!absPath.startsWith(ap)) continue;
                    try {
                        Path rp = ap.relativize(absPath);
                        if (rp == null) continue;
                        return 5.toBinaryName(rp);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                return null;
            }
        };
    }

    protected PathFileObject(BaseFileManager fileManager, Path path) {
        this.fileManager = Objects.requireNonNull(fileManager);
        this.path = Objects.requireNonNull(path);
    }

    public abstract String inferBinaryName(Iterable<? extends Path> var1);

    public Path getPath() {
        return this.path;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return BaseFileManager.getKind(this.path.getFileName().toString());
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        Objects.requireNonNull(simpleName);
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String sn = simpleName + kind.extension;
        String pn = this.path.getFileName().toString();
        if (pn.equals(sn)) {
            return true;
        }
        if (pn.equalsIgnoreCase(sn)) {
            try {
                return this.path.toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString().equals(sn);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public String getName() {
        return this.path.toString();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        CharsetDecoder decoder = this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
        return new InputStreamReader(this.openInputStream(), decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer cb = this.fileManager.getCachedContent(this);
        if (cb == null) {
            try (InputStream in = this.openInputStream();){
                ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                JavaFileObject prev = this.fileManager.log.useSource(this);
                try {
                    cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                }
                finally {
                    this.fileManager.log.useSource(prev);
                }
                this.fileManager.recycleByteBuffer(bb);
                if (!ignoreEncodingErrors) {
                    this.fileManager.cache(this, cb);
                }
            }
        }
        return cb;
    }

    @Override
    public Writer openWriter() throws IOException {
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter(Files.newOutputStream(this.path, new OpenOption[0]), this.fileManager.getEncodingName());
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public boolean delete() {
        try {
            Files.delete(this.path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isSameFile(PathFileObject other) {
        try {
            return Files.isSameFile(this.path, other.path);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean equals(Object other) {
        return other instanceof PathFileObject && this.path.equals(((PathFileObject)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.path + "]";
    }

    private void ensureParentDirectoriesExist() throws IOException {
        Path parent = this.path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    private long size() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    protected static String toBinaryName(Path relativePath) {
        return PathFileObject.toBinaryName(relativePath.toString(), relativePath.getFileSystem().getSeparator());
    }

    protected static String toBinaryName(String relativePath, String sep) {
        return PathFileObject.removeExtension(relativePath).replace(sep, ".");
    }

    protected static String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        return lastDot == -1 ? fileName : fileName.substring(0, lastDot);
    }
}

