/*
 * Decompiled with CFR 0.152.
 */
package graphql.spring.web.servlet.components;

import graphql.ExecutionResult;
import graphql.Internal;
import graphql.spring.web.servlet.ExecutionResultHandler;
import graphql.spring.web.servlet.GraphQLInvocation;
import graphql.spring.web.servlet.GraphQLInvocationData;
import graphql.spring.web.servlet.JsonSerializer;
import graphql.spring.web.servlet.components.GraphQLRequestBody;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Internal
public class GraphQLController {
    @Autowired
    GraphQLInvocation graphQLInvocation;
    @Autowired
    ExecutionResultHandler executionResultHandler;
    @Autowired
    JsonSerializer jsonSerializer;

    @RequestMapping(value={"${graphql.url:graphql}"}, method={RequestMethod.POST}, produces={"application/json"})
    public Object graphqlPOST(@RequestHeader(value="Content-Type", required=false) String contentType, @RequestParam(value="query", required=false) String query, @RequestParam(value="operationName", required=false) String operationName, @RequestParam(value="variables", required=false) String variablesJson, @RequestBody(required=false) String body, WebRequest webRequest) throws IOException {
        if (body == null) {
            body = "";
        }
        if ("application/json".equals(contentType)) {
            GraphQLRequestBody request = this.jsonSerializer.deserialize(body, GraphQLRequestBody.class);
            if (request.getQuery() == null) {
                request.setQuery("");
            }
            return this.executeRequest(request.getQuery(), request.getOperationName(), request.getVariables(), webRequest);
        }
        if (query != null) {
            return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), webRequest);
        }
        if ("application/graphql".equals(contentType)) {
            return this.executeRequest(body, null, null, webRequest);
        }
        throw new ResponseStatusException(HttpStatus.UNPROCESSABLE_ENTITY, "Could not process GraphQL request");
    }

    @RequestMapping(value={"${graphql.url:graphql}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Object graphqlGET(@RequestParam(value="query") String query, @RequestParam(value="operationName", required=false) String operationName, @RequestParam(value="variables", required=false) String variablesJson, WebRequest webRequest) {
        return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), webRequest);
    }

    private Map<String, Object> convertVariablesJson(String jsonMap) {
        if (jsonMap == null) {
            return Collections.emptyMap();
        }
        return this.jsonSerializer.deserialize(jsonMap, Map.class);
    }

    private Object executeRequest(String query, String operationName, Map<String, Object> variables, WebRequest webRequest) {
        GraphQLInvocationData invocationData = new GraphQLInvocationData(query, operationName, variables);
        CompletableFuture<ExecutionResult> executionResult = this.graphQLInvocation.invoke(invocationData, webRequest);
        return this.executionResultHandler.handleExecutionResult(executionResult);
    }
}

