/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.reflect.util;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionConstantVisitor;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.reflect.FunctionReferenceInfo;
import proguard.classfile.kotlin.reflect.JavaFieldReferenceInfo;
import proguard.classfile.kotlin.reflect.JavaMethodReferenceInfo;
import proguard.classfile.kotlin.reflect.LocalVariableReferenceInfo;
import proguard.classfile.kotlin.reflect.PropertyReferenceInfo;
import proguard.classfile.kotlin.visitor.AllKotlinPropertiesVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.MethodToKotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinPropertyFilter;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class KotlinCallableReferenceInitializer
implements KotlinMetadataVisitor {
    private static final MemberFinder memberFinder = new MemberFinder();

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata syntheticClassKindMetadata) {
        if (clazz.extendsOrImplements("kotlin/jvm/internal/CallableReference")) {
            CallableReferenceInfoLoader infoLoader = new CallableReferenceInfoLoader();
            clazz.accept(infoLoader);
            if (infoLoader.hasResult()) {
                if (clazz.extendsOrImplements("kotlin/jvm/internal/FunctionReference")) {
                    Method method = memberFinder.findMethod(infoLoader.callableOwnerClass, infoLoader.callableName, infoLoader.callableSignature.substring(infoLoader.callableSignature.indexOf(40)));
                    if (method != null) {
                        Clazz methodReferencedClass = memberFinder.correspondingClass();
                        if (infoLoader.hasOwnerMetadata()) {
                            method.accept(methodReferencedClass, new MethodToKotlinFunctionVisitor(new FunctionReferenceInfoInitializer(infoLoader.callableOwnerClass, infoLoader.callableOwnerMetadata, syntheticClassKindMetadata)));
                        }
                        if (syntheticClassKindMetadata.callableReferenceInfo == null) {
                            syntheticClassKindMetadata.callableReferenceInfo = new JavaMethodReferenceInfo(infoLoader.callableOwnerClass, methodReferencedClass, method);
                        }
                    }
                } else if (clazz.extendsOrImplements("kotlin/jvm/internal/LocalVariableReference")) {
                    if (infoLoader.hasOwnerMetadata()) {
                        infoLoader.callableOwnerClass.kotlinMetadataAccept(new LocalVariableReferenceInfoInitializer(infoLoader.callableOwnerClass, infoLoader.callableOwnerMetadata, syntheticClassKindMetadata, infoLoader.callableName, infoLoader.callableSignature));
                    }
                } else if (clazz.extendsOrImplements("kotlin/jvm/internal/PropertyReference")) {
                    Field field;
                    if (infoLoader.hasOwnerMetadata()) {
                        try {
                            infoLoader.callableOwnerClass.hierarchyAccept(true, true, false, false, new ReferencedKotlinMetadataVisitor(new AllKotlinPropertiesVisitor(new KotlinPropertyFilter(prop -> prop.name.equals(infoLoader.callableName), (_clazz, declarationContainerMetadata, propertyMetadata) -> {
                                if (syntheticClassKindMetadata.callableReferenceInfo == null) {
                                    syntheticClassKindMetadata.callableReferenceInfo = new PropertyReferenceInfo(infoLoader.callableOwnerClass, infoLoader.callableOwnerMetadata, propertyMetadata);
                                    throw new PropertyFoundException();
                                }
                            }))));
                        }
                        catch (PropertyFoundException method) {
                            // empty catch block
                        }
                    }
                    if (syntheticClassKindMetadata.callableReferenceInfo == null && (field = memberFinder.findField(infoLoader.callableOwnerClass, infoLoader.callableName, infoLoader.callableSignature.substring(infoLoader.callableSignature.lastIndexOf(41) + 1))) != null) {
                        syntheticClassKindMetadata.callableReferenceInfo = new JavaFieldReferenceInfo(infoLoader.callableOwnerClass, memberFinder.correspondingClass(), field);
                    }
                }
            }
        }
    }

    private static class PropertyFoundException
    extends RuntimeException {
        private PropertyFoundException() {
        }
    }

    public static class LocalVariableReferenceInfoInitializer
    implements KotlinMetadataVisitor {
        private final Clazz ownerClass;
        private final KotlinDeclarationContainerMetadata owner;
        private final KotlinSyntheticClassKindMetadata syntheticClassKindMetadata;
        private final String name;
        private final String signature;

        LocalVariableReferenceInfoInitializer(Clazz ownerClass, KotlinDeclarationContainerMetadata ownerMetadata, KotlinSyntheticClassKindMetadata syntheticClassKindMetadata, String name, String signature) {
            this.ownerClass = ownerClass;
            this.owner = ownerMetadata;
            this.syntheticClassKindMetadata = syntheticClassKindMetadata;
            this.name = name;
            this.signature = signature;
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            this.syntheticClassKindMetadata.callableReferenceInfo = new LocalVariableReferenceInfo(this.ownerClass, this.owner, this.name, this.signature);
        }
    }

    private static class FunctionReferenceInfoInitializer
    implements KotlinFunctionVisitor {
        private final Clazz ownerClass;
        private final KotlinDeclarationContainerMetadata ownerMetadata;
        private final KotlinSyntheticClassKindMetadata syntheticClassKindMetadata;

        private FunctionReferenceInfoInitializer(Clazz ownerClass, KotlinDeclarationContainerMetadata ownerMetadata, KotlinSyntheticClassKindMetadata syntheticClassKindMetadata) {
            this.ownerClass = ownerClass;
            this.ownerMetadata = ownerMetadata;
            this.syntheticClassKindMetadata = syntheticClassKindMetadata;
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            this.syntheticClassKindMetadata.callableReferenceInfo = new FunctionReferenceInfo(this.ownerClass, this.ownerMetadata, kotlinFunctionMetadata);
        }
    }

    private static class CallableReferenceInfoLoader
    implements ClassVisitor,
    MemberVisitor,
    ConstantVisitor,
    KotlinMetadataVisitor {
        Clazz callableOwnerClass;
        KotlinDeclarationContainerMetadata callableOwnerMetadata;
        String callableName;
        String callableSignature;
        private String currentMethod;

        private CallableReferenceInfoLoader() {
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            clazz.methodsAccept(this);
            if (this.callableOwnerClass != null) {
                this.callableOwnerClass.kotlinMetadataAccept(this);
            }
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            this.currentMethod = programMethod.getName(programClass) + programMethod.getDescriptor(programClass);
            programMethod.accept(programClass, (MemberVisitor)new AllAttributeVisitor(new AllInstructionVisitor(new InstructionConstantVisitor(this))));
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            if (this.currentMethod.equals("getSignature()Ljava/lang/String;")) {
                this.callableSignature = stringConstant.getString(clazz);
            } else if (this.currentMethod.equals("getName()Ljava/lang/String;")) {
                this.callableName = stringConstant.getString(clazz);
            }
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            if (this.currentMethod.equals("getOwner()Lkotlin/reflect/KDeclarationContainer;")) {
                this.callableOwnerClass = classConstant.referencedClass;
            }
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            this.callableOwnerMetadata = kotlinDeclarationContainerMetadata;
        }

        boolean hasResult() {
            return this.callableOwnerClass != null && this.callableName != null && this.callableSignature != null;
        }

        boolean hasOwnerMetadata() {
            return this.callableOwnerMetadata != null;
        }
    }
}

