/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor.filter;

import java.util.function.Predicate;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadataAnnotation;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;

public class KotlinAnnotationFilter
implements KotlinAnnotationVisitor {
    private final Predicate<KotlinMetadataAnnotation> predicate;
    private final KotlinAnnotationVisitor acceptedKotlinAnnotationVisitor;
    private final KotlinAnnotationVisitor rejectedKotlinAnnotationVisitor;

    public KotlinAnnotationFilter(Predicate<KotlinMetadataAnnotation> predicate, KotlinAnnotationVisitor acceptedKotlinAnnotationVisitor) {
        this(predicate, acceptedKotlinAnnotationVisitor, null);
    }

    public KotlinAnnotationFilter(Predicate<KotlinMetadataAnnotation> predicate, KotlinAnnotationVisitor acceptedKotlinAnnotationVisitor, KotlinAnnotationVisitor rejectedKotlinAnnotationVisitor) {
        this.predicate = predicate;
        this.acceptedKotlinAnnotationVisitor = acceptedKotlinAnnotationVisitor;
        this.rejectedKotlinAnnotationVisitor = rejectedKotlinAnnotationVisitor;
    }

    @Override
    public void visitAnyAnnotation(Clazz clazz, KotlinMetadataAnnotation annotation) {
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinMetadataAnnotation annotation) {
        KotlinAnnotationVisitor delegate = this.getDelegate(annotation);
        if (delegate != null) {
            annotation.accept(clazz, kotlinTypeMetadata, delegate);
        }
    }

    @Override
    public void visitTypeParameterAnnotation(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata, KotlinMetadataAnnotation annotation) {
        KotlinAnnotationVisitor delegate = this.getDelegate(annotation);
        if (delegate != null) {
            annotation.accept(clazz, kotlinTypeParameterMetadata, delegate);
        }
    }

    @Override
    public void visitTypeAliasAnnotation(Clazz clazz, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinMetadataAnnotation annotation) {
        KotlinAnnotationVisitor delegate = this.getDelegate(annotation);
        if (delegate != null) {
            annotation.accept(clazz, kotlinTypeAliasMetadata, delegate);
        }
    }

    private KotlinAnnotationVisitor getDelegate(KotlinMetadataAnnotation kotlinMetadataAnnotation) {
        return this.predicate.test(kotlinMetadataAnnotation) ? this.acceptedKotlinAnnotationVisitor : this.rejectedKotlinAnnotationVisitor;
    }
}

