/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import proguard.classfile.Clazz;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.ReflectiveMethodCallUtil;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ExecutingInvocationUnit
extends BasicInvocationUnit {
    public static boolean DEBUG = System.getProperty("eiu") != null;
    private Value[] parameters;

    public ExecutingInvocationUnit(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, int parameterIndex, Value value) {
        if (this.parameters == null) {
            String type = anyMethodrefConstant.getType(clazz);
            int parameterCount = ClassUtil.internalMethodParameterCount(type, this.isStatic);
            this.parameters = new Value[parameterCount];
        }
        this.parameters[parameterIndex] = value;
    }

    @Override
    public boolean methodMayHaveSideEffects(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType) {
        return this.parameters != null && this.parameters.length > 0;
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType) {
        String baseClassName = anyMethodrefConstant.getClassName(clazz);
        if (!this.isSupportedMethodCall(baseClassName)) {
            return this.valueFactory.createValue(returnType, clazz, true, true);
        }
        Value reflectedReturnValue = this.handleMethodCall(clazz, anyMethodrefConstant, returnType, this.parameters, this.isStatic);
        this.updateStackAndVariables(clazz, anyMethodrefConstant, returnType, reflectedReturnValue);
        if (returnType.charAt(0) == 'V') {
            return null;
        }
        if (reflectedReturnValue == null) {
            return this.valueFactory.createValue(returnType, clazz, true, true);
        }
        return reflectedReturnValue;
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        super.visitAnyMethodrefConstant(clazz, anyMethodrefConstant);
        this.parameters = null;
    }

    private Value handleMethodCall(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType, Value[] parameter, boolean isStatic) {
        Object methodResult;
        int paramOffset;
        String baseClassName = anyMethodrefConstant.getClassName(clazz);
        String methodName = anyMethodrefConstant.getName(clazz);
        String parameterType = anyMethodrefConstant.getType(clazz);
        if (!isStatic && !parameter[0].isSpecific()) {
            return null;
        }
        for (int i = paramOffset = isStatic ? 0 : 1; i < parameter.length; ++i) {
            if (parameter[i].isParticular()) continue;
            return null;
        }
        boolean resultMayBeNull = true;
        boolean resultMayBeExtension = true;
        try {
            Class<?>[] parameterClasses = ReflectiveMethodCallUtil.stringtypesToClasses(parameterType);
            Object[] parameterObjects = new Object[parameter.length - paramOffset];
            for (int i = paramOffset; i < parameter.length; ++i) {
                parameterObjects[i - paramOffset] = ReflectiveMethodCallUtil.getObjectForValue(parameter[i], parameterClasses[i - paramOffset]);
            }
            if (methodName.equals("<init>")) {
                methodResult = ReflectiveMethodCallUtil.callConstructor(baseClassName.replace('/', '.'), parameterClasses, parameterObjects);
                resultMayBeNull = false;
                resultMayBeExtension = false;
            } else {
                String className;
                CharSequence callingInstance = null;
                if (isStatic) {
                    className = baseClassName.replace('/', '.');
                } else {
                    ReferenceValue instance = parameter[0].referenceValue();
                    className = ClassUtil.externalClassName(ClassUtil.internalClassNameFromClassType(instance.getType()));
                    switch (baseClassName) {
                        case "java/lang/StringBuilder": {
                            callingInstance = new StringBuilder((StringBuilder)instance.value());
                            break;
                        }
                        case "java/lang/StringBuffer": {
                            callingInstance = new StringBuffer((StringBuffer)instance.value());
                            break;
                        }
                        case "java/lang/String": {
                            callingInstance = (String)instance.value();
                        }
                    }
                }
                methodResult = ReflectiveMethodCallUtil.callMethod(className, methodName, callingInstance, parameterClasses, parameterObjects);
            }
        }
        catch (NullPointerException | InvocationTargetException e) {
            if (DEBUG) {
                System.err.println("Invocation exception during method execution: " + e.getCause().getClass().getSimpleName() + ": - " + e.getCause().getMessage());
            }
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException e) {
            if (DEBUG) {
                System.err.println("Error reflectively calling " + baseClassName + "." + methodName + parameterType + ": " + e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            return null;
        }
        if (returnType.length() == 1 && ClassUtil.isInternalPrimitiveType(returnType)) {
            return this.createPrimitiveValue(methodResult, returnType);
        }
        if (!isStatic && returnType.equals("V")) {
            returnType = parameter[0].referenceValue().getType();
        }
        return this.valueFactory.createReferenceValue(ClassUtil.internalClassNameFromClassType(returnType), clazz, resultMayBeExtension, resultMayBeNull, methodResult);
    }

    private Value createPrimitiveValue(Object obj, String type) {
        switch (type.charAt(0)) {
            case 'Z': {
                return this.valueFactory.createIntegerValue((Boolean)obj != false ? 1 : 0);
            }
            case 'C': {
                return this.valueFactory.createIntegerValue(((Character)obj).charValue());
            }
            case 'B': {
                return this.valueFactory.createIntegerValue(((Byte)obj).byteValue());
            }
            case 'S': {
                return this.valueFactory.createIntegerValue(((Short)obj).shortValue());
            }
            case 'I': {
                return this.valueFactory.createIntegerValue((Integer)obj);
            }
            case 'F': {
                return this.valueFactory.createFloatValue(((Float)obj).floatValue());
            }
            case 'D': {
                return this.valueFactory.createDoubleValue((Double)obj);
            }
            case 'J': {
                return this.valueFactory.createLongValue((Long)obj);
            }
        }
        return null;
    }

    private boolean isSupportedMethodCall(String baseClassName) {
        switch (baseClassName) {
            case "java/lang/StringBuilder": 
            case "java/lang/StringBuffer": 
            case "java/lang/String": {
                return true;
            }
        }
        return false;
    }

    private void replaceReferenceInVariables(Value newValue, Value oldValue, Variables variables) {
        if (oldValue.isSpecific() && variables != null) {
            for (int i = 0; i < variables.size(); ++i) {
                Value value = variables.getValue(i);
                if (Objects.equals(value, oldValue)) {
                    variables.store(i, newValue);
                }
                if (value == null || !value.isCategory2()) continue;
                ++i;
            }
        }
    }

    private void replaceReferenceOnStack(Value newValue, Value oldValue, Stack stack) {
        if (oldValue.isSpecific()) {
            for (int i = 0; i < stack.size(); ++i) {
                Value top = stack.getTop(i);
                if (!Objects.equals(top, oldValue)) continue;
                stack.setTop(i, newValue);
            }
        }
    }

    private static boolean alwaysReturnsNewInstance(String clazzName, String methodName) {
        switch (clazzName) {
            case "java/lang/StringBuilder": {
                if ("toString".equals(methodName)) {
                    return true;
                }
            }
            case "java/lang/StringBuffer": {
                if ("toString".equals(methodName)) {
                    return true;
                }
            }
            case "java/lang/String": {
                if (!"valueOf".equals(methodName)) break;
                return true;
            }
        }
        return false;
    }

    private static boolean alwaysModifiesInstance(String clazzName, String methodName) {
        return methodName.equals("<init>");
    }

    private void updateStackAndVariables(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType, Value reflectedReturnValue) {
        String baseClassName = anyMethodrefConstant.getClassName(clazz);
        String methodName = anyMethodrefConstant.getName(clazz);
        if (this.isStatic) {
            return;
        }
        if (ExecutingInvocationUnit.alwaysReturnsNewInstance(baseClassName, methodName)) {
            return;
        }
        if (ExecutingInvocationUnit.alwaysModifiesInstance(baseClassName, methodName) || Objects.equals(returnType, this.parameters[0].referenceValue().getType())) {
            Value updateValue = reflectedReturnValue;
            if (updateValue == null) {
                updateValue = this.valueFactory.createValue(returnType.charAt(0) == 'V' ? ClassUtil.internalTypeFromClassName(baseClassName) : returnType, clazz, true, true);
            }
            this.replaceReferenceInVariables(updateValue, this.parameters[0], this.variables);
            this.replaceReferenceOnStack(updateValue, this.parameters[0], this.stack);
        }
    }
}

