/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import proguard.analysis.cpa.util.TriFunction;

public class LimitedHashMap<K, V>
extends HashMap<K, V> {
    protected TriFunction<LimitedHashMap<K, V>, K, V, Optional<K>> removeElement;

    public LimitedHashMap(TriFunction<LimitedHashMap<K, V>, K, V, Optional<K>> removeElement) {
        this.removeElement = removeElement;
    }

    public LimitedHashMap(int initialCapacity, TriFunction<LimitedHashMap<K, V>, K, V, Optional<K>> removeElement) {
        super(initialCapacity);
        this.removeElement = removeElement;
    }

    public LimitedHashMap(Map<? extends K, ? extends V> m, TriFunction<LimitedHashMap<K, V>, K, V, Optional<K>> removeElement) {
        super(m);
        this.removeElement = removeElement;
    }

    @Override
    public V put(K key, V value) {
        V oldValue = super.put(key, value);
        this.removeElement.apply(this, key, value).ifPresent(this::remove);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.entrySet().forEach((? super T e) -> this.put(e.getKey(), e.getValue()));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V oldValue = super.putIfAbsent(key, value);
        if (oldValue == null) {
            Optional.ofNullable(this.get(key)).flatMap(v -> this.removeElement.apply(this, key, v)).ifPresent(this::remove);
        }
        return oldValue;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Object oldValue = this.get(key);
        V newValue = super.computeIfAbsent(key, mappingFunction);
        if (oldValue == null) {
            Optional.ofNullable(newValue).flatMap(v -> this.removeElement.apply(this, key, v)).ifPresent(this::remove);
        }
        return newValue;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V newValue = super.compute(key, remappingFunction);
        Optional.ofNullable(newValue).flatMap(v -> this.removeElement.apply(this, key, v)).ifPresent(this::remove);
        return newValue;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue = super.merge(key, value, remappingFunction);
        Optional.ofNullable(newValue).flatMap(v -> this.removeElement.apply(this, key, v)).ifPresent(this::remove);
        return newValue;
    }
}

