/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.value;

import java.util.Collection;
import java.util.Collections;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.DelegateAbstractDomain;
import proguard.analysis.cpa.defaults.DepthFirstWaitlist;
import proguard.analysis.cpa.defaults.HashMapAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.MergeJoinOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.defaults.StaticPrecisionAdjustment;
import proguard.analysis.cpa.defaults.StopJoinOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.interfaces.Waitlist;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.value.JvmCfaReferenceValueFactory;
import proguard.analysis.cpa.jvm.domain.value.JvmValueAbstractState;
import proguard.analysis.cpa.jvm.domain.value.JvmValueExpandOperator;
import proguard.analysis.cpa.jvm.domain.value.JvmValueReduceOperator;
import proguard.analysis.cpa.jvm.domain.value.JvmValueTransferRelation;
import proguard.analysis.cpa.jvm.domain.value.ValueAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmShallowHeapAbstractState;
import proguard.analysis.cpa.jvm.util.JvmBamCpaRun;
import proguard.classfile.ClassPool;
import proguard.classfile.MethodSignature;
import proguard.evaluation.ExecutingInvocationUnit;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ValueFactory;

public class JvmValueBamCpaRun
extends JvmBamCpaRun<SimpleCpa, JvmAbstractState<ValueAbstractState>, JvmValueAbstractState> {
    private final TransferRelationFactory transferRelationFactory;
    private final MethodSignature mainMethodSignature;
    private final ValueFactory valueFactory;
    private final ExecutingInvocationUnit executingInvocationUnit;
    private final JvmHeapAbstractState<ValueAbstractState> heap = new JvmShallowHeapAbstractState<JvmCfaNode, ValueAbstractState>(new HashMapAbstractState(), JvmCfaNode.class, ValueAbstractState.UNKNOWN);
    private final MapAbstractState<String, ValueAbstractState> staticFields;

    private JvmValueBamCpaRun(JvmCfa cfa, MethodSignature mainMethodSignature, ValueFactory valueFactory, TransferRelationFactory transferRelationFactory, ExecutingInvocationUnit executingInvocationUnit, int maxCallStackDepth, HeapModel heapModel, MapAbstractState<String, ValueAbstractState> staticFields, AbortOperator abortOperator, boolean reduceHeap) {
        super(cfa, maxCallStackDepth, heapModel, abortOperator, reduceHeap);
        this.valueFactory = valueFactory;
        this.transferRelationFactory = transferRelationFactory;
        this.executingInvocationUnit = executingInvocationUnit;
        this.mainMethodSignature = mainMethodSignature;
        this.staticFields = staticFields;
    }

    @Override
    public SimpleCpa createIntraproceduralCPA() {
        DelegateAbstractDomain abstractDomain = new DelegateAbstractDomain();
        return new SimpleCpa(abstractDomain, this.transferRelationFactory.newTransferRelation(this.valueFactory, this.executingInvocationUnit), new MergeJoinOperator(abstractDomain), new StopJoinOperator(abstractDomain), new StaticPrecisionAdjustment());
    }

    @Override
    public ReduceOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createReduceOperator() {
        return new JvmValueReduceOperator(this.valueFactory, this.executingInvocationUnit, this.reduceHeap);
    }

    @Override
    protected ReachedSet createReachedSet() {
        return new ProgramLocationDependentReachedSet();
    }

    @Override
    protected Waitlist createWaitlist() {
        return new DepthFirstWaitlist();
    }

    @Override
    public ExpandOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createExpandOperator() {
        return new JvmValueExpandOperator(this.valueFactory, this.executingInvocationUnit, this.cfa, this.reduceHeap);
    }

    @Override
    public MethodSignature getMainSignature() {
        return this.mainMethodSignature;
    }

    @Override
    public Collection<JvmValueAbstractState> getInitialStates() {
        return Collections.singletonList(new JvmValueAbstractState(this.valueFactory, this.executingInvocationUnit, (JvmCfaNode)this.cfa.getFunctionEntryNode(this.getMainSignature()), new JvmFrameAbstractState<ValueAbstractState>(), this.heap, this.staticFields));
    }

    public static class Builder
    extends JvmBamCpaRun.Builder {
        private MethodSignature mainSignature;
        private ValueFactory valueFactory;
        private TransferRelationFactory transferRelationFactory;
        private MapAbstractState<String, ValueAbstractState> staticFields = new HashMapAbstractState<String, ValueAbstractState>();
        private ClassPool libraryClassPool;

        public Builder(JvmCfa cfa, MethodSignature mainSignature, ClassPool libraryClassPool) {
            this.heapModel = HeapModel.SHALLOW;
            this.maxCallStackDepth = 10;
            this.cfa = cfa;
            this.valueFactory = new ParticularValueFactory(new JvmCfaReferenceValueFactory(cfa));
            this.mainSignature = mainSignature;
            this.transferRelationFactory = Builder::defaultTransferRelationFactory;
            this.libraryClassPool = libraryClassPool;
        }

        private static JvmValueTransferRelation defaultTransferRelationFactory(ValueFactory valueFactory, ExecutingInvocationUnit executingInvocationUnit) {
            return new JvmValueTransferRelation(valueFactory, executingInvocationUnit);
        }

        @Override
        public JvmValueBamCpaRun build() {
            return new JvmValueBamCpaRun(this.cfa, this.mainSignature, this.valueFactory, this.transferRelationFactory, new ExecutingInvocationUnit.Builder().setEnableSameInstanceIdApproximation(true).build(this.valueFactory, this.libraryClassPool), this.maxCallStackDepth, this.heapModel, this.staticFields, this.abortOperator, this.reduceHeap);
        }

        @Override
        public Builder setCfa(JvmCfa cfa) {
            throw new UnsupportedOperationException("CFA should only be set via the Builder constructor");
        }

        public Builder setMainSignature(MethodSignature mainSignature) {
            this.mainSignature = mainSignature;
            return this;
        }

        public Builder setValueFactory(ValueFactory valueFactory) {
            this.valueFactory = valueFactory;
            return this;
        }

        public Builder setTransferRelationFactory(TransferRelationFactory transferRelationFactory) {
            this.transferRelationFactory = transferRelationFactory;
            return this;
        }

        public Builder setStaticFields(MapAbstractState<String, ValueAbstractState> staticFields) {
            this.staticFields = staticFields;
            return this;
        }

        @Override
        public Builder setAbortOperator(AbortOperator abortOperator) {
            this.abortOperator = abortOperator;
            return this;
        }

        @Override
        public Builder setReduceHeap(boolean reduceHeap) {
            this.reduceHeap = reduceHeap;
            return this;
        }

        @Override
        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            return (Builder)super.setMaxCallStackDepth(maxCallStackDepth);
        }
    }

    public static interface TransferRelationFactory {
        public TransferRelation newTransferRelation(ValueFactory var1, ExecutingInvocationUnit var2);
    }
}

