/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;
import proguard.classfile.visitor.SignatureAdapter;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.ReflectionExecutor;
import proguard.evaluation.executor.instancehandler.ExecutorInstanceHandler;
import proguard.evaluation.executor.instancehandler.ExecutorMethodInstanceHandler;
import proguard.evaluation.value.ParticularReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.object.AnalyzedObject;
import proguard.evaluation.value.object.AnalyzedObjectFactory;
import proguard.util.ConstantMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.StringMatcher;

public class StringReflectionExecutor
extends ReflectionExecutor {
    private static final Logger log = LogManager.getLogger(StringReflectionExecutor.class);
    private final ClassPool libraryClassPool;

    public StringReflectionExecutor(ClassPool libraryClassPool) {
        this.libraryClassPool = libraryClassPool;
    }

    @Override
    public Optional<ReflectionExecutor.InstanceCopyResult> getInstanceOrCopyIfMutable(ReferenceValue instanceValue) {
        if (!(instanceValue instanceof ParticularReferenceValue)) {
            return Optional.empty();
        }
        AnalyzedObject instanceObject = instanceValue.getValue();
        if (instanceObject.isModeled()) {
            return Optional.empty();
        }
        if (instanceObject.isNull()) {
            return Optional.empty();
        }
        String type = instanceObject.getType();
        if (type == null) {
            throw new IllegalStateException("Unexpected null type on non-null instance object!");
        }
        switch (type) {
            case "Ljava/lang/StringBuilder;": {
                return Optional.of(new ReflectionExecutor.InstanceCopyResult(AnalyzedObjectFactory.createPrecise(new StringBuilder((StringBuilder)instanceObject.getPreciseValue())), true));
            }
            case "Ljava/lang/StringBuffer;": {
                return Optional.of(new ReflectionExecutor.InstanceCopyResult(AnalyzedObjectFactory.createPrecise(new StringBuffer((StringBuffer)instanceObject.getPreciseValue())), true));
            }
            case "Ljava/lang/String;": {
                return Optional.of(new ReflectionExecutor.InstanceCopyResult(instanceObject, false));
            }
        }
        return Optional.empty();
    }

    @Override
    public ExecutorInstanceHandler getDefaultInstanceHandler() {
        HashMap<String, StringMatcher> matcherMap = new HashMap<String, StringMatcher>();
        matcherMap.put("java/lang/String", new FixedStringMatcher("toString"));
        matcherMap.put("java/lang/StringBuffer", new ConstantMatcher(true));
        matcherMap.put("java/lang/StringBuilder", new ConstantMatcher(true));
        return new ExecutorMethodInstanceHandler(matcherMap);
    }

    @Override
    public Set<MethodSignature> getSupportedMethodSignatures() {
        Clazz stringClazz = this.libraryClassPool.getClass("java/lang/String");
        Clazz stringBuilderClazz = this.libraryClassPool.getClass("java/lang/StringBuilder");
        Clazz stringBufferClazz = this.libraryClassPool.getClass("java/lang/StringBuffer");
        if (stringClazz == null || stringBuilderClazz == null || stringBufferClazz == null) {
            log.warn("StringReflectionExecutor needs String, StringBuilder, and StringBuffer to be present in the library class pool, the executor will never be matched");
            return Collections.emptySet();
        }
        HashSet<MethodSignature> supportedSignatures = new HashSet<MethodSignature>();
        SignatureAdapter<MethodSignature> collector = new SignatureAdapter<MethodSignature>(supportedSignatures::add);
        stringClazz.methodsAccept(collector);
        stringBuilderClazz.methodsAccept(collector);
        stringBufferClazz.methodsAccept(collector);
        return supportedSignatures;
    }

    public static class Builder
    implements Executor.Builder<StringReflectionExecutor> {
        private final ClassPool libraryClassPool;

        public Builder(ClassPool libraryClassPool) {
            this.libraryClassPool = libraryClassPool;
        }

        @Override
        public StringReflectionExecutor build() {
            return new StringReflectionExecutor(this.libraryClassPool);
        }
    }
}

