/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.ArrayReferenceValueFactory;
import proguard.evaluation.value.DetailedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.evaluation.value.object.AnalyzedObject;
import proguard.evaluation.value.object.AnalyzedObjectFactory;

public class DetailedArrayValueFactory
extends IdentifiedValueFactory {
    @Deprecated
    public DetailedArrayValueFactory() {
        this(new TypedReferenceValueFactory());
    }

    public DetailedArrayValueFactory(ValueFactory referenceValueFactory) {
        super(new UnusableArrayValueFactory(), referenceValueFactory);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : (arrayLength.isParticular() ? new DetailedArrayReferenceValue('[' + type, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId()) : new IdentifiedArrayReferenceValue('[' + type, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId()));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, Object elementValues) {
        if (type == null) {
            return TypedReferenceValueFactory.REFERENCE_VALUE_NULL;
        }
        String arrayType = '[' + type;
        if (!arrayLength.isParticular()) {
            return new IdentifiedArrayReferenceValue(arrayType, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId());
        }
        if (!elementValues.getClass().isArray() || elementValues.getClass().getComponentType().isArray()) {
            throw new IllegalArgumentException("Only one-dimension array type is supported: " + elementValues.getClass());
        }
        DetailedArrayReferenceValue detailedArray = new DetailedArrayReferenceValue(arrayType, referencedClass, false, arrayLength, this, DetailedArrayValueFactory.generateReferenceId());
        switch (arrayType.charAt(1)) {
            case 'Z': {
                this.storeBooleanArray(detailedArray, (boolean[])elementValues);
                break;
            }
            case 'B': {
                this.storeByteArray(detailedArray, (byte[])elementValues);
                break;
            }
            case 'C': {
                this.storeCharArray(detailedArray, (char[])elementValues);
                break;
            }
            case 'S': {
                this.storeShortArray(detailedArray, (short[])elementValues);
                break;
            }
            case 'I': {
                this.storeIntArray(detailedArray, (int[])elementValues);
                break;
            }
            case 'J': {
                this.storeLongArray(detailedArray, (long[])elementValues);
                break;
            }
            case 'F': {
                this.storeFloatArray(detailedArray, (float[])elementValues);
                break;
            }
            case 'D': {
                this.storeDoubleArray(detailedArray, (double[])elementValues);
                break;
            }
            default: {
                this.storeObjectArray(detailedArray, (Object[])elementValues);
            }
        }
        return detailedArray;
    }

    private void storeBooleanArray(DetailedArrayReferenceValue detailedArray, boolean[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i] ? 1 : 0));
        }
    }

    private void storeByteArray(DetailedArrayReferenceValue detailedArray, byte[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeCharArray(DetailedArrayReferenceValue detailedArray, char[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeShortArray(DetailedArrayReferenceValue detailedArray, short[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeIntArray(DetailedArrayReferenceValue detailedArray, int[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createIntegerValue(elementValues[i]));
        }
    }

    private void storeLongArray(DetailedArrayReferenceValue detailedArray, long[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createLongValue(elementValues[i]));
        }
    }

    private void storeFloatArray(DetailedArrayReferenceValue detailedArray, float[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createFloatValue(elementValues[i]));
        }
    }

    private void storeDoubleArray(DetailedArrayReferenceValue detailedArray, double[] elementValues) {
        for (int i = 0; i < elementValues.length; ++i) {
            detailedArray.arrayStore(this.createIntegerValue(i), this.createDoubleValue(elementValues[i]));
        }
    }

    private void storeObjectArray(DetailedArrayReferenceValue detailedArray, Object[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            ReferenceValue elementValue;
            Object element = elements[i];
            if (element == null) {
                elementValue = this.createReferenceValueNull();
            } else {
                Clazz referencedClass = detailedArray.referencedClass;
                AnalyzedObject object = AnalyzedObjectFactory.create(element, ClassUtil.internalTypeFromClassName(referencedClass.getName()), referencedClass);
                elementValue = this.referenceValueFactory.createReferenceValue(referencedClass, ClassUtil.isExtendable(referencedClass), false, object);
            }
            detailedArray.arrayStore(this.createIntegerValue(i), elementValue);
        }
    }

    private static class UnusableArrayValueFactory
    extends ArrayReferenceValueFactory {
        private UnusableArrayValueFactory() {
        }

        @Override
        public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
            throw new IllegalStateException("This value factory should never be used, DetailedArrayValueFactory should override all methods calling this");
        }

        @Override
        public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, Object elementValues) {
            throw new IllegalStateException("This value factory should never be used, DetailedArrayValueFactory should override all methods calling this");
        }
    }
}

